/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservice.responses;

import com.oracle.bmc.datalabelingservice.model.Dataset;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CreateDatasetResponse
extends BmcResponse {
    private String etag;
    private String location;
    private String contentLocation;
    private String opcWorkRequestId;
    private String opcRequestId;
    private Dataset dataset;

    public String getEtag() {
        return this.etag;
    }

    public String getLocation() {
        return this.location;
    }

    public String getContentLocation() {
        return this.contentLocation;
    }

    public String getOpcWorkRequestId() {
        return this.opcWorkRequestId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Dataset getDataset() {
        return this.dataset;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "etag", "location", "contentLocation", "opcWorkRequestId", "opcRequestId", "dataset"})
    private CreateDatasetResponse(int __httpStatusCode__, Map<String, List<String>> headers, String etag, String location, String contentLocation, String opcWorkRequestId, String opcRequestId, Dataset dataset) {
        super(__httpStatusCode__, headers);
        this.etag = etag;
        this.location = location;
        this.contentLocation = contentLocation;
        this.opcWorkRequestId = opcWorkRequestId;
        this.opcRequestId = opcRequestId;
        this.dataset = dataset;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",etag=").append(String.valueOf(this.etag));
        sb.append(",location=").append(String.valueOf(this.location));
        sb.append(",contentLocation=").append(String.valueOf(this.contentLocation));
        sb.append(",opcWorkRequestId=").append(String.valueOf(this.opcWorkRequestId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",dataset=").append(String.valueOf((Object)this.dataset));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateDatasetResponse)) {
            return false;
        }
        CreateDatasetResponse other = (CreateDatasetResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.etag, other.etag) && Objects.equals(this.location, other.location) && Objects.equals(this.contentLocation, other.contentLocation) && Objects.equals(this.opcWorkRequestId, other.opcWorkRequestId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.dataset, (Object)other.dataset);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.etag == null ? 43 : this.etag.hashCode());
        result = result * 59 + (this.location == null ? 43 : this.location.hashCode());
        result = result * 59 + (this.contentLocation == null ? 43 : this.contentLocation.hashCode());
        result = result * 59 + (this.opcWorkRequestId == null ? 43 : this.opcWorkRequestId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.dataset == null ? 43 : this.dataset.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<CreateDatasetResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String etag;
        private String location;
        private String contentLocation;
        private String opcWorkRequestId;
        private String opcRequestId;
        private Dataset dataset;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder etag(String etag) {
            this.etag = etag;
            return this;
        }

        public Builder location(String location) {
            this.location = location;
            return this;
        }

        public Builder contentLocation(String contentLocation) {
            this.contentLocation = contentLocation;
            return this;
        }

        public Builder opcWorkRequestId(String opcWorkRequestId) {
            this.opcWorkRequestId = opcWorkRequestId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder dataset(Dataset dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder copy(CreateDatasetResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.etag(o.getEtag());
            this.location(o.getLocation());
            this.contentLocation(o.getContentLocation());
            this.opcWorkRequestId(o.getOpcWorkRequestId());
            this.opcRequestId(o.getOpcRequestId());
            this.dataset(o.getDataset());
            return this;
        }

        public CreateDatasetResponse build() {
            return new CreateDatasetResponse(this.__httpStatusCode__, this.headers, this.etag, this.location, this.contentLocation, this.opcWorkRequestId, this.opcRequestId, this.dataset);
        }
    }
}

