/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.datalabelingservicedataplane.DataLabelingAsync;
import com.oracle.bmc.datalabelingservicedataplane.model.Annotation;
import com.oracle.bmc.datalabelingservicedataplane.model.AnnotationAnalyticsAggregationCollection;
import com.oracle.bmc.datalabelingservicedataplane.model.AnnotationCollection;
import com.oracle.bmc.datalabelingservicedataplane.model.Dataset;
import com.oracle.bmc.datalabelingservicedataplane.model.Record;
import com.oracle.bmc.datalabelingservicedataplane.model.RecordAnalyticsAggregationCollection;
import com.oracle.bmc.datalabelingservicedataplane.model.RecordCollection;
import com.oracle.bmc.datalabelingservicedataplane.requests.CreateAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.CreateRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.DeleteAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.DeleteRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetDatasetRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordContentRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordPreviewContentRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.GetRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListAnnotationsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListRecordsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.SummarizeAnnotationAnalyticsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.SummarizeRecordAnalyticsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.UpdateAnnotationRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.UpdateRecordRequest;
import com.oracle.bmc.datalabelingservicedataplane.responses.CreateAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.CreateRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.DeleteAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.DeleteRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetDatasetResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordContentResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordPreviewContentResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.GetRecordResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListAnnotationsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListRecordsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.SummarizeAnnotationAnalyticsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.SummarizeRecordAnalyticsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.UpdateAnnotationResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.UpdateRecordResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.StreamUtils;
import com.oracle.bmc.util.internal.CollectionFormatType;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataLabelingAsyncClient
extends BaseAsyncClient
implements DataLabelingAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("DATALABELING").serviceEndpointPrefix("").serviceEndpointTemplate("https://datalabeling-dp.{region}.oci.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(DataLabelingAsyncClient.class);

    DataLabelingAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        this(builder, authenticationDetailsProvider, true);
    }

    DataLabelingAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider, boolean isStreamWarningEnabled) {
        super(builder, authenticationDetailsProvider);
        if (isStreamWarningEnabled && StreamUtils.isExtraStreamLogsEnabled()) {
            LOG.warn(StreamUtils.getStreamWarningMessage((String)"DataLabelingAsyncClient", (String)"getRecordContent,getRecordPreviewContent"));
        }
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<CreateAnnotationResponse> createAnnotation(CreateAnnotationRequest request, AsyncHandler<CreateAnnotationRequest, CreateAnnotationResponse> handler) {
        Objects.requireNonNull(request.getCreateAnnotationDetails(), "createAnnotationDetails is required");
        return this.clientCall(request, CreateAnnotationResponse::builder).logger(LOG, "createAnnotation").serviceDetails("DataLabeling", "CreateAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/CreateAnnotation").method(Method.POST).requestBuilder(CreateAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Annotation.class, CreateAnnotationResponse.Builder::annotation).handleResponseHeaderString("etag", CreateAnnotationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAnnotationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateRecordResponse> createRecord(CreateRecordRequest request, AsyncHandler<CreateRecordRequest, CreateRecordResponse> handler) {
        Objects.requireNonNull(request.getCreateRecordDetails(), "createRecordDetails is required");
        return this.clientCall(request, CreateRecordResponse::builder).logger(LOG, "createRecord").serviceDetails("DataLabeling", "CreateRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/CreateRecord").method(Method.POST).requestBuilder(CreateRecordRequest::builder).basePath("/20211001").appendPathParam("records").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Record.class, CreateRecordResponse.Builder::record).handleResponseHeaderString("etag", CreateRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAnnotationResponse> deleteAnnotation(DeleteAnnotationRequest request, AsyncHandler<DeleteAnnotationRequest, DeleteAnnotationResponse> handler) {
        Validate.notBlank((String)request.getAnnotationId(), (String)"annotationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteAnnotationResponse::builder).logger(LOG, "deleteAnnotation").serviceDetails("DataLabeling", "DeleteAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/DeleteAnnotation").method(Method.DELETE).requestBuilder(DeleteAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").appendPathParam(request.getAnnotationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteAnnotationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteRecordResponse> deleteRecord(DeleteRecordRequest request, AsyncHandler<DeleteRecordRequest, DeleteRecordResponse> handler) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteRecordResponse::builder).logger(LOG, "deleteRecord").serviceDetails("DataLabeling", "DeleteRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/DeleteRecord").method(Method.DELETE).requestBuilder(DeleteRecordRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAnnotationResponse> getAnnotation(GetAnnotationRequest request, AsyncHandler<GetAnnotationRequest, GetAnnotationResponse> handler) {
        Validate.notBlank((String)request.getAnnotationId(), (String)"annotationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAnnotationResponse::builder).logger(LOG, "getAnnotation").serviceDetails("DataLabeling", "GetAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/GetAnnotation").method(Method.GET).requestBuilder(GetAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").appendPathParam(request.getAnnotationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Annotation.class, GetAnnotationResponse.Builder::annotation).handleResponseHeaderString("etag", GetAnnotationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAnnotationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDatasetResponse> getDataset(GetDatasetRequest request, AsyncHandler<GetDatasetRequest, GetDatasetResponse> handler) {
        Validate.notBlank((String)request.getDatasetId(), (String)"datasetId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDatasetResponse::builder).logger(LOG, "getDataset").serviceDetails("DataLabeling", "GetDataset", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Dataset/GetDataset").method(Method.GET).requestBuilder(GetDatasetRequest::builder).basePath("/20211001").appendPathParam("datasets").appendPathParam(request.getDatasetId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Dataset.class, GetDatasetResponse.Builder::dataset).handleResponseHeaderString("etag", GetDatasetResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDatasetResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRecordResponse> getRecord(GetRecordRequest request, AsyncHandler<GetRecordRequest, GetRecordResponse> handler) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRecordResponse::builder).logger(LOG, "getRecord").serviceDetails("DataLabeling", "GetRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/GetRecord").method(Method.GET).requestBuilder(GetRecordRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(Record.class, GetRecordResponse.Builder::record).handleResponseHeaderString("etag", GetRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetRecordContentResponse> getRecordContent(GetRecordContentRequest request, AsyncHandler<GetRecordContentRequest, GetRecordContentResponse> handler) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRecordContentResponse::builder).logger(LOG, "getRecordContent").serviceDetails("DataLabeling", "GetRecordContent", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/GetRecordContent").method(Method.GET).requestBuilder(GetRecordContentRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(InputStream.class, GetRecordContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetRecordContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecordContentResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GetRecordContentResponse.Builder::contentLength).handleResponseHeaderString("content-disposition", GetRecordContentResponse.Builder::contentDisposition).handleResponseHeaderString("content-type", GetRecordContentResponse.Builder::contentType).handleResponseHeaderString("cache-control", GetRecordContentResponse.Builder::cacheControl).callAsync(handler);
    }

    @Override
    public Future<GetRecordPreviewContentResponse> getRecordPreviewContent(GetRecordPreviewContentRequest request, AsyncHandler<GetRecordPreviewContentRequest, GetRecordPreviewContentResponse> handler) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetRecordPreviewContentResponse::builder).logger(LOG, "getRecordPreviewContent").serviceDetails("DataLabeling", "GetRecordPreviewContent", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/GetRecordPreviewContent").method(Method.GET).requestBuilder(GetRecordPreviewContentRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).appendPathParam("preview").appendPathParam("content").accept(new String[]{"application/octet-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-none-match", request.getIfNoneMatch()).handleBody(InputStream.class, GetRecordPreviewContentResponse.Builder::inputStream).handleResponseHeaderString("etag", GetRecordPreviewContentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetRecordPreviewContentResponse.Builder::opcRequestId).handleResponseHeaderLong("content-length", GetRecordPreviewContentResponse.Builder::contentLength).handleResponseHeaderString("content-disposition", GetRecordPreviewContentResponse.Builder::contentDisposition).handleResponseHeaderString("content-type", GetRecordPreviewContentResponse.Builder::contentType).handleResponseHeaderString("cache-control", GetRecordPreviewContentResponse.Builder::cacheControl).callAsync(handler);
    }

    @Override
    public Future<ListAnnotationsResponse> listAnnotations(ListAnnotationsRequest request, AsyncHandler<ListAnnotationsRequest, ListAnnotationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return this.clientCall(request, ListAnnotationsResponse::builder).logger(LOG, "listAnnotations").serviceDetails("DataLabeling", "ListAnnotations", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/AnnotationCollection/ListAnnotations").method(Method.GET).requestBuilder(ListAnnotationsRequest::builder).basePath("/20211001").appendPathParam("annotations").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendQueryParam("updatedBy", (Object)request.getUpdatedBy()).appendQueryParam("recordId", (Object)request.getRecordId()).appendQueryParam("timeCreatedGreaterThanOrEqualTo", (Object)request.getTimeCreatedGreaterThanOrEqualTo()).appendQueryParam("timeCreatedLessThanOrEqualTo", (Object)request.getTimeCreatedLessThanOrEqualTo()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnotationCollection.class, ListAnnotationsResponse.Builder::annotationCollection).handleResponseHeaderString("opc-request-id", ListAnnotationsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListAnnotationsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<ListRecordsResponse> listRecords(ListRecordsRequest request, AsyncHandler<ListRecordsRequest, ListRecordsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return this.clientCall(request, ListRecordsResponse::builder).logger(LOG, "listRecords").serviceDetails("DataLabeling", "ListRecords", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/RecordCollection/ListRecords").method(Method.GET).requestBuilder(ListRecordsRequest::builder).basePath("/20211001").appendPathParam("records").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("id", (Object)request.getId()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendQueryParam("isLabeled", (Object)request.getIsLabeled()).appendListQueryParam("annotationLabelsContains", request.getAnnotationLabelsContains(), CollectionFormatType.Multi).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecordCollection.class, ListRecordsResponse.Builder::recordCollection).handleResponseHeaderString("opc-request-id", ListRecordsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", ListRecordsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeAnnotationAnalyticsResponse> summarizeAnnotationAnalytics(SummarizeAnnotationAnalyticsRequest request, AsyncHandler<SummarizeAnnotationAnalyticsRequest, SummarizeAnnotationAnalyticsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return this.clientCall(request, SummarizeAnnotationAnalyticsResponse::builder).logger(LOG, "summarizeAnnotationAnalytics").serviceDetails("DataLabeling", "SummarizeAnnotationAnalytics", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/AnnotationAnalyticsAggregationCollection/SummarizeAnnotationAnalytics").method(Method.GET).requestBuilder(SummarizeAnnotationAnalyticsRequest::builder).basePath("/20211001").appendPathParam("annotationAnalytics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("label", (Object)request.getLabel()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("annotationGroupBy", (BmcEnum)request.getAnnotationGroupBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(AnnotationAnalyticsAggregationCollection.class, SummarizeAnnotationAnalyticsResponse.Builder::annotationAnalyticsAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeAnnotationAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeAnnotationAnalyticsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<SummarizeRecordAnalyticsResponse> summarizeRecordAnalytics(SummarizeRecordAnalyticsRequest request, AsyncHandler<SummarizeRecordAnalyticsRequest, SummarizeRecordAnalyticsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getDatasetId(), "datasetId is required");
        return this.clientCall(request, SummarizeRecordAnalyticsResponse::builder).logger(LOG, "summarizeRecordAnalytics").serviceDetails("DataLabeling", "SummarizeRecordAnalytics", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/RecordAnalyticsAggregationCollection/SummarizeRecordAnalytics").method(Method.GET).requestBuilder(SummarizeRecordAnalyticsRequest::builder).basePath("/20211001").appendPathParam("recordAnalytics").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("datasetId", (Object)request.getDatasetId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("recordGroupBy", (BmcEnum)request.getRecordGroupBy()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(RecordAnalyticsAggregationCollection.class, SummarizeRecordAnalyticsResponse.Builder::recordAnalyticsAggregationCollection).handleResponseHeaderString("opc-request-id", SummarizeRecordAnalyticsResponse.Builder::opcRequestId).handleResponseHeaderString("opc-next-page", SummarizeRecordAnalyticsResponse.Builder::opcNextPage).callAsync(handler);
    }

    @Override
    public Future<UpdateAnnotationResponse> updateAnnotation(UpdateAnnotationRequest request, AsyncHandler<UpdateAnnotationRequest, UpdateAnnotationResponse> handler) {
        Validate.notBlank((String)request.getAnnotationId(), (String)"annotationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateAnnotationDetails(), "updateAnnotationDetails is required");
        return this.clientCall(request, UpdateAnnotationResponse::builder).logger(LOG, "updateAnnotation").serviceDetails("DataLabeling", "UpdateAnnotation", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Annotation/UpdateAnnotation").method(Method.PUT).requestBuilder(UpdateAnnotationRequest::builder).basePath("/20211001").appendPathParam("annotations").appendPathParam(request.getAnnotationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Annotation.class, UpdateAnnotationResponse.Builder::annotation).handleResponseHeaderString("etag", UpdateAnnotationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateAnnotationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateRecordResponse> updateRecord(UpdateRecordRequest request, AsyncHandler<UpdateRecordRequest, UpdateRecordResponse> handler) {
        Validate.notBlank((String)request.getRecordId(), (String)"recordId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateRecordDetails(), "updateRecordDetails is required");
        return this.clientCall(request, UpdateRecordResponse::builder).logger(LOG, "updateRecord").serviceDetails("DataLabeling", "UpdateRecord", "https://docs.oracle.com/iaas/api/#/en/datalabeling-dp/20211001/Record/UpdateRecord").method(Method.PUT).requestBuilder(UpdateRecordRequest::builder).basePath("/20211001").appendPathParam("records").appendPathParam(request.getRecordId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(Record.class, UpdateRecordResponse.Builder::record).handleResponseHeaderString("etag", UpdateRecordResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateRecordResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public DataLabelingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)DataLabelingAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(DataLabelingAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)DataLabelingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)DataLabelingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)DataLabelingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)DataLabelingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public DataLabelingAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)DataLabelingAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, DataLabelingAsyncClient> {
        private boolean isStreamWarningEnabled = true;

        private Builder(Service service) {
            super(service);
            String packageName = "datalabelingservicedataplane";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"datalabelingservicedataplane");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public Builder isStreamWarningEnabled(boolean isStreamWarningEnabled) {
            this.isStreamWarningEnabled = isStreamWarningEnabled;
            return this;
        }

        public DataLabelingAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new DataLabelingAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider, this.isStreamWarningEnabled);
        }
    }
}

