/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datalabelingservicedataplane;

import com.oracle.bmc.datalabelingservicedataplane.DataLabeling;
import com.oracle.bmc.datalabelingservicedataplane.model.AnnotationSummary;
import com.oracle.bmc.datalabelingservicedataplane.model.RecordSummary;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListAnnotationsRequest;
import com.oracle.bmc.datalabelingservicedataplane.requests.ListRecordsRequest;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListAnnotationsResponse;
import com.oracle.bmc.datalabelingservicedataplane.responses.ListRecordsResponse;
import com.oracle.bmc.paginator.internal.RequestBuilderAndToken;
import com.oracle.bmc.paginator.internal.ResponseIterable;
import com.oracle.bmc.paginator.internal.ResponseRecordIterable;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;

public class DataLabelingPaginators {
    private final DataLabeling client;

    public DataLabelingPaginators(DataLabeling client) {
        this.client = client;
    }

    public Iterable<ListAnnotationsResponse> listAnnotationsResponseIterator(final ListAnnotationsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListAnnotationsRequest.Builder>(){

            @Override
            public ListAnnotationsRequest.Builder get() {
                return ListAnnotationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnotationsResponse, String>(){

            @Override
            public String apply(ListAnnotationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnotationsRequest.Builder>, ListAnnotationsRequest>(){

            @Override
            public ListAnnotationsRequest apply(RequestBuilderAndToken<ListAnnotationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnotationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnotationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnotationsRequest, ListAnnotationsResponse>(){

            @Override
            public ListAnnotationsResponse apply(ListAnnotationsRequest request) {
                return DataLabelingPaginators.this.client.listAnnotations(request);
            }
        });
    }

    public Iterable<AnnotationSummary> listAnnotationsRecordIterator(final ListAnnotationsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListAnnotationsRequest.Builder>(){

            @Override
            public ListAnnotationsRequest.Builder get() {
                return ListAnnotationsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListAnnotationsResponse, String>(){

            @Override
            public String apply(ListAnnotationsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListAnnotationsRequest.Builder>, ListAnnotationsRequest>(){

            @Override
            public ListAnnotationsRequest apply(RequestBuilderAndToken<ListAnnotationsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListAnnotationsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListAnnotationsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListAnnotationsRequest, ListAnnotationsResponse>(){

            @Override
            public ListAnnotationsResponse apply(ListAnnotationsRequest request) {
                return DataLabelingPaginators.this.client.listAnnotations(request);
            }
        }, (Function)new Function<ListAnnotationsResponse, List<AnnotationSummary>>(){

            @Override
            public List<AnnotationSummary> apply(ListAnnotationsResponse response) {
                return response.getAnnotationCollection().getItems();
            }
        });
    }

    public Iterable<ListRecordsResponse> listRecordsResponseIterator(final ListRecordsRequest request) {
        return new ResponseIterable((Supplier)new Supplier<ListRecordsRequest.Builder>(){

            @Override
            public ListRecordsRequest.Builder get() {
                return ListRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecordsResponse, String>(){

            @Override
            public String apply(ListRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecordsRequest.Builder>, ListRecordsRequest>(){

            @Override
            public ListRecordsRequest apply(RequestBuilderAndToken<ListRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecordsRequest, ListRecordsResponse>(){

            @Override
            public ListRecordsResponse apply(ListRecordsRequest request) {
                return DataLabelingPaginators.this.client.listRecords(request);
            }
        });
    }

    public Iterable<RecordSummary> listRecordsRecordIterator(final ListRecordsRequest request) {
        return new ResponseRecordIterable((Supplier)new Supplier<ListRecordsRequest.Builder>(){

            @Override
            public ListRecordsRequest.Builder get() {
                return ListRecordsRequest.builder().copy(request);
            }
        }, (Function)new Function<ListRecordsResponse, String>(){

            @Override
            public String apply(ListRecordsResponse response) {
                return response.getOpcNextPage();
            }
        }, (Function)new Function<RequestBuilderAndToken<ListRecordsRequest.Builder>, ListRecordsRequest>(){

            @Override
            public ListRecordsRequest apply(RequestBuilderAndToken<ListRecordsRequest.Builder> input) {
                if (input.getNextPageToken() == null) {
                    return ((ListRecordsRequest.Builder)input.getRequestBuilder()).build();
                }
                return ((ListRecordsRequest.Builder)input.getRequestBuilder()).page(input.getNextPageToken().orElse(null)).build();
            }
        }, (Function)new Function<ListRecordsRequest, ListRecordsResponse>(){

            @Override
            public ListRecordsResponse apply(ListRecordsRequest request) {
                return DataLabelingPaginators.this.client.listRecords(request);
            }
        }, (Function)new Function<ListRecordsResponse, List<RecordSummary>>(){

            @Override
            public List<RecordSummary> apply(ListRecordsResponse response) {
                return response.getRecordCollection().getItems();
            }
        });
    }
}

