/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.MaskingFormat;
import com.oracle.bmc.datasafe.model.ObjectType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateMaskingColumnDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="maskingColumnGroup")
    private final String maskingColumnGroup;
    @JsonProperty(value="sensitiveTypeId")
    private final String sensitiveTypeId;
    @JsonProperty(value="isMaskingEnabled")
    private final Boolean isMaskingEnabled;
    @JsonProperty(value="maskingFormats")
    private final List<MaskingFormat> maskingFormats;

    @Deprecated
    @ConstructorProperties(value={"schemaName", "objectName", "objectType", "columnName", "maskingColumnGroup", "sensitiveTypeId", "isMaskingEnabled", "maskingFormats"})
    public CreateMaskingColumnDetails(String schemaName, String objectName, ObjectType objectType, String columnName, String maskingColumnGroup, String sensitiveTypeId, Boolean isMaskingEnabled, List<MaskingFormat> maskingFormats) {
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.objectType = objectType;
        this.columnName = columnName;
        this.maskingColumnGroup = maskingColumnGroup;
        this.sensitiveTypeId = sensitiveTypeId;
        this.isMaskingEnabled = isMaskingEnabled;
        this.maskingFormats = maskingFormats;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getMaskingColumnGroup() {
        return this.maskingColumnGroup;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public Boolean getIsMaskingEnabled() {
        return this.isMaskingEnabled;
    }

    public List<MaskingFormat> getMaskingFormats() {
        return this.maskingFormats;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateMaskingColumnDetails(");
        sb.append("super=").append(super.toString());
        sb.append("schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", maskingColumnGroup=").append(String.valueOf(this.maskingColumnGroup));
        sb.append(", sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(", isMaskingEnabled=").append(String.valueOf(this.isMaskingEnabled));
        sb.append(", maskingFormats=").append(String.valueOf(this.maskingFormats));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateMaskingColumnDetails)) {
            return false;
        }
        CreateMaskingColumnDetails other = (CreateMaskingColumnDetails)((Object)o);
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals((Object)this.objectType, (Object)other.objectType) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.maskingColumnGroup, other.maskingColumnGroup) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals(this.isMaskingEnabled, other.isMaskingEnabled) && Objects.equals(this.maskingFormats, other.maskingFormats) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.maskingColumnGroup == null ? 43 : this.maskingColumnGroup.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.isMaskingEnabled == null ? 43 : this.isMaskingEnabled.hashCode());
        result = result * 59 + (this.maskingFormats == null ? 43 : this.maskingFormats.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="maskingColumnGroup")
        private String maskingColumnGroup;
        @JsonProperty(value="sensitiveTypeId")
        private String sensitiveTypeId;
        @JsonProperty(value="isMaskingEnabled")
        private Boolean isMaskingEnabled;
        @JsonProperty(value="maskingFormats")
        private List<MaskingFormat> maskingFormats;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder maskingColumnGroup(String maskingColumnGroup) {
            this.maskingColumnGroup = maskingColumnGroup;
            this.__explicitlySet__.add("maskingColumnGroup");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.__explicitlySet__.add("sensitiveTypeId");
            return this;
        }

        public Builder isMaskingEnabled(Boolean isMaskingEnabled) {
            this.isMaskingEnabled = isMaskingEnabled;
            this.__explicitlySet__.add("isMaskingEnabled");
            return this;
        }

        public Builder maskingFormats(List<MaskingFormat> maskingFormats) {
            this.maskingFormats = maskingFormats;
            this.__explicitlySet__.add("maskingFormats");
            return this;
        }

        public CreateMaskingColumnDetails build() {
            CreateMaskingColumnDetails model = new CreateMaskingColumnDetails(this.schemaName, this.objectName, this.objectType, this.columnName, this.maskingColumnGroup, this.sensitiveTypeId, this.isMaskingEnabled, this.maskingFormats);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateMaskingColumnDetails model) {
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("maskingColumnGroup")) {
                this.maskingColumnGroup(model.getMaskingColumnGroup());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeId")) {
                this.sensitiveTypeId(model.getSensitiveTypeId());
            }
            if (model.wasPropertyExplicitlySet("isMaskingEnabled")) {
                this.isMaskingEnabled(model.getIsMaskingEnabled());
            }
            if (model.wasPropertyExplicitlySet("maskingFormats")) {
                this.maskingFormats(model.getMaskingFormats());
            }
            return this;
        }
    }
}

