/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TlsConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="certificateStoreType")
    private final CertificateStoreType certificateStoreType;
    @JsonProperty(value="storePassword")
    private final String storePassword;
    @JsonProperty(value="trustStoreContent")
    private final String trustStoreContent;
    @JsonProperty(value="keyStoreContent")
    private final String keyStoreContent;

    @Deprecated
    @ConstructorProperties(value={"status", "certificateStoreType", "storePassword", "trustStoreContent", "keyStoreContent"})
    public TlsConfig(Status status, CertificateStoreType certificateStoreType, String storePassword, String trustStoreContent, String keyStoreContent) {
        this.status = status;
        this.certificateStoreType = certificateStoreType;
        this.storePassword = storePassword;
        this.trustStoreContent = trustStoreContent;
        this.keyStoreContent = keyStoreContent;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public CertificateStoreType getCertificateStoreType() {
        return this.certificateStoreType;
    }

    public String getStorePassword() {
        return this.storePassword;
    }

    public String getTrustStoreContent() {
        return this.trustStoreContent;
    }

    public String getKeyStoreContent() {
        return this.keyStoreContent;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TlsConfig(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", certificateStoreType=").append(String.valueOf((Object)this.certificateStoreType));
        sb.append(", storePassword=").append("<redacted>");
        sb.append(", trustStoreContent=").append(String.valueOf(this.trustStoreContent));
        sb.append(", keyStoreContent=").append(String.valueOf(this.keyStoreContent));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TlsConfig)) {
            return false;
        }
        TlsConfig other = (TlsConfig)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.certificateStoreType, (Object)other.certificateStoreType) && Objects.equals(this.storePassword, other.storePassword) && Objects.equals(this.trustStoreContent, other.trustStoreContent) && Objects.equals(this.keyStoreContent, other.keyStoreContent) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.certificateStoreType == null ? 43 : this.certificateStoreType.hashCode());
        result = result * 59 + (this.storePassword == null ? 43 : this.storePassword.hashCode());
        result = result * 59 + (this.trustStoreContent == null ? 43 : this.trustStoreContent.hashCode());
        result = result * 59 + (this.keyStoreContent == null ? 43 : this.keyStoreContent.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CertificateStoreType implements BmcEnum
    {
        Jks("JKS"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, CertificateStoreType> map;

        private CertificateStoreType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CertificateStoreType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'CertificateStoreType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(CertificateStoreType.class);
            map = new HashMap<String, CertificateStoreType>();
            for (CertificateStoreType v : CertificateStoreType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="certificateStoreType")
        private CertificateStoreType certificateStoreType;
        @JsonProperty(value="storePassword")
        private String storePassword;
        @JsonProperty(value="trustStoreContent")
        private String trustStoreContent;
        @JsonProperty(value="keyStoreContent")
        private String keyStoreContent;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder certificateStoreType(CertificateStoreType certificateStoreType) {
            this.certificateStoreType = certificateStoreType;
            this.__explicitlySet__.add("certificateStoreType");
            return this;
        }

        public Builder storePassword(String storePassword) {
            this.storePassword = storePassword;
            this.__explicitlySet__.add("storePassword");
            return this;
        }

        public Builder trustStoreContent(String trustStoreContent) {
            this.trustStoreContent = trustStoreContent;
            this.__explicitlySet__.add("trustStoreContent");
            return this;
        }

        public Builder keyStoreContent(String keyStoreContent) {
            this.keyStoreContent = keyStoreContent;
            this.__explicitlySet__.add("keyStoreContent");
            return this;
        }

        public TlsConfig build() {
            TlsConfig model = new TlsConfig(this.status, this.certificateStoreType, this.storePassword, this.trustStoreContent, this.keyStoreContent);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TlsConfig model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("certificateStoreType")) {
                this.certificateStoreType(model.getCertificateStoreType());
            }
            if (model.wasPropertyExplicitlySet("storePassword")) {
                this.storePassword(model.getStorePassword());
            }
            if (model.wasPropertyExplicitlySet("trustStoreContent")) {
                this.trustStoreContent(model.getTrustStoreContent());
            }
            if (model.wasPropertyExplicitlySet("keyStoreContent")) {
                this.keyStoreContent(model.getKeyStoreContent());
            }
            return this;
        }
    }
}

