/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UserDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="status")
    private final String status;
    @JsonProperty(value="profile")
    private final String profile;
    @JsonProperty(value="tablespace")
    private final String tablespace;
    @JsonProperty(value="isUserPredefinedByOracle")
    private final Boolean isUserPredefinedByOracle;
    @JsonProperty(value="authenticationType")
    private final AuthenticationType authenticationType;

    @Deprecated
    @ConstructorProperties(value={"name", "status", "profile", "tablespace", "isUserPredefinedByOracle", "authenticationType"})
    public UserDetails(String name, String status, String profile, String tablespace, Boolean isUserPredefinedByOracle, AuthenticationType authenticationType) {
        this.name = name;
        this.status = status;
        this.profile = profile;
        this.tablespace = tablespace;
        this.isUserPredefinedByOracle = isUserPredefinedByOracle;
        this.authenticationType = authenticationType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getName() {
        return this.name;
    }

    public String getStatus() {
        return this.status;
    }

    public String getProfile() {
        return this.profile;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public Boolean getIsUserPredefinedByOracle() {
        return this.isUserPredefinedByOracle;
    }

    public AuthenticationType getAuthenticationType() {
        return this.authenticationType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UserDetails(");
        sb.append("super=").append(super.toString());
        sb.append("name=").append(String.valueOf(this.name));
        sb.append(", status=").append(String.valueOf(this.status));
        sb.append(", profile=").append(String.valueOf(this.profile));
        sb.append(", tablespace=").append(String.valueOf(this.tablespace));
        sb.append(", isUserPredefinedByOracle=").append(String.valueOf(this.isUserPredefinedByOracle));
        sb.append(", authenticationType=").append(String.valueOf((Object)this.authenticationType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserDetails)) {
            return false;
        }
        UserDetails other = (UserDetails)((Object)o);
        return Objects.equals(this.name, other.name) && Objects.equals(this.status, other.status) && Objects.equals(this.profile, other.profile) && Objects.equals(this.tablespace, other.tablespace) && Objects.equals(this.isUserPredefinedByOracle, other.isUserPredefinedByOracle) && Objects.equals((Object)this.authenticationType, (Object)other.authenticationType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.profile == null ? 43 : this.profile.hashCode());
        result = result * 59 + (this.tablespace == null ? 43 : this.tablespace.hashCode());
        result = result * 59 + (this.isUserPredefinedByOracle == null ? 43 : this.isUserPredefinedByOracle.hashCode());
        result = result * 59 + (this.authenticationType == null ? 43 : this.authenticationType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AuthenticationType implements BmcEnum
    {
        Password("PASSWORD"),
        None("NONE");

        private final String value;
        private static Map<String, AuthenticationType> map;

        private AuthenticationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuthenticationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AuthenticationType: " + key);
        }

        static {
            map = new HashMap<String, AuthenticationType>();
            for (AuthenticationType v : AuthenticationType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="status")
        private String status;
        @JsonProperty(value="profile")
        private String profile;
        @JsonProperty(value="tablespace")
        private String tablespace;
        @JsonProperty(value="isUserPredefinedByOracle")
        private Boolean isUserPredefinedByOracle;
        @JsonProperty(value="authenticationType")
        private AuthenticationType authenticationType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder status(String status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder profile(String profile) {
            this.profile = profile;
            this.__explicitlySet__.add("profile");
            return this;
        }

        public Builder tablespace(String tablespace) {
            this.tablespace = tablespace;
            this.__explicitlySet__.add("tablespace");
            return this;
        }

        public Builder isUserPredefinedByOracle(Boolean isUserPredefinedByOracle) {
            this.isUserPredefinedByOracle = isUserPredefinedByOracle;
            this.__explicitlySet__.add("isUserPredefinedByOracle");
            return this;
        }

        public Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType = authenticationType;
            this.__explicitlySet__.add("authenticationType");
            return this;
        }

        public UserDetails build() {
            UserDetails model = new UserDetails(this.name, this.status, this.profile, this.tablespace, this.isUserPredefinedByOracle, this.authenticationType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UserDetails model) {
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("profile")) {
                this.profile(model.getProfile());
            }
            if (model.wasPropertyExplicitlySet("tablespace")) {
                this.tablespace(model.getTablespace());
            }
            if (model.wasPropertyExplicitlySet("isUserPredefinedByOracle")) {
                this.isUserPredefinedByOracle(model.getIsUserPredefinedByOracle());
            }
            if (model.wasPropertyExplicitlySet("authenticationType")) {
                this.authenticationType(model.getAuthenticationType());
            }
            return this;
        }
    }
}

