/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.WorkRequestResource;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class WorkRequestSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationType")
    private final OperationType operationType;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="resources")
    private final List<WorkRequestResource> resources;
    @JsonProperty(value="percentComplete")
    private final Float percentComplete;
    @JsonProperty(value="timeAccepted")
    private final Date timeAccepted;
    @JsonProperty(value="timeStarted")
    private final Date timeStarted;
    @JsonProperty(value="timeFinished")
    private final Date timeFinished;

    @Deprecated
    @ConstructorProperties(value={"operationType", "status", "id", "compartmentId", "resources", "percentComplete", "timeAccepted", "timeStarted", "timeFinished"})
    public WorkRequestSummary(OperationType operationType, Status status, String id, String compartmentId, List<WorkRequestResource> resources, Float percentComplete, Date timeAccepted, Date timeStarted, Date timeFinished) {
        this.operationType = operationType;
        this.status = status;
        this.id = id;
        this.compartmentId = compartmentId;
        this.resources = resources;
        this.percentComplete = percentComplete;
        this.timeAccepted = timeAccepted;
        this.timeStarted = timeStarted;
        this.timeFinished = timeFinished;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public OperationType getOperationType() {
        return this.operationType;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public List<WorkRequestResource> getResources() {
        return this.resources;
    }

    public Float getPercentComplete() {
        return this.percentComplete;
    }

    public Date getTimeAccepted() {
        return this.timeAccepted;
    }

    public Date getTimeStarted() {
        return this.timeStarted;
    }

    public Date getTimeFinished() {
        return this.timeFinished;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("WorkRequestSummary(");
        sb.append("super=").append(super.toString());
        sb.append("operationType=").append(String.valueOf((Object)this.operationType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", resources=").append(String.valueOf(this.resources));
        sb.append(", percentComplete=").append(String.valueOf(this.percentComplete));
        sb.append(", timeAccepted=").append(String.valueOf(this.timeAccepted));
        sb.append(", timeStarted=").append(String.valueOf(this.timeStarted));
        sb.append(", timeFinished=").append(String.valueOf(this.timeFinished));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WorkRequestSummary)) {
            return false;
        }
        WorkRequestSummary other = (WorkRequestSummary)((Object)o);
        return Objects.equals((Object)this.operationType, (Object)other.operationType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.resources, other.resources) && Objects.equals(this.percentComplete, other.percentComplete) && Objects.equals(this.timeAccepted, other.timeAccepted) && Objects.equals(this.timeStarted, other.timeStarted) && Objects.equals(this.timeFinished, other.timeFinished) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationType == null ? 43 : this.operationType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.resources == null ? 43 : this.resources.hashCode());
        result = result * 59 + (this.percentComplete == null ? 43 : this.percentComplete.hashCode());
        result = result * 59 + (this.timeAccepted == null ? 43 : this.timeAccepted.hashCode());
        result = result * 59 + (this.timeStarted == null ? 43 : this.timeStarted.hashCode());
        result = result * 59 + (this.timeFinished == null ? 43 : this.timeFinished.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Accepted("ACCEPTED"),
        InProgress("IN_PROGRESS"),
        Failed("FAILED"),
        Succeeded("SUCCEEDED"),
        Canceling("CANCELING"),
        Canceled("CANCELED"),
        Suspending("SUSPENDING"),
        Suspended("SUSPENDED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationType implements BmcEnum
    {
        EnableDataSafeConfiguration("ENABLE_DATA_SAFE_CONFIGURATION"),
        CreatePrivateEndpoint("CREATE_PRIVATE_ENDPOINT"),
        UpdatePrivateEndpoint("UPDATE_PRIVATE_ENDPOINT"),
        DeletePrivateEndpoint("DELETE_PRIVATE_ENDPOINT"),
        ChangePrivateEndpointCompartment("CHANGE_PRIVATE_ENDPOINT_COMPARTMENT"),
        CreateOnpremConnector("CREATE_ONPREM_CONNECTOR"),
        UpdateOnpremConnector("UPDATE_ONPREM_CONNECTOR"),
        DeleteOnpremConnector("DELETE_ONPREM_CONNECTOR"),
        UpdateOnpremConnectorWallet("UPDATE_ONPREM_CONNECTOR_WALLET"),
        ChangeOnpremConnectorCompartment("CHANGE_ONPREM_CONNECTOR_COMPARTMENT"),
        ProvisionPolicy("PROVISION_POLICY"),
        RetrievePolicy("RETRIEVE_POLICY"),
        UpdatePolicy("UPDATE_POLICY"),
        ChangePolicyCompartment("CHANGE_POLICY_COMPARTMENT"),
        CreateTargetDatabase("CREATE_TARGET_DATABASE"),
        UpdateTargetDatabase("UPDATE_TARGET_DATABASE"),
        ActivateTargetDatabase("ACTIVATE_TARGET_DATABASE"),
        DeactivateTargetDatabase("DEACTIVATE_TARGET_DATABASE"),
        DeleteTargetDatabase("DELETE_TARGET_DATABASE"),
        ChangeTargetDatabaseCompartment("CHANGE_TARGET_DATABASE_COMPARTMENT"),
        CreateUserAssessment("CREATE_USER_ASSESSMENT"),
        AssessUserAssessment("ASSESS_USER_ASSESSMENT"),
        CreateSnapshotUserAssessment("CREATE_SNAPSHOT_USER_ASSESSMENT"),
        CreateScheduleUserAssessment("CREATE_SCHEDULE_USER_ASSESSMENT"),
        CompareWithBaselineUserAssessment("COMPARE_WITH_BASELINE_USER_ASSESSMENT"),
        DeleteUserAssessment("DELETE_USER_ASSESSMENT"),
        UpdateUserAssessment("UPDATE_USER_ASSESSMENT"),
        ChangeUserAssessmentCompartment("CHANGE_USER_ASSESSMENT_COMPARTMENT"),
        SetUserAssessmentBaseline("SET_USER_ASSESSMENT_BASELINE"),
        UnsetUserAssessmentBaseline("UNSET_USER_ASSESSMENT_BASELINE"),
        GenerateUserAssessmentReport("GENERATE_USER_ASSESSMENT_REPORT"),
        CreateSecurityAssessment("CREATE_SECURITY_ASSESSMENT"),
        CreateSecurityAssessmentNow("CREATE_SECURITY_ASSESSMENT_NOW"),
        AssessSecurityAssessment("ASSESS_SECURITY_ASSESSMENT"),
        CreateSnapshotSecurityAssessment("CREATE_SNAPSHOT_SECURITY_ASSESSMENT"),
        CreateScheduleSecurityAssessment("CREATE_SCHEDULE_SECURITY_ASSESSMENT"),
        CompareWithBaselineSecurityAssessment("COMPARE_WITH_BASELINE_SECURITY_ASSESSMENT"),
        DeleteSecurityAssessment("DELETE_SECURITY_ASSESSMENT"),
        UpdateSecurityAssessment("UPDATE_SECURITY_ASSESSMENT"),
        ChangeSecurityAssessmentCompartment("CHANGE_SECURITY_ASSESSMENT_COMPARTMENT"),
        SetSecurityAssessmentBaseline("SET_SECURITY_ASSESSMENT_BASELINE"),
        UnsetSecurityAssessmentBaseline("UNSET_SECURITY_ASSESSMENT_BASELINE"),
        GenerateSecurityAssessmentReport("GENERATE_SECURITY_ASSESSMENT_REPORT"),
        CalculateVolume("CALCULATE_VOLUME"),
        CalculateCollectedVolume("CALCULATE_COLLECTED_VOLUME"),
        AuditTrail("AUDIT_TRAIL"),
        DeleteAuditTrail("DELETE_AUDIT_TRAIL"),
        DiscoverAuditTrails("DISCOVER_AUDIT_TRAILS"),
        UpdateAuditTrail("UPDATE_AUDIT_TRAIL"),
        UpdateAuditProfile("UPDATE_AUDIT_PROFILE"),
        AuditChangeCompartment("AUDIT_CHANGE_COMPARTMENT"),
        CreateReportDefinition("CREATE_REPORT_DEFINITION"),
        UpdateReportDefinition("UPDATE_REPORT_DEFINITION"),
        ChangeReportDefinitionCompartment("CHANGE_REPORT_DEFINITION_COMPARTMENT"),
        DeleteReportDefinition("DELETE_REPORT_DEFINITION"),
        GenerateReport("GENERATE_REPORT"),
        ChangeReportCompartment("CHANGE_REPORT_COMPARTMENT"),
        DeleteArchiveRetrieval("DELETE_ARCHIVE_RETRIEVAL"),
        CreateArchiveRetrieval("CREATE_ARCHIVE_RETRIEVAL"),
        UpdateArchiveRetrieval("UPDATE_ARCHIVE_RETRIEVAL"),
        ChangeArchiveRetrievalCompartment("CHANGE_ARCHIVE_RETRIEVAL_COMPARTMENT"),
        UpdateAlert("UPDATE_ALERT"),
        TargetAlertPolicyAssociation("TARGET_ALERT_POLICY_ASSOCIATION"),
        CreateSensitiveDataModel("CREATE_SENSITIVE_DATA_MODEL"),
        UpdateSensitiveDataModel("UPDATE_SENSITIVE_DATA_MODEL"),
        DeleteSensitiveDataModel("DELETE_SENSITIVE_DATA_MODEL"),
        UploadSensitiveDataModel("UPLOAD_SENSITIVE_DATA_MODEL"),
        GenerateSensitiveDataModelForDownload("GENERATE_SENSITIVE_DATA_MODEL_FOR_DOWNLOAD"),
        CreateSensitiveColumn("CREATE_SENSITIVE_COLUMN"),
        UpdateSensitiveColumn("UPDATE_SENSITIVE_COLUMN"),
        PatchSensitiveColumns("PATCH_SENSITIVE_COLUMNS"),
        CreateDiscoveryJob("CREATE_DISCOVERY_JOB"),
        DeleteDiscoveryJob("DELETE_DISCOVERY_JOB"),
        PatchDiscoveryJobResult("PATCH_DISCOVERY_JOB_RESULT"),
        ApplyDiscoveryJobResult("APPLY_DISCOVERY_JOB_RESULT"),
        GenerateDiscoveryReport("GENERATE_DISCOVERY_REPORT"),
        CreateSensitiveType("CREATE_SENSITIVE_TYPE"),
        UpdateSensitiveType("UPDATE_SENSITIVE_TYPE"),
        CreateMaskingPolicy("CREATE_MASKING_POLICY"),
        UpdateMaskingPolicy("UPDATE_MASKING_POLICY"),
        DeleteMaskingPolicy("DELETE_MASKING_POLICY"),
        UploadMaskingPolicy("UPLOAD_MASKING_POLICY"),
        GenerateMaskingPolicyForDownload("GENERATE_MASKING_POLICY_FOR_DOWNLOAD"),
        CreateMaskingColumn("CREATE_MASKING_COLUMN"),
        UpdateMaskingColumn("UPDATE_MASKING_COLUMN"),
        PatchMaskingColumns("PATCH_MASKING_COLUMNS"),
        GenerateMaskingReport("GENERATE_MASKING_REPORT"),
        CreateLibraryMaskingFormat("CREATE_LIBRARY_MASKING_FORMAT"),
        UpdateLibraryMaskingFormat("UPDATE_LIBRARY_MASKING_FORMAT"),
        AddColumnsFromSdm("ADD_COLUMNS_FROM_SDM"),
        MaskingJob("MASKING_JOB"),
        CreateDifference("CREATE_DIFFERENCE"),
        DeleteDifference("DELETE_DIFFERENCE"),
        UpdateDifference("UPDATE_DIFFERENCE"),
        PatchDifference("PATCH_DIFFERENCE"),
        ApplyDifference("APPLY_DIFFERENCE"),
        CreateSchedule("CREATE_SCHEDULE"),
        RemoveScheduleReport("REMOVE_SCHEDULE_REPORT"),
        UpdateAllAlert("UPDATE_ALL_ALERT"),
        PatchTargetAlertPolicyAssociation("PATCH_TARGET_ALERT_POLICY_ASSOCIATION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationType> map;

        private OperationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationType.class);
            map = new HashMap<String, OperationType>();
            for (OperationType v : OperationType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationType")
        private OperationType operationType;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="resources")
        private List<WorkRequestResource> resources;
        @JsonProperty(value="percentComplete")
        private Float percentComplete;
        @JsonProperty(value="timeAccepted")
        private Date timeAccepted;
        @JsonProperty(value="timeStarted")
        private Date timeStarted;
        @JsonProperty(value="timeFinished")
        private Date timeFinished;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationType(OperationType operationType) {
            this.operationType = operationType;
            this.__explicitlySet__.add("operationType");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder resources(List<WorkRequestResource> resources) {
            this.resources = resources;
            this.__explicitlySet__.add("resources");
            return this;
        }

        public Builder percentComplete(Float percentComplete) {
            this.percentComplete = percentComplete;
            this.__explicitlySet__.add("percentComplete");
            return this;
        }

        public Builder timeAccepted(Date timeAccepted) {
            this.timeAccepted = timeAccepted;
            this.__explicitlySet__.add("timeAccepted");
            return this;
        }

        public Builder timeStarted(Date timeStarted) {
            this.timeStarted = timeStarted;
            this.__explicitlySet__.add("timeStarted");
            return this;
        }

        public Builder timeFinished(Date timeFinished) {
            this.timeFinished = timeFinished;
            this.__explicitlySet__.add("timeFinished");
            return this;
        }

        public WorkRequestSummary build() {
            WorkRequestSummary model = new WorkRequestSummary(this.operationType, this.status, this.id, this.compartmentId, this.resources, this.percentComplete, this.timeAccepted, this.timeStarted, this.timeFinished);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(WorkRequestSummary model) {
            if (model.wasPropertyExplicitlySet("operationType")) {
                this.operationType(model.getOperationType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("resources")) {
                this.resources(model.getResources());
            }
            if (model.wasPropertyExplicitlySet("percentComplete")) {
                this.percentComplete(model.getPercentComplete());
            }
            if (model.wasPropertyExplicitlySet("timeAccepted")) {
                this.timeAccepted(model.getTimeAccepted());
            }
            if (model.wasPropertyExplicitlySet("timeStarted")) {
                this.timeStarted(model.getTimeStarted());
            }
            if (model.wasPropertyExplicitlySet("timeFinished")) {
                this.timeFinished(model.getTimeFinished());
            }
            return this;
        }
    }
}

