/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAuditPolicyRequest
extends BmcRequest<Void> {
    private String auditPolicyId;
    private String opcRequestId;

    public String getAuditPolicyId() {
        return this.auditPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().auditPolicyId(this.auditPolicyId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",auditPolicyId=").append(String.valueOf(this.auditPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAuditPolicyRequest)) {
            return false;
        }
        GetAuditPolicyRequest other = (GetAuditPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.auditPolicyId, other.auditPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.auditPolicyId == null ? 43 : this.auditPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAuditPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String auditPolicyId = null;
        private String opcRequestId = null;

        public Builder auditPolicyId(String auditPolicyId) {
            this.auditPolicyId = auditPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAuditPolicyRequest o) {
            this.auditPolicyId(o.getAuditPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAuditPolicyRequest build() {
            GetAuditPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAuditPolicyRequest buildWithoutInvocationCallback() {
            GetAuditPolicyRequest request = new GetAuditPolicyRequest();
            request.auditPolicyId = this.auditPolicyId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

