/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSecurityAssessmentComparisonRequest
extends BmcRequest<Void> {
    private String securityAssessmentId;
    private String comparisonSecurityAssessmentId;
    private String opcRequestId;

    public String getSecurityAssessmentId() {
        return this.securityAssessmentId;
    }

    public String getComparisonSecurityAssessmentId() {
        return this.comparisonSecurityAssessmentId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityAssessmentId(this.securityAssessmentId).comparisonSecurityAssessmentId(this.comparisonSecurityAssessmentId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityAssessmentId=").append(String.valueOf(this.securityAssessmentId));
        sb.append(",comparisonSecurityAssessmentId=").append(String.valueOf(this.comparisonSecurityAssessmentId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSecurityAssessmentComparisonRequest)) {
            return false;
        }
        GetSecurityAssessmentComparisonRequest other = (GetSecurityAssessmentComparisonRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityAssessmentId, other.securityAssessmentId) && Objects.equals(this.comparisonSecurityAssessmentId, other.comparisonSecurityAssessmentId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityAssessmentId == null ? 43 : this.securityAssessmentId.hashCode());
        result = result * 59 + (this.comparisonSecurityAssessmentId == null ? 43 : this.comparisonSecurityAssessmentId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSecurityAssessmentComparisonRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityAssessmentId = null;
        private String comparisonSecurityAssessmentId = null;
        private String opcRequestId = null;

        public Builder securityAssessmentId(String securityAssessmentId) {
            this.securityAssessmentId = securityAssessmentId;
            return this;
        }

        public Builder comparisonSecurityAssessmentId(String comparisonSecurityAssessmentId) {
            this.comparisonSecurityAssessmentId = comparisonSecurityAssessmentId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSecurityAssessmentComparisonRequest o) {
            this.securityAssessmentId(o.getSecurityAssessmentId());
            this.comparisonSecurityAssessmentId(o.getComparisonSecurityAssessmentId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSecurityAssessmentComparisonRequest build() {
            GetSecurityAssessmentComparisonRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSecurityAssessmentComparisonRequest buildWithoutInvocationCallback() {
            GetSecurityAssessmentComparisonRequest request = new GetSecurityAssessmentComparisonRequest();
            request.securityAssessmentId = this.securityAssessmentId;
            request.comparisonSecurityAssessmentId = this.comparisonSecurityAssessmentId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

