/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListProfileSummariesRequest
extends BmcRequest<Void> {
    private String userAssessmentId;
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private String targetId;
    private Integer limit;
    private String page;
    private String profileName;
    private Boolean isUserCreated;
    private String passwordVerificationFunction;
    private String userCountGreaterThanOrEqual;
    private String userCountLessThan;
    private String failedLoginAttemptsGreaterThanOrEqual;
    private String failedLoginAttemptsLessThan;
    private String sessionsPerUserGreaterThanOrEqual;
    private String sessionsPerUserLessThan;
    private String inactiveAccountTimeGreaterThanOrEqual;
    private String inactiveAccountTimeLessThan;
    private String passwordLockTimeGreaterThanOrEqual;
    private String passwordLockTimeLessThan;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String opcRequestId;

    public String getUserAssessmentId() {
        return this.userAssessmentId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Boolean getIsUserCreated() {
        return this.isUserCreated;
    }

    public String getPasswordVerificationFunction() {
        return this.passwordVerificationFunction;
    }

    public String getUserCountGreaterThanOrEqual() {
        return this.userCountGreaterThanOrEqual;
    }

    public String getUserCountLessThan() {
        return this.userCountLessThan;
    }

    public String getFailedLoginAttemptsGreaterThanOrEqual() {
        return this.failedLoginAttemptsGreaterThanOrEqual;
    }

    public String getFailedLoginAttemptsLessThan() {
        return this.failedLoginAttemptsLessThan;
    }

    public String getSessionsPerUserGreaterThanOrEqual() {
        return this.sessionsPerUserGreaterThanOrEqual;
    }

    public String getSessionsPerUserLessThan() {
        return this.sessionsPerUserLessThan;
    }

    public String getInactiveAccountTimeGreaterThanOrEqual() {
        return this.inactiveAccountTimeGreaterThanOrEqual;
    }

    public String getInactiveAccountTimeLessThan() {
        return this.inactiveAccountTimeLessThan;
    }

    public String getPasswordLockTimeGreaterThanOrEqual() {
        return this.passwordLockTimeGreaterThanOrEqual;
    }

    public String getPasswordLockTimeLessThan() {
        return this.passwordLockTimeLessThan;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().userAssessmentId(this.userAssessmentId).compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).targetId(this.targetId).limit(this.limit).page(this.page).profileName(this.profileName).isUserCreated(this.isUserCreated).passwordVerificationFunction(this.passwordVerificationFunction).userCountGreaterThanOrEqual(this.userCountGreaterThanOrEqual).userCountLessThan(this.userCountLessThan).failedLoginAttemptsGreaterThanOrEqual(this.failedLoginAttemptsGreaterThanOrEqual).failedLoginAttemptsLessThan(this.failedLoginAttemptsLessThan).sessionsPerUserGreaterThanOrEqual(this.sessionsPerUserGreaterThanOrEqual).sessionsPerUserLessThan(this.sessionsPerUserLessThan).inactiveAccountTimeGreaterThanOrEqual(this.inactiveAccountTimeGreaterThanOrEqual).inactiveAccountTimeLessThan(this.inactiveAccountTimeLessThan).passwordLockTimeGreaterThanOrEqual(this.passwordLockTimeGreaterThanOrEqual).passwordLockTimeLessThan(this.passwordLockTimeLessThan).sortBy(this.sortBy).sortOrder(this.sortOrder).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userAssessmentId=").append(String.valueOf(this.userAssessmentId));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",profileName=").append(String.valueOf(this.profileName));
        sb.append(",isUserCreated=").append(String.valueOf(this.isUserCreated));
        sb.append(",passwordVerificationFunction=").append(String.valueOf(this.passwordVerificationFunction));
        sb.append(",userCountGreaterThanOrEqual=").append(String.valueOf(this.userCountGreaterThanOrEqual));
        sb.append(",userCountLessThan=").append(String.valueOf(this.userCountLessThan));
        sb.append(",failedLoginAttemptsGreaterThanOrEqual=").append(String.valueOf(this.failedLoginAttemptsGreaterThanOrEqual));
        sb.append(",failedLoginAttemptsLessThan=").append(String.valueOf(this.failedLoginAttemptsLessThan));
        sb.append(",sessionsPerUserGreaterThanOrEqual=").append(String.valueOf(this.sessionsPerUserGreaterThanOrEqual));
        sb.append(",sessionsPerUserLessThan=").append(String.valueOf(this.sessionsPerUserLessThan));
        sb.append(",inactiveAccountTimeGreaterThanOrEqual=").append(String.valueOf(this.inactiveAccountTimeGreaterThanOrEqual));
        sb.append(",inactiveAccountTimeLessThan=").append(String.valueOf(this.inactiveAccountTimeLessThan));
        sb.append(",passwordLockTimeGreaterThanOrEqual=").append(String.valueOf(this.passwordLockTimeGreaterThanOrEqual));
        sb.append(",passwordLockTimeLessThan=").append(String.valueOf(this.passwordLockTimeLessThan));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListProfileSummariesRequest)) {
            return false;
        }
        ListProfileSummariesRequest other = (ListProfileSummariesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userAssessmentId, other.userAssessmentId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.profileName, other.profileName) && Objects.equals(this.isUserCreated, other.isUserCreated) && Objects.equals(this.passwordVerificationFunction, other.passwordVerificationFunction) && Objects.equals(this.userCountGreaterThanOrEqual, other.userCountGreaterThanOrEqual) && Objects.equals(this.userCountLessThan, other.userCountLessThan) && Objects.equals(this.failedLoginAttemptsGreaterThanOrEqual, other.failedLoginAttemptsGreaterThanOrEqual) && Objects.equals(this.failedLoginAttemptsLessThan, other.failedLoginAttemptsLessThan) && Objects.equals(this.sessionsPerUserGreaterThanOrEqual, other.sessionsPerUserGreaterThanOrEqual) && Objects.equals(this.sessionsPerUserLessThan, other.sessionsPerUserLessThan) && Objects.equals(this.inactiveAccountTimeGreaterThanOrEqual, other.inactiveAccountTimeGreaterThanOrEqual) && Objects.equals(this.inactiveAccountTimeLessThan, other.inactiveAccountTimeLessThan) && Objects.equals(this.passwordLockTimeGreaterThanOrEqual, other.passwordLockTimeGreaterThanOrEqual) && Objects.equals(this.passwordLockTimeLessThan, other.passwordLockTimeLessThan) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userAssessmentId == null ? 43 : this.userAssessmentId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.profileName == null ? 43 : this.profileName.hashCode());
        result = result * 59 + (this.isUserCreated == null ? 43 : this.isUserCreated.hashCode());
        result = result * 59 + (this.passwordVerificationFunction == null ? 43 : this.passwordVerificationFunction.hashCode());
        result = result * 59 + (this.userCountGreaterThanOrEqual == null ? 43 : this.userCountGreaterThanOrEqual.hashCode());
        result = result * 59 + (this.userCountLessThan == null ? 43 : this.userCountLessThan.hashCode());
        result = result * 59 + (this.failedLoginAttemptsGreaterThanOrEqual == null ? 43 : this.failedLoginAttemptsGreaterThanOrEqual.hashCode());
        result = result * 59 + (this.failedLoginAttemptsLessThan == null ? 43 : this.failedLoginAttemptsLessThan.hashCode());
        result = result * 59 + (this.sessionsPerUserGreaterThanOrEqual == null ? 43 : this.sessionsPerUserGreaterThanOrEqual.hashCode());
        result = result * 59 + (this.sessionsPerUserLessThan == null ? 43 : this.sessionsPerUserLessThan.hashCode());
        result = result * 59 + (this.inactiveAccountTimeGreaterThanOrEqual == null ? 43 : this.inactiveAccountTimeGreaterThanOrEqual.hashCode());
        result = result * 59 + (this.inactiveAccountTimeLessThan == null ? 43 : this.inactiveAccountTimeLessThan.hashCode());
        result = result * 59 + (this.passwordLockTimeGreaterThanOrEqual == null ? 43 : this.passwordLockTimeGreaterThanOrEqual.hashCode());
        result = result * 59 + (this.passwordLockTimeLessThan == null ? 43 : this.passwordLockTimeLessThan.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListProfileSummariesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userAssessmentId = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private String targetId = null;
        private Integer limit = null;
        private String page = null;
        private String profileName = null;
        private Boolean isUserCreated = null;
        private String passwordVerificationFunction = null;
        private String userCountGreaterThanOrEqual = null;
        private String userCountLessThan = null;
        private String failedLoginAttemptsGreaterThanOrEqual = null;
        private String failedLoginAttemptsLessThan = null;
        private String sessionsPerUserGreaterThanOrEqual = null;
        private String sessionsPerUserLessThan = null;
        private String inactiveAccountTimeGreaterThanOrEqual = null;
        private String inactiveAccountTimeLessThan = null;
        private String passwordLockTimeGreaterThanOrEqual = null;
        private String passwordLockTimeLessThan = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String opcRequestId = null;

        public Builder userAssessmentId(String userAssessmentId) {
            this.userAssessmentId = userAssessmentId;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            return this;
        }

        public Builder isUserCreated(Boolean isUserCreated) {
            this.isUserCreated = isUserCreated;
            return this;
        }

        public Builder passwordVerificationFunction(String passwordVerificationFunction) {
            this.passwordVerificationFunction = passwordVerificationFunction;
            return this;
        }

        public Builder userCountGreaterThanOrEqual(String userCountGreaterThanOrEqual) {
            this.userCountGreaterThanOrEqual = userCountGreaterThanOrEqual;
            return this;
        }

        public Builder userCountLessThan(String userCountLessThan) {
            this.userCountLessThan = userCountLessThan;
            return this;
        }

        public Builder failedLoginAttemptsGreaterThanOrEqual(String failedLoginAttemptsGreaterThanOrEqual) {
            this.failedLoginAttemptsGreaterThanOrEqual = failedLoginAttemptsGreaterThanOrEqual;
            return this;
        }

        public Builder failedLoginAttemptsLessThan(String failedLoginAttemptsLessThan) {
            this.failedLoginAttemptsLessThan = failedLoginAttemptsLessThan;
            return this;
        }

        public Builder sessionsPerUserGreaterThanOrEqual(String sessionsPerUserGreaterThanOrEqual) {
            this.sessionsPerUserGreaterThanOrEqual = sessionsPerUserGreaterThanOrEqual;
            return this;
        }

        public Builder sessionsPerUserLessThan(String sessionsPerUserLessThan) {
            this.sessionsPerUserLessThan = sessionsPerUserLessThan;
            return this;
        }

        public Builder inactiveAccountTimeGreaterThanOrEqual(String inactiveAccountTimeGreaterThanOrEqual) {
            this.inactiveAccountTimeGreaterThanOrEqual = inactiveAccountTimeGreaterThanOrEqual;
            return this;
        }

        public Builder inactiveAccountTimeLessThan(String inactiveAccountTimeLessThan) {
            this.inactiveAccountTimeLessThan = inactiveAccountTimeLessThan;
            return this;
        }

        public Builder passwordLockTimeGreaterThanOrEqual(String passwordLockTimeGreaterThanOrEqual) {
            this.passwordLockTimeGreaterThanOrEqual = passwordLockTimeGreaterThanOrEqual;
            return this;
        }

        public Builder passwordLockTimeLessThan(String passwordLockTimeLessThan) {
            this.passwordLockTimeLessThan = passwordLockTimeLessThan;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListProfileSummariesRequest o) {
            this.userAssessmentId(o.getUserAssessmentId());
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.targetId(o.getTargetId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.profileName(o.getProfileName());
            this.isUserCreated(o.getIsUserCreated());
            this.passwordVerificationFunction(o.getPasswordVerificationFunction());
            this.userCountGreaterThanOrEqual(o.getUserCountGreaterThanOrEqual());
            this.userCountLessThan(o.getUserCountLessThan());
            this.failedLoginAttemptsGreaterThanOrEqual(o.getFailedLoginAttemptsGreaterThanOrEqual());
            this.failedLoginAttemptsLessThan(o.getFailedLoginAttemptsLessThan());
            this.sessionsPerUserGreaterThanOrEqual(o.getSessionsPerUserGreaterThanOrEqual());
            this.sessionsPerUserLessThan(o.getSessionsPerUserLessThan());
            this.inactiveAccountTimeGreaterThanOrEqual(o.getInactiveAccountTimeGreaterThanOrEqual());
            this.inactiveAccountTimeLessThan(o.getInactiveAccountTimeLessThan());
            this.passwordLockTimeGreaterThanOrEqual(o.getPasswordLockTimeGreaterThanOrEqual());
            this.passwordLockTimeLessThan(o.getPasswordLockTimeLessThan());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListProfileSummariesRequest build() {
            ListProfileSummariesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListProfileSummariesRequest buildWithoutInvocationCallback() {
            ListProfileSummariesRequest request = new ListProfileSummariesRequest();
            request.userAssessmentId = this.userAssessmentId;
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.targetId = this.targetId;
            request.limit = this.limit;
            request.page = this.page;
            request.profileName = this.profileName;
            request.isUserCreated = this.isUserCreated;
            request.passwordVerificationFunction = this.passwordVerificationFunction;
            request.userCountGreaterThanOrEqual = this.userCountGreaterThanOrEqual;
            request.userCountLessThan = this.userCountLessThan;
            request.failedLoginAttemptsGreaterThanOrEqual = this.failedLoginAttemptsGreaterThanOrEqual;
            request.failedLoginAttemptsLessThan = this.failedLoginAttemptsLessThan;
            request.sessionsPerUserGreaterThanOrEqual = this.sessionsPerUserGreaterThanOrEqual;
            request.sessionsPerUserLessThan = this.sessionsPerUserLessThan;
            request.inactiveAccountTimeGreaterThanOrEqual = this.inactiveAccountTimeGreaterThanOrEqual;
            request.inactiveAccountTimeLessThan = this.inactiveAccountTimeLessThan;
            request.passwordLockTimeGreaterThanOrEqual = this.passwordLockTimeGreaterThanOrEqual;
            request.passwordLockTimeLessThan = this.passwordLockTimeLessThan;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        ProfileName("profileName"),
        TargetId("targetId"),
        IsUserCreated("isUserCreated"),
        PasswordVerificationFunction("passwordVerificationFunction"),
        UserCount("userCount"),
        SessionsPerUser("sessionsPerUser"),
        InactiveAccountTime("inactiveAccountTime"),
        FailedLoginAttempts("failedLoginAttempts");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

