/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.UserAssessmentBaseLineDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class SetUserAssessmentBaselineRequest
extends BmcRequest<UserAssessmentBaseLineDetails> {
    private String userAssessmentId;
    private String ifMatch;
    private String opcRetryToken;
    private String opcRequestId;
    private UserAssessmentBaseLineDetails baseLineDetails;

    public String getUserAssessmentId() {
        return this.userAssessmentId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public UserAssessmentBaseLineDetails getBaseLineDetails() {
        return this.baseLineDetails;
    }

    @InternalSdk
    public UserAssessmentBaseLineDetails getBody$() {
        return this.baseLineDetails;
    }

    public Builder toBuilder() {
        return new Builder().userAssessmentId(this.userAssessmentId).ifMatch(this.ifMatch).opcRetryToken(this.opcRetryToken).opcRequestId(this.opcRequestId).baseLineDetails(this.baseLineDetails);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userAssessmentId=").append(String.valueOf(this.userAssessmentId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",baseLineDetails=").append(String.valueOf((Object)this.baseLineDetails));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SetUserAssessmentBaselineRequest)) {
            return false;
        }
        SetUserAssessmentBaselineRequest other = (SetUserAssessmentBaselineRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userAssessmentId, other.userAssessmentId) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRetryToken, other.opcRetryToken) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals((Object)this.baseLineDetails, (Object)other.baseLineDetails);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userAssessmentId == null ? 43 : this.userAssessmentId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.baseLineDetails == null ? 43 : this.baseLineDetails.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<SetUserAssessmentBaselineRequest, UserAssessmentBaseLineDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userAssessmentId = null;
        private String ifMatch = null;
        private String opcRetryToken = null;
        private String opcRequestId = null;
        private UserAssessmentBaseLineDetails baseLineDetails = null;

        public Builder userAssessmentId(String userAssessmentId) {
            this.userAssessmentId = userAssessmentId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder baseLineDetails(UserAssessmentBaseLineDetails baseLineDetails) {
            this.baseLineDetails = baseLineDetails;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(SetUserAssessmentBaselineRequest o) {
            this.userAssessmentId(o.getUserAssessmentId());
            this.ifMatch(o.getIfMatch());
            this.opcRetryToken(o.getOpcRetryToken());
            this.opcRequestId(o.getOpcRequestId());
            this.baseLineDetails(o.getBaseLineDetails());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public SetUserAssessmentBaselineRequest build() {
            SetUserAssessmentBaselineRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UserAssessmentBaseLineDetails body) {
            this.baseLineDetails(body);
            return this;
        }

        public SetUserAssessmentBaselineRequest buildWithoutInvocationCallback() {
            SetUserAssessmentBaselineRequest request = new SetUserAssessmentBaselineRequest();
            request.userAssessmentId = this.userAssessmentId;
            request.ifMatch = this.ifMatch;
            request.opcRetryToken = this.opcRetryToken;
            request.opcRequestId = this.opcRequestId;
            request.baseLineDetails = this.baseLineDetails;
            return request;
        }
    }
}

