/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.UpdateAlertDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateAlertRequest
extends BmcRequest<UpdateAlertDetails> {
    private String alertId;
    private UpdateAlertDetails updateAlertDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getAlertId() {
        return this.alertId;
    }

    public UpdateAlertDetails getUpdateAlertDetails() {
        return this.updateAlertDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateAlertDetails getBody$() {
        return this.updateAlertDetails;
    }

    public Builder toBuilder() {
        return new Builder().alertId(this.alertId).updateAlertDetails(this.updateAlertDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",alertId=").append(String.valueOf(this.alertId));
        sb.append(",updateAlertDetails=").append(String.valueOf((Object)this.updateAlertDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateAlertRequest)) {
            return false;
        }
        UpdateAlertRequest other = (UpdateAlertRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.alertId, other.alertId) && Objects.equals((Object)this.updateAlertDetails, (Object)other.updateAlertDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.alertId == null ? 43 : this.alertId.hashCode());
        result = result * 59 + (this.updateAlertDetails == null ? 43 : this.updateAlertDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateAlertRequest, UpdateAlertDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String alertId = null;
        private UpdateAlertDetails updateAlertDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder alertId(String alertId) {
            this.alertId = alertId;
            return this;
        }

        public Builder updateAlertDetails(UpdateAlertDetails updateAlertDetails) {
            this.updateAlertDetails = updateAlertDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateAlertRequest o) {
            this.alertId(o.getAlertId());
            this.updateAlertDetails(o.getUpdateAlertDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateAlertRequest build() {
            UpdateAlertRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateAlertDetails body) {
            this.updateAlertDetails(body);
            return this;
        }

        public UpdateAlertRequest buildWithoutInvocationCallback() {
            UpdateAlertRequest request = new UpdateAlertRequest();
            request.alertId = this.alertId;
            request.updateAlertDetails = this.updateAlertDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

