/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.EntryDetails;
import java.util.Date;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="entryType")
@JsonFilter(value="explicitlySetFilter")
public final class FirewallPolicyEntryDetails
extends EntryDetails {
    @JsonProperty(value="timeGenerated")
    private final Date timeGenerated;
    @JsonProperty(value="timeStatusUpdated")
    private final Date timeStatusUpdated;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FirewallPolicyEntryDetails(Date timeGenerated, Date timeStatusUpdated) {
        this.timeGenerated = timeGenerated;
        this.timeStatusUpdated = timeStatusUpdated;
    }

    public Date getTimeGenerated() {
        return this.timeGenerated;
    }

    public Date getTimeStatusUpdated() {
        return this.timeStatusUpdated;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FirewallPolicyEntryDetails(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", timeGenerated=").append(String.valueOf(this.timeGenerated));
        sb.append(", timeStatusUpdated=").append(String.valueOf(this.timeStatusUpdated));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FirewallPolicyEntryDetails)) {
            return false;
        }
        FirewallPolicyEntryDetails other = (FirewallPolicyEntryDetails)((Object)o);
        return Objects.equals(this.timeGenerated, other.timeGenerated) && Objects.equals(this.timeStatusUpdated, other.timeStatusUpdated) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.timeGenerated == null ? 43 : this.timeGenerated.hashCode());
        result = result * 59 + (this.timeStatusUpdated == null ? 43 : this.timeStatusUpdated.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="timeGenerated")
        private Date timeGenerated;
        @JsonProperty(value="timeStatusUpdated")
        private Date timeStatusUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder timeGenerated(Date timeGenerated) {
            this.timeGenerated = timeGenerated;
            this.__explicitlySet__.add("timeGenerated");
            return this;
        }

        public Builder timeStatusUpdated(Date timeStatusUpdated) {
            this.timeStatusUpdated = timeStatusUpdated;
            this.__explicitlySet__.add("timeStatusUpdated");
            return this;
        }

        public FirewallPolicyEntryDetails build() {
            FirewallPolicyEntryDetails model = new FirewallPolicyEntryDetails(this.timeGenerated, this.timeStatusUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FirewallPolicyEntryDetails model) {
            if (model.wasPropertyExplicitlySet("timeGenerated")) {
                this.timeGenerated(model.getTimeGenerated());
            }
            if (model.wasPropertyExplicitlySet("timeStatusUpdated")) {
                this.timeStatusUpdated(model.getTimeStatusUpdated());
            }
            return this;
        }
    }
}

