/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.ObjectType;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaskingObjectSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="objectType")
    private final ObjectType objectType;

    @Deprecated
    @ConstructorProperties(value={"schemaName", "objectName", "objectType"})
    public MaskingObjectSummary(String schemaName, String objectName, ObjectType objectType) {
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.objectType = objectType;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaskingObjectSummary(");
        sb.append("super=").append(super.toString());
        sb.append("schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskingObjectSummary)) {
            return false;
        }
        MaskingObjectSummary other = (MaskingObjectSummary)((Object)o);
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals((Object)this.objectType, (Object)other.objectType) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public MaskingObjectSummary build() {
            MaskingObjectSummary model = new MaskingObjectSummary(this.schemaName, this.objectName, this.objectType);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaskingObjectSummary model) {
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            return this;
        }
    }
}

