/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlFirewallViolationAggregationDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="operationTime")
    private final List<Date> operationTime;
    @JsonProperty(value="dbUserName")
    private final List<String> dbUserName;
    @JsonProperty(value="targetId")
    private final List<String> targetId;
    @JsonProperty(value="targetName")
    private final List<String> targetName;
    @JsonProperty(value="clientProgram")
    private final List<String> clientProgram;
    @JsonProperty(value="operation")
    private final List<String> operation;
    @JsonProperty(value="clientOsUserName")
    private final List<String> clientOsUserName;
    @JsonProperty(value="violationCause")
    private final List<String> violationCause;
    @JsonProperty(value="clientIp")
    private final List<String> clientIp;
    @JsonProperty(value="violationAction")
    private final List<String> violationAction;
    @JsonProperty(value="sqlLevel")
    private final List<SqlLevel> sqlLevel;

    @Deprecated
    @ConstructorProperties(value={"operationTime", "dbUserName", "targetId", "targetName", "clientProgram", "operation", "clientOsUserName", "violationCause", "clientIp", "violationAction", "sqlLevel"})
    public SqlFirewallViolationAggregationDimensions(List<Date> operationTime, List<String> dbUserName, List<String> targetId, List<String> targetName, List<String> clientProgram, List<String> operation, List<String> clientOsUserName, List<String> violationCause, List<String> clientIp, List<String> violationAction, List<SqlLevel> sqlLevel) {
        this.operationTime = operationTime;
        this.dbUserName = dbUserName;
        this.targetId = targetId;
        this.targetName = targetName;
        this.clientProgram = clientProgram;
        this.operation = operation;
        this.clientOsUserName = clientOsUserName;
        this.violationCause = violationCause;
        this.clientIp = clientIp;
        this.violationAction = violationAction;
        this.sqlLevel = sqlLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Date> getOperationTime() {
        return this.operationTime;
    }

    public List<String> getDbUserName() {
        return this.dbUserName;
    }

    public List<String> getTargetId() {
        return this.targetId;
    }

    public List<String> getTargetName() {
        return this.targetName;
    }

    public List<String> getClientProgram() {
        return this.clientProgram;
    }

    public List<String> getOperation() {
        return this.operation;
    }

    public List<String> getClientOsUserName() {
        return this.clientOsUserName;
    }

    public List<String> getViolationCause() {
        return this.violationCause;
    }

    public List<String> getClientIp() {
        return this.clientIp;
    }

    public List<String> getViolationAction() {
        return this.violationAction;
    }

    public List<SqlLevel> getSqlLevel() {
        return this.sqlLevel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlFirewallViolationAggregationDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("operationTime=").append(String.valueOf(this.operationTime));
        sb.append(", dbUserName=").append(String.valueOf(this.dbUserName));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetName=").append(String.valueOf(this.targetName));
        sb.append(", clientProgram=").append(String.valueOf(this.clientProgram));
        sb.append(", operation=").append(String.valueOf(this.operation));
        sb.append(", clientOsUserName=").append(String.valueOf(this.clientOsUserName));
        sb.append(", violationCause=").append(String.valueOf(this.violationCause));
        sb.append(", clientIp=").append(String.valueOf(this.clientIp));
        sb.append(", violationAction=").append(String.valueOf(this.violationAction));
        sb.append(", sqlLevel=").append(String.valueOf(this.sqlLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFirewallViolationAggregationDimensions)) {
            return false;
        }
        SqlFirewallViolationAggregationDimensions other = (SqlFirewallViolationAggregationDimensions)((Object)o);
        return Objects.equals(this.operationTime, other.operationTime) && Objects.equals(this.dbUserName, other.dbUserName) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.clientProgram, other.clientProgram) && Objects.equals(this.operation, other.operation) && Objects.equals(this.clientOsUserName, other.clientOsUserName) && Objects.equals(this.violationCause, other.violationCause) && Objects.equals(this.clientIp, other.clientIp) && Objects.equals(this.violationAction, other.violationAction) && Objects.equals(this.sqlLevel, other.sqlLevel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.operationTime == null ? 43 : this.operationTime.hashCode());
        result = result * 59 + (this.dbUserName == null ? 43 : this.dbUserName.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.clientProgram == null ? 43 : this.clientProgram.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.clientOsUserName == null ? 43 : this.clientOsUserName.hashCode());
        result = result * 59 + (this.violationCause == null ? 43 : this.violationCause.hashCode());
        result = result * 59 + (this.clientIp == null ? 43 : this.clientIp.hashCode());
        result = result * 59 + (this.violationAction == null ? 43 : this.violationAction.hashCode());
        result = result * 59 + (this.sqlLevel == null ? 43 : this.sqlLevel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum SqlLevel implements BmcEnum
    {
        UserIssuedSql("USER_ISSUED_SQL"),
        AllSql("ALL_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SqlLevel> map;

        private SqlLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SqlLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SqlLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SqlLevel.class);
            map = new HashMap<String, SqlLevel>();
            for (SqlLevel v : SqlLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="operationTime")
        private List<Date> operationTime;
        @JsonProperty(value="dbUserName")
        private List<String> dbUserName;
        @JsonProperty(value="targetId")
        private List<String> targetId;
        @JsonProperty(value="targetName")
        private List<String> targetName;
        @JsonProperty(value="clientProgram")
        private List<String> clientProgram;
        @JsonProperty(value="operation")
        private List<String> operation;
        @JsonProperty(value="clientOsUserName")
        private List<String> clientOsUserName;
        @JsonProperty(value="violationCause")
        private List<String> violationCause;
        @JsonProperty(value="clientIp")
        private List<String> clientIp;
        @JsonProperty(value="violationAction")
        private List<String> violationAction;
        @JsonProperty(value="sqlLevel")
        private List<SqlLevel> sqlLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder operationTime(List<Date> operationTime) {
            this.operationTime = operationTime;
            this.__explicitlySet__.add("operationTime");
            return this;
        }

        public Builder dbUserName(List<String> dbUserName) {
            this.dbUserName = dbUserName;
            this.__explicitlySet__.add("dbUserName");
            return this;
        }

        public Builder targetId(List<String> targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetName(List<String> targetName) {
            this.targetName = targetName;
            this.__explicitlySet__.add("targetName");
            return this;
        }

        public Builder clientProgram(List<String> clientProgram) {
            this.clientProgram = clientProgram;
            this.__explicitlySet__.add("clientProgram");
            return this;
        }

        public Builder operation(List<String> operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder clientOsUserName(List<String> clientOsUserName) {
            this.clientOsUserName = clientOsUserName;
            this.__explicitlySet__.add("clientOsUserName");
            return this;
        }

        public Builder violationCause(List<String> violationCause) {
            this.violationCause = violationCause;
            this.__explicitlySet__.add("violationCause");
            return this;
        }

        public Builder clientIp(List<String> clientIp) {
            this.clientIp = clientIp;
            this.__explicitlySet__.add("clientIp");
            return this;
        }

        public Builder violationAction(List<String> violationAction) {
            this.violationAction = violationAction;
            this.__explicitlySet__.add("violationAction");
            return this;
        }

        public Builder sqlLevel(List<SqlLevel> sqlLevel) {
            this.sqlLevel = sqlLevel;
            this.__explicitlySet__.add("sqlLevel");
            return this;
        }

        public SqlFirewallViolationAggregationDimensions build() {
            SqlFirewallViolationAggregationDimensions model = new SqlFirewallViolationAggregationDimensions(this.operationTime, this.dbUserName, this.targetId, this.targetName, this.clientProgram, this.operation, this.clientOsUserName, this.violationCause, this.clientIp, this.violationAction, this.sqlLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlFirewallViolationAggregationDimensions model) {
            if (model.wasPropertyExplicitlySet("operationTime")) {
                this.operationTime(model.getOperationTime());
            }
            if (model.wasPropertyExplicitlySet("dbUserName")) {
                this.dbUserName(model.getDbUserName());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetName")) {
                this.targetName(model.getTargetName());
            }
            if (model.wasPropertyExplicitlySet("clientProgram")) {
                this.clientProgram(model.getClientProgram());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("clientOsUserName")) {
                this.clientOsUserName(model.getClientOsUserName());
            }
            if (model.wasPropertyExplicitlySet("violationCause")) {
                this.violationCause(model.getViolationCause());
            }
            if (model.wasPropertyExplicitlySet("clientIp")) {
                this.clientIp(model.getClientIp());
            }
            if (model.wasPropertyExplicitlySet("violationAction")) {
                this.violationAction(model.getViolationAction());
            }
            if (model.wasPropertyExplicitlySet("sqlLevel")) {
                this.sqlLevel(model.getSqlLevel());
            }
            return this;
        }
    }
}

