/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.ConnectionOption;
import com.oracle.bmc.datasafe.model.Credentials;
import com.oracle.bmc.datasafe.model.DatabaseDetails;
import com.oracle.bmc.datasafe.model.PeerTargetDatabase;
import com.oracle.bmc.datasafe.model.TargetDatabaseLifecycleState;
import com.oracle.bmc.datasafe.model.TlsConfig;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class TargetDatabase
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="databaseDetails")
    private final DatabaseDetails databaseDetails;
    @JsonProperty(value="credentials")
    private final Credentials credentials;
    @JsonProperty(value="tlsConfig")
    private final TlsConfig tlsConfig;
    @JsonProperty(value="connectionOption")
    private final ConnectionOption connectionOption;
    @JsonProperty(value="associatedResourceIds")
    private final List<String> associatedResourceIds;
    @JsonProperty(value="lifecycleState")
    private final TargetDatabaseLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="peerTargetDatabases")
    private final List<PeerTargetDatabase> peerTargetDatabases;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "id", "displayName", "description", "databaseDetails", "credentials", "tlsConfig", "connectionOption", "associatedResourceIds", "lifecycleState", "lifecycleDetails", "timeCreated", "timeUpdated", "peerTargetDatabases", "freeformTags", "definedTags", "systemTags"})
    public TargetDatabase(String compartmentId, String id, String displayName, String description, DatabaseDetails databaseDetails, Credentials credentials, TlsConfig tlsConfig, ConnectionOption connectionOption, List<String> associatedResourceIds, TargetDatabaseLifecycleState lifecycleState, String lifecycleDetails, Date timeCreated, Date timeUpdated, List<PeerTargetDatabase> peerTargetDatabases, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.compartmentId = compartmentId;
        this.id = id;
        this.displayName = displayName;
        this.description = description;
        this.databaseDetails = databaseDetails;
        this.credentials = credentials;
        this.tlsConfig = tlsConfig;
        this.connectionOption = connectionOption;
        this.associatedResourceIds = associatedResourceIds;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.peerTargetDatabases = peerTargetDatabases;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public DatabaseDetails getDatabaseDetails() {
        return this.databaseDetails;
    }

    public Credentials getCredentials() {
        return this.credentials;
    }

    public TlsConfig getTlsConfig() {
        return this.tlsConfig;
    }

    public ConnectionOption getConnectionOption() {
        return this.connectionOption;
    }

    public List<String> getAssociatedResourceIds() {
        return this.associatedResourceIds;
    }

    public TargetDatabaseLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public List<PeerTargetDatabase> getPeerTargetDatabases() {
        return this.peerTargetDatabases;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("TargetDatabase(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", databaseDetails=").append(String.valueOf((Object)this.databaseDetails));
        sb.append(", credentials=").append(String.valueOf((Object)this.credentials));
        sb.append(", tlsConfig=").append(String.valueOf((Object)this.tlsConfig));
        sb.append(", connectionOption=").append(String.valueOf((Object)this.connectionOption));
        sb.append(", associatedResourceIds=").append(String.valueOf(this.associatedResourceIds));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", peerTargetDatabases=").append(String.valueOf(this.peerTargetDatabases));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TargetDatabase)) {
            return false;
        }
        TargetDatabase other = (TargetDatabase)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.databaseDetails, (Object)other.databaseDetails) && Objects.equals((Object)this.credentials, (Object)other.credentials) && Objects.equals((Object)this.tlsConfig, (Object)other.tlsConfig) && Objects.equals((Object)this.connectionOption, (Object)other.connectionOption) && Objects.equals(this.associatedResourceIds, other.associatedResourceIds) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.peerTargetDatabases, other.peerTargetDatabases) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.databaseDetails == null ? 43 : this.databaseDetails.hashCode());
        result = result * 59 + (this.credentials == null ? 43 : this.credentials.hashCode());
        result = result * 59 + (this.tlsConfig == null ? 43 : this.tlsConfig.hashCode());
        result = result * 59 + (this.connectionOption == null ? 43 : this.connectionOption.hashCode());
        result = result * 59 + (this.associatedResourceIds == null ? 43 : this.associatedResourceIds.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.peerTargetDatabases == null ? 43 : this.peerTargetDatabases.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="databaseDetails")
        private DatabaseDetails databaseDetails;
        @JsonProperty(value="credentials")
        private Credentials credentials;
        @JsonProperty(value="tlsConfig")
        private TlsConfig tlsConfig;
        @JsonProperty(value="connectionOption")
        private ConnectionOption connectionOption;
        @JsonProperty(value="associatedResourceIds")
        private List<String> associatedResourceIds;
        @JsonProperty(value="lifecycleState")
        private TargetDatabaseLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="peerTargetDatabases")
        private List<PeerTargetDatabase> peerTargetDatabases;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder databaseDetails(DatabaseDetails databaseDetails) {
            this.databaseDetails = databaseDetails;
            this.__explicitlySet__.add("databaseDetails");
            return this;
        }

        public Builder credentials(Credentials credentials) {
            this.credentials = credentials;
            this.__explicitlySet__.add("credentials");
            return this;
        }

        public Builder tlsConfig(TlsConfig tlsConfig) {
            this.tlsConfig = tlsConfig;
            this.__explicitlySet__.add("tlsConfig");
            return this;
        }

        public Builder connectionOption(ConnectionOption connectionOption) {
            this.connectionOption = connectionOption;
            this.__explicitlySet__.add("connectionOption");
            return this;
        }

        public Builder associatedResourceIds(List<String> associatedResourceIds) {
            this.associatedResourceIds = associatedResourceIds;
            this.__explicitlySet__.add("associatedResourceIds");
            return this;
        }

        public Builder lifecycleState(TargetDatabaseLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder peerTargetDatabases(List<PeerTargetDatabase> peerTargetDatabases) {
            this.peerTargetDatabases = peerTargetDatabases;
            this.__explicitlySet__.add("peerTargetDatabases");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public TargetDatabase build() {
            TargetDatabase model = new TargetDatabase(this.compartmentId, this.id, this.displayName, this.description, this.databaseDetails, this.credentials, this.tlsConfig, this.connectionOption, this.associatedResourceIds, this.lifecycleState, this.lifecycleDetails, this.timeCreated, this.timeUpdated, this.peerTargetDatabases, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(TargetDatabase model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("databaseDetails")) {
                this.databaseDetails(model.getDatabaseDetails());
            }
            if (model.wasPropertyExplicitlySet("credentials")) {
                this.credentials(model.getCredentials());
            }
            if (model.wasPropertyExplicitlySet("tlsConfig")) {
                this.tlsConfig(model.getTlsConfig());
            }
            if (model.wasPropertyExplicitlySet("connectionOption")) {
                this.connectionOption(model.getConnectionOption());
            }
            if (model.wasPropertyExplicitlySet("associatedResourceIds")) {
                this.associatedResourceIds(model.getAssociatedResourceIds());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("peerTargetDatabases")) {
                this.peerTargetDatabases(model.getPeerTargetDatabases());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

