/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetSqlFirewallPolicyRequest
extends BmcRequest<Void> {
    private String sqlFirewallPolicyId;
    private String opcRequestId;

    public String getSqlFirewallPolicyId() {
        return this.sqlFirewallPolicyId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().sqlFirewallPolicyId(this.sqlFirewallPolicyId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sqlFirewallPolicyId=").append(String.valueOf(this.sqlFirewallPolicyId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetSqlFirewallPolicyRequest)) {
            return false;
        }
        GetSqlFirewallPolicyRequest other = (GetSqlFirewallPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sqlFirewallPolicyId, other.sqlFirewallPolicyId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlFirewallPolicyId == null ? 43 : this.sqlFirewallPolicyId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetSqlFirewallPolicyRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sqlFirewallPolicyId = null;
        private String opcRequestId = null;

        public Builder sqlFirewallPolicyId(String sqlFirewallPolicyId) {
            this.sqlFirewallPolicyId = sqlFirewallPolicyId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetSqlFirewallPolicyRequest o) {
            this.sqlFirewallPolicyId(o.getSqlFirewallPolicyId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetSqlFirewallPolicyRequest build() {
            GetSqlFirewallPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetSqlFirewallPolicyRequest buildWithoutInvocationCallback() {
            GetSqlFirewallPolicyRequest request = new GetSqlFirewallPolicyRequest();
            request.sqlFirewallPolicyId = this.sqlFirewallPolicyId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

