/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListColumnsRequest
extends BmcRequest<Void> {
    private String targetDatabaseId;
    private String opcRequestId;
    private Integer limit;
    private String page;
    private List<String> schemaName;
    private List<String> tableName;
    private List<String> columnName;
    private List<String> datatype;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String schemaNameContains;
    private String tableNameContains;
    private String columnNameContains;

    public String getTargetDatabaseId() {
        return this.targetDatabaseId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public List<String> getSchemaName() {
        return this.schemaName;
    }

    public List<String> getTableName() {
        return this.tableName;
    }

    public List<String> getColumnName() {
        return this.columnName;
    }

    public List<String> getDatatype() {
        return this.datatype;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getSchemaNameContains() {
        return this.schemaNameContains;
    }

    public String getTableNameContains() {
        return this.tableNameContains;
    }

    public String getColumnNameContains() {
        return this.columnNameContains;
    }

    public Builder toBuilder() {
        return new Builder().targetDatabaseId(this.targetDatabaseId).opcRequestId(this.opcRequestId).limit(this.limit).page(this.page).schemaName(this.schemaName).tableName(this.tableName).columnName(this.columnName).datatype(this.datatype).sortOrder(this.sortOrder).sortBy(this.sortBy).schemaNameContains(this.schemaNameContains).tableNameContains(this.tableNameContains).columnNameContains(this.columnNameContains);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetDatabaseId=").append(String.valueOf(this.targetDatabaseId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",schemaName=").append(String.valueOf(this.schemaName));
        sb.append(",tableName=").append(String.valueOf(this.tableName));
        sb.append(",columnName=").append(String.valueOf(this.columnName));
        sb.append(",datatype=").append(String.valueOf(this.datatype));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",schemaNameContains=").append(String.valueOf(this.schemaNameContains));
        sb.append(",tableNameContains=").append(String.valueOf(this.tableNameContains));
        sb.append(",columnNameContains=").append(String.valueOf(this.columnNameContains));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListColumnsRequest)) {
            return false;
        }
        ListColumnsRequest other = (ListColumnsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetDatabaseId, other.targetDatabaseId) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.datatype, other.datatype) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.schemaNameContains, other.schemaNameContains) && Objects.equals(this.tableNameContains, other.tableNameContains) && Objects.equals(this.columnNameContains, other.columnNameContains);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetDatabaseId == null ? 43 : this.targetDatabaseId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.tableName == null ? 43 : this.tableName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.datatype == null ? 43 : this.datatype.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.schemaNameContains == null ? 43 : this.schemaNameContains.hashCode());
        result = result * 59 + (this.tableNameContains == null ? 43 : this.tableNameContains.hashCode());
        result = result * 59 + (this.columnNameContains == null ? 43 : this.columnNameContains.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListColumnsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetDatabaseId = null;
        private String opcRequestId = null;
        private Integer limit = null;
        private String page = null;
        private List<String> schemaName = null;
        private List<String> tableName = null;
        private List<String> columnName = null;
        private List<String> datatype = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String schemaNameContains = null;
        private String tableNameContains = null;
        private String columnNameContains = null;

        public Builder targetDatabaseId(String targetDatabaseId) {
            this.targetDatabaseId = targetDatabaseId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder schemaName(List<String> schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder schemaName(String singularValue) {
            return this.schemaName(Arrays.asList(singularValue));
        }

        public Builder tableName(List<String> tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder tableName(String singularValue) {
            return this.tableName(Arrays.asList(singularValue));
        }

        public Builder columnName(List<String> columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder columnName(String singularValue) {
            return this.columnName(Arrays.asList(singularValue));
        }

        public Builder datatype(List<String> datatype) {
            this.datatype = datatype;
            return this;
        }

        public Builder datatype(String singularValue) {
            return this.datatype(Arrays.asList(singularValue));
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder schemaNameContains(String schemaNameContains) {
            this.schemaNameContains = schemaNameContains;
            return this;
        }

        public Builder tableNameContains(String tableNameContains) {
            this.tableNameContains = tableNameContains;
            return this;
        }

        public Builder columnNameContains(String columnNameContains) {
            this.columnNameContains = columnNameContains;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListColumnsRequest o) {
            this.targetDatabaseId(o.getTargetDatabaseId());
            this.opcRequestId(o.getOpcRequestId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.schemaName(o.getSchemaName());
            this.tableName(o.getTableName());
            this.columnName(o.getColumnName());
            this.datatype(o.getDatatype());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.schemaNameContains(o.getSchemaNameContains());
            this.tableNameContains(o.getTableNameContains());
            this.columnNameContains(o.getColumnNameContains());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListColumnsRequest build() {
            ListColumnsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListColumnsRequest buildWithoutInvocationCallback() {
            ListColumnsRequest request = new ListColumnsRequest();
            request.targetDatabaseId = this.targetDatabaseId;
            request.opcRequestId = this.opcRequestId;
            request.limit = this.limit;
            request.page = this.page;
            request.schemaName = this.schemaName;
            request.tableName = this.tableName;
            request.columnName = this.columnName;
            request.datatype = this.datatype;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.schemaNameContains = this.schemaNameContains;
            request.tableNameContains = this.tableNameContains;
            request.columnNameContains = this.columnNameContains;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        Schemaname("SCHEMANAME"),
        Tablename("TABLENAME"),
        Columnname("COLUMNNAME"),
        Datatype("DATATYPE");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

