/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.datasafe.model.MaskingColumnLifecycleState;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListMaskingColumnsRequest
extends BmcRequest<Void> {
    private String maskingPolicyId;
    private Integer limit;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private MaskingColumnLifecycleState maskingColumnLifecycleState;
    private List<DataType> dataType;
    private List<String> schemaName;
    private List<String> objectName;
    private List<String> columnName;
    private List<ObjectType> objectType;
    private List<String> maskingColumnGroup;
    private String sensitiveTypeId;
    private Boolean isMaskingEnabled;
    private Boolean isSeedRequired;
    private Date timeCreatedGreaterThanOrEqualTo;
    private Date timeCreatedLessThan;
    private Date timeUpdatedGreaterThanOrEqualTo;
    private Date timeUpdatedLessThan;
    private String opcRequestId;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public MaskingColumnLifecycleState getMaskingColumnLifecycleState() {
        return this.maskingColumnLifecycleState;
    }

    public List<DataType> getDataType() {
        return this.dataType;
    }

    public List<String> getSchemaName() {
        return this.schemaName;
    }

    public List<String> getObjectName() {
        return this.objectName;
    }

    public List<String> getColumnName() {
        return this.columnName;
    }

    public List<ObjectType> getObjectType() {
        return this.objectType;
    }

    public List<String> getMaskingColumnGroup() {
        return this.maskingColumnGroup;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public Boolean getIsMaskingEnabled() {
        return this.isMaskingEnabled;
    }

    public Boolean getIsSeedRequired() {
        return this.isSeedRequired;
    }

    public Date getTimeCreatedGreaterThanOrEqualTo() {
        return this.timeCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeCreatedLessThan() {
        return this.timeCreatedLessThan;
    }

    public Date getTimeUpdatedGreaterThanOrEqualTo() {
        return this.timeUpdatedGreaterThanOrEqualTo;
    }

    public Date getTimeUpdatedLessThan() {
        return this.timeUpdatedLessThan;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).limit(this.limit).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).maskingColumnLifecycleState(this.maskingColumnLifecycleState).dataType(this.dataType).schemaName(this.schemaName).objectName(this.objectName).columnName(this.columnName).objectType(this.objectType).maskingColumnGroup(this.maskingColumnGroup).sensitiveTypeId(this.sensitiveTypeId).isMaskingEnabled(this.isMaskingEnabled).isSeedRequired(this.isSeedRequired).timeCreatedGreaterThanOrEqualTo(this.timeCreatedGreaterThanOrEqualTo).timeCreatedLessThan(this.timeCreatedLessThan).timeUpdatedGreaterThanOrEqualTo(this.timeUpdatedGreaterThanOrEqualTo).timeUpdatedLessThan(this.timeUpdatedLessThan).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",maskingColumnLifecycleState=").append(String.valueOf((Object)this.maskingColumnLifecycleState));
        sb.append(",dataType=").append(String.valueOf(this.dataType));
        sb.append(",schemaName=").append(String.valueOf(this.schemaName));
        sb.append(",objectName=").append(String.valueOf(this.objectName));
        sb.append(",columnName=").append(String.valueOf(this.columnName));
        sb.append(",objectType=").append(String.valueOf(this.objectType));
        sb.append(",maskingColumnGroup=").append(String.valueOf(this.maskingColumnGroup));
        sb.append(",sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(",isMaskingEnabled=").append(String.valueOf(this.isMaskingEnabled));
        sb.append(",isSeedRequired=").append(String.valueOf(this.isSeedRequired));
        sb.append(",timeCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeCreatedGreaterThanOrEqualTo));
        sb.append(",timeCreatedLessThan=").append(String.valueOf(this.timeCreatedLessThan));
        sb.append(",timeUpdatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUpdatedGreaterThanOrEqualTo));
        sb.append(",timeUpdatedLessThan=").append(String.valueOf(this.timeUpdatedLessThan));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListMaskingColumnsRequest)) {
            return false;
        }
        ListMaskingColumnsRequest other = (ListMaskingColumnsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.maskingColumnLifecycleState, (Object)other.maskingColumnLifecycleState) && Objects.equals(this.dataType, other.dataType) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.columnName, other.columnName) && Objects.equals(this.objectType, other.objectType) && Objects.equals(this.maskingColumnGroup, other.maskingColumnGroup) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals(this.isMaskingEnabled, other.isMaskingEnabled) && Objects.equals(this.isSeedRequired, other.isSeedRequired) && Objects.equals(this.timeCreatedGreaterThanOrEqualTo, other.timeCreatedGreaterThanOrEqualTo) && Objects.equals(this.timeCreatedLessThan, other.timeCreatedLessThan) && Objects.equals(this.timeUpdatedGreaterThanOrEqualTo, other.timeUpdatedGreaterThanOrEqualTo) && Objects.equals(this.timeUpdatedLessThan, other.timeUpdatedLessThan) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.maskingColumnLifecycleState == null ? 43 : this.maskingColumnLifecycleState.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.maskingColumnGroup == null ? 43 : this.maskingColumnGroup.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.isMaskingEnabled == null ? 43 : this.isMaskingEnabled.hashCode());
        result = result * 59 + (this.isSeedRequired == null ? 43 : this.isSeedRequired.hashCode());
        result = result * 59 + (this.timeCreatedGreaterThanOrEqualTo == null ? 43 : this.timeCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeCreatedLessThan == null ? 43 : this.timeCreatedLessThan.hashCode());
        result = result * 59 + (this.timeUpdatedGreaterThanOrEqualTo == null ? 43 : this.timeUpdatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUpdatedLessThan == null ? 43 : this.timeUpdatedLessThan.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListMaskingColumnsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private Integer limit = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private MaskingColumnLifecycleState maskingColumnLifecycleState = null;
        private List<DataType> dataType = null;
        private List<String> schemaName = null;
        private List<String> objectName = null;
        private List<String> columnName = null;
        private List<ObjectType> objectType = null;
        private List<String> maskingColumnGroup = null;
        private String sensitiveTypeId = null;
        private Boolean isMaskingEnabled = null;
        private Boolean isSeedRequired = null;
        private Date timeCreatedGreaterThanOrEqualTo = null;
        private Date timeCreatedLessThan = null;
        private Date timeUpdatedGreaterThanOrEqualTo = null;
        private Date timeUpdatedLessThan = null;
        private String opcRequestId = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder maskingColumnLifecycleState(MaskingColumnLifecycleState maskingColumnLifecycleState) {
            this.maskingColumnLifecycleState = maskingColumnLifecycleState;
            return this;
        }

        public Builder dataType(List<DataType> dataType) {
            this.dataType = dataType;
            return this;
        }

        public Builder dataType(DataType singularValue) {
            return this.dataType(Arrays.asList(singularValue));
        }

        public Builder schemaName(List<String> schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder schemaName(String singularValue) {
            return this.schemaName(Arrays.asList(singularValue));
        }

        public Builder objectName(List<String> objectName) {
            this.objectName = objectName;
            return this;
        }

        public Builder objectName(String singularValue) {
            return this.objectName(Arrays.asList(singularValue));
        }

        public Builder columnName(List<String> columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder columnName(String singularValue) {
            return this.columnName(Arrays.asList(singularValue));
        }

        public Builder objectType(List<ObjectType> objectType) {
            this.objectType = objectType;
            return this;
        }

        public Builder objectType(ObjectType singularValue) {
            return this.objectType(Arrays.asList(singularValue));
        }

        public Builder maskingColumnGroup(List<String> maskingColumnGroup) {
            this.maskingColumnGroup = maskingColumnGroup;
            return this;
        }

        public Builder maskingColumnGroup(String singularValue) {
            return this.maskingColumnGroup(Arrays.asList(singularValue));
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            return this;
        }

        public Builder isMaskingEnabled(Boolean isMaskingEnabled) {
            this.isMaskingEnabled = isMaskingEnabled;
            return this;
        }

        public Builder isSeedRequired(Boolean isSeedRequired) {
            this.isSeedRequired = isSeedRequired;
            return this;
        }

        public Builder timeCreatedGreaterThanOrEqualTo(Date timeCreatedGreaterThanOrEqualTo) {
            this.timeCreatedGreaterThanOrEqualTo = timeCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeCreatedLessThan(Date timeCreatedLessThan) {
            this.timeCreatedLessThan = timeCreatedLessThan;
            return this;
        }

        public Builder timeUpdatedGreaterThanOrEqualTo(Date timeUpdatedGreaterThanOrEqualTo) {
            this.timeUpdatedGreaterThanOrEqualTo = timeUpdatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUpdatedLessThan(Date timeUpdatedLessThan) {
            this.timeUpdatedLessThan = timeUpdatedLessThan;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListMaskingColumnsRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.maskingColumnLifecycleState(o.getMaskingColumnLifecycleState());
            this.dataType(o.getDataType());
            this.schemaName(o.getSchemaName());
            this.objectName(o.getObjectName());
            this.columnName(o.getColumnName());
            this.objectType(o.getObjectType());
            this.maskingColumnGroup(o.getMaskingColumnGroup());
            this.sensitiveTypeId(o.getSensitiveTypeId());
            this.isMaskingEnabled(o.getIsMaskingEnabled());
            this.isSeedRequired(o.getIsSeedRequired());
            this.timeCreatedGreaterThanOrEqualTo(o.getTimeCreatedGreaterThanOrEqualTo());
            this.timeCreatedLessThan(o.getTimeCreatedLessThan());
            this.timeUpdatedGreaterThanOrEqualTo(o.getTimeUpdatedGreaterThanOrEqualTo());
            this.timeUpdatedLessThan(o.getTimeUpdatedLessThan());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListMaskingColumnsRequest build() {
            ListMaskingColumnsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListMaskingColumnsRequest buildWithoutInvocationCallback() {
            ListMaskingColumnsRequest request = new ListMaskingColumnsRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.limit = this.limit;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.maskingColumnLifecycleState = this.maskingColumnLifecycleState;
            request.dataType = this.dataType;
            request.schemaName = this.schemaName;
            request.objectName = this.objectName;
            request.columnName = this.columnName;
            request.objectType = this.objectType;
            request.maskingColumnGroup = this.maskingColumnGroup;
            request.sensitiveTypeId = this.sensitiveTypeId;
            request.isMaskingEnabled = this.isMaskingEnabled;
            request.isSeedRequired = this.isSeedRequired;
            request.timeCreatedGreaterThanOrEqualTo = this.timeCreatedGreaterThanOrEqualTo;
            request.timeCreatedLessThan = this.timeCreatedLessThan;
            request.timeUpdatedGreaterThanOrEqualTo = this.timeUpdatedGreaterThanOrEqualTo;
            request.timeUpdatedLessThan = this.timeUpdatedLessThan;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }

    public static enum ObjectType implements BmcEnum
    {
        All("ALL"),
        Table("TABLE"),
        EditioningView("EDITIONING_VIEW");

        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ObjectType: " + key);
        }

        static {
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DataType implements BmcEnum
    {
        Character("CHARACTER"),
        Date("DATE"),
        Lob("LOB"),
        Numeric("NUMERIC");

        private final String value;
        private static Map<String, DataType> map;

        private DataType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DataType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid DataType: " + key);
        }

        static {
            map = new HashMap<String, DataType>();
            for (DataType v : DataType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        TimeCreated("timeCreated"),
        SchemaName("schemaName"),
        ObjectName("objectName"),
        DataType("dataType");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

