/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.AuditTrailSource;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuditEventSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbUserName")
    private final String dbUserName;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="targetName")
    private final String targetName;
    @JsonProperty(value="databaseType")
    private final DatabaseType databaseType;
    @JsonProperty(value="targetClass")
    private final TargetClass targetClass;
    @JsonProperty(value="auditEventTime")
    private final Date auditEventTime;
    @JsonProperty(value="timeCollected")
    private final Date timeCollected;
    @JsonProperty(value="osUserName")
    private final String osUserName;
    @JsonProperty(value="operation")
    private final String operation;
    @JsonProperty(value="operationStatus")
    private final OperationStatus operationStatus;
    @JsonProperty(value="eventName")
    private final String eventName;
    @JsonProperty(value="errorCode")
    private final String errorCode;
    @JsonProperty(value="errorMessage")
    private final String errorMessage;
    @JsonProperty(value="objectType")
    private final String objectType;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="objectOwner")
    private final String objectOwner;
    @JsonProperty(value="clientHostname")
    private final String clientHostname;
    @JsonProperty(value="clientIp")
    private final String clientIp;
    @JsonProperty(value="auditTrailId")
    private final String auditTrailId;
    @JsonProperty(value="isAlerted")
    private final Boolean isAlerted;
    @JsonProperty(value="actionTaken")
    private final String actionTaken;
    @JsonProperty(value="clientProgram")
    private final String clientProgram;
    @JsonProperty(value="commandText")
    private final String commandText;
    @JsonProperty(value="commandParam")
    private final String commandParam;
    @JsonProperty(value="extendedEventAttributes")
    private final String extendedEventAttributes;
    @JsonProperty(value="auditLocation")
    private final AuditLocation auditLocation;
    @JsonProperty(value="osTerminal")
    private final String osTerminal;
    @JsonProperty(value="clientId")
    private final String clientId;
    @JsonProperty(value="auditPolicies")
    private final String auditPolicies;
    @JsonProperty(value="auditType")
    private final AuditType auditType;
    @JsonProperty(value="peerTargetDatabaseKey")
    private final Integer peerTargetDatabaseKey;
    @JsonProperty(value="trailSource")
    private final AuditTrailSource trailSource;
    @JsonProperty(value="databaseUniqueName")
    private final String databaseUniqueName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "dbUserName", "targetId", "targetName", "databaseType", "targetClass", "auditEventTime", "timeCollected", "osUserName", "operation", "operationStatus", "eventName", "errorCode", "errorMessage", "objectType", "objectName", "objectOwner", "clientHostname", "clientIp", "auditTrailId", "isAlerted", "actionTaken", "clientProgram", "commandText", "commandParam", "extendedEventAttributes", "auditLocation", "osTerminal", "clientId", "auditPolicies", "auditType", "peerTargetDatabaseKey", "trailSource", "databaseUniqueName", "freeformTags", "definedTags"})
    public AuditEventSummary(String id, String compartmentId, String dbUserName, String targetId, String targetName, DatabaseType databaseType, TargetClass targetClass, Date auditEventTime, Date timeCollected, String osUserName, String operation, OperationStatus operationStatus, String eventName, String errorCode, String errorMessage, String objectType, String objectName, String objectOwner, String clientHostname, String clientIp, String auditTrailId, Boolean isAlerted, String actionTaken, String clientProgram, String commandText, String commandParam, String extendedEventAttributes, AuditLocation auditLocation, String osTerminal, String clientId, String auditPolicies, AuditType auditType, Integer peerTargetDatabaseKey, AuditTrailSource trailSource, String databaseUniqueName, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.dbUserName = dbUserName;
        this.targetId = targetId;
        this.targetName = targetName;
        this.databaseType = databaseType;
        this.targetClass = targetClass;
        this.auditEventTime = auditEventTime;
        this.timeCollected = timeCollected;
        this.osUserName = osUserName;
        this.operation = operation;
        this.operationStatus = operationStatus;
        this.eventName = eventName;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.objectType = objectType;
        this.objectName = objectName;
        this.objectOwner = objectOwner;
        this.clientHostname = clientHostname;
        this.clientIp = clientIp;
        this.auditTrailId = auditTrailId;
        this.isAlerted = isAlerted;
        this.actionTaken = actionTaken;
        this.clientProgram = clientProgram;
        this.commandText = commandText;
        this.commandParam = commandParam;
        this.extendedEventAttributes = extendedEventAttributes;
        this.auditLocation = auditLocation;
        this.osTerminal = osTerminal;
        this.clientId = clientId;
        this.auditPolicies = auditPolicies;
        this.auditType = auditType;
        this.peerTargetDatabaseKey = peerTargetDatabaseKey;
        this.trailSource = trailSource;
        this.databaseUniqueName = databaseUniqueName;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public TargetClass getTargetClass() {
        return this.targetClass;
    }

    public Date getAuditEventTime() {
        return this.auditEventTime;
    }

    public Date getTimeCollected() {
        return this.timeCollected;
    }

    public String getOsUserName() {
        return this.osUserName;
    }

    public String getOperation() {
        return this.operation;
    }

    public OperationStatus getOperationStatus() {
        return this.operationStatus;
    }

    public String getEventName() {
        return this.eventName;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getObjectOwner() {
        return this.objectOwner;
    }

    public String getClientHostname() {
        return this.clientHostname;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getAuditTrailId() {
        return this.auditTrailId;
    }

    public Boolean getIsAlerted() {
        return this.isAlerted;
    }

    public String getActionTaken() {
        return this.actionTaken;
    }

    public String getClientProgram() {
        return this.clientProgram;
    }

    public String getCommandText() {
        return this.commandText;
    }

    public String getCommandParam() {
        return this.commandParam;
    }

    public String getExtendedEventAttributes() {
        return this.extendedEventAttributes;
    }

    public AuditLocation getAuditLocation() {
        return this.auditLocation;
    }

    public String getOsTerminal() {
        return this.osTerminal;
    }

    public String getClientId() {
        return this.clientId;
    }

    public String getAuditPolicies() {
        return this.auditPolicies;
    }

    public AuditType getAuditType() {
        return this.auditType;
    }

    public Integer getPeerTargetDatabaseKey() {
        return this.peerTargetDatabaseKey;
    }

    public AuditTrailSource getTrailSource() {
        return this.trailSource;
    }

    public String getDatabaseUniqueName() {
        return this.databaseUniqueName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditEventSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dbUserName=").append(String.valueOf(this.dbUserName));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetName=").append(String.valueOf(this.targetName));
        sb.append(", databaseType=").append(String.valueOf((Object)this.databaseType));
        sb.append(", targetClass=").append(String.valueOf((Object)this.targetClass));
        sb.append(", auditEventTime=").append(String.valueOf(this.auditEventTime));
        sb.append(", timeCollected=").append(String.valueOf(this.timeCollected));
        sb.append(", osUserName=").append(String.valueOf(this.osUserName));
        sb.append(", operation=").append(String.valueOf(this.operation));
        sb.append(", operationStatus=").append(String.valueOf((Object)this.operationStatus));
        sb.append(", eventName=").append(String.valueOf(this.eventName));
        sb.append(", errorCode=").append(String.valueOf(this.errorCode));
        sb.append(", errorMessage=").append(String.valueOf(this.errorMessage));
        sb.append(", objectType=").append(String.valueOf(this.objectType));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", objectOwner=").append(String.valueOf(this.objectOwner));
        sb.append(", clientHostname=").append(String.valueOf(this.clientHostname));
        sb.append(", clientIp=").append(String.valueOf(this.clientIp));
        sb.append(", auditTrailId=").append(String.valueOf(this.auditTrailId));
        sb.append(", isAlerted=").append(String.valueOf(this.isAlerted));
        sb.append(", actionTaken=").append(String.valueOf(this.actionTaken));
        sb.append(", clientProgram=").append(String.valueOf(this.clientProgram));
        sb.append(", commandText=").append(String.valueOf(this.commandText));
        sb.append(", commandParam=").append(String.valueOf(this.commandParam));
        sb.append(", extendedEventAttributes=").append(String.valueOf(this.extendedEventAttributes));
        sb.append(", auditLocation=").append(String.valueOf((Object)this.auditLocation));
        sb.append(", osTerminal=").append(String.valueOf(this.osTerminal));
        sb.append(", clientId=").append(String.valueOf(this.clientId));
        sb.append(", auditPolicies=").append(String.valueOf(this.auditPolicies));
        sb.append(", auditType=").append(String.valueOf((Object)this.auditType));
        sb.append(", peerTargetDatabaseKey=").append(String.valueOf(this.peerTargetDatabaseKey));
        sb.append(", trailSource=").append(String.valueOf((Object)this.trailSource));
        sb.append(", databaseUniqueName=").append(String.valueOf(this.databaseUniqueName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditEventSummary)) {
            return false;
        }
        AuditEventSummary other = (AuditEventSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbUserName, other.dbUserName) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetName, other.targetName) && Objects.equals((Object)this.databaseType, (Object)other.databaseType) && Objects.equals((Object)this.targetClass, (Object)other.targetClass) && Objects.equals(this.auditEventTime, other.auditEventTime) && Objects.equals(this.timeCollected, other.timeCollected) && Objects.equals(this.osUserName, other.osUserName) && Objects.equals(this.operation, other.operation) && Objects.equals((Object)this.operationStatus, (Object)other.operationStatus) && Objects.equals(this.eventName, other.eventName) && Objects.equals(this.errorCode, other.errorCode) && Objects.equals(this.errorMessage, other.errorMessage) && Objects.equals(this.objectType, other.objectType) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.objectOwner, other.objectOwner) && Objects.equals(this.clientHostname, other.clientHostname) && Objects.equals(this.clientIp, other.clientIp) && Objects.equals(this.auditTrailId, other.auditTrailId) && Objects.equals(this.isAlerted, other.isAlerted) && Objects.equals(this.actionTaken, other.actionTaken) && Objects.equals(this.clientProgram, other.clientProgram) && Objects.equals(this.commandText, other.commandText) && Objects.equals(this.commandParam, other.commandParam) && Objects.equals(this.extendedEventAttributes, other.extendedEventAttributes) && Objects.equals((Object)this.auditLocation, (Object)other.auditLocation) && Objects.equals(this.osTerminal, other.osTerminal) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.auditPolicies, other.auditPolicies) && Objects.equals((Object)this.auditType, (Object)other.auditType) && Objects.equals(this.peerTargetDatabaseKey, other.peerTargetDatabaseKey) && Objects.equals((Object)this.trailSource, (Object)other.trailSource) && Objects.equals(this.databaseUniqueName, other.databaseUniqueName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbUserName == null ? 43 : this.dbUserName.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.databaseType == null ? 43 : this.databaseType.hashCode());
        result = result * 59 + (this.targetClass == null ? 43 : this.targetClass.hashCode());
        result = result * 59 + (this.auditEventTime == null ? 43 : this.auditEventTime.hashCode());
        result = result * 59 + (this.timeCollected == null ? 43 : this.timeCollected.hashCode());
        result = result * 59 + (this.osUserName == null ? 43 : this.osUserName.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.operationStatus == null ? 43 : this.operationStatus.hashCode());
        result = result * 59 + (this.eventName == null ? 43 : this.eventName.hashCode());
        result = result * 59 + (this.errorCode == null ? 43 : this.errorCode.hashCode());
        result = result * 59 + (this.errorMessage == null ? 43 : this.errorMessage.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.objectOwner == null ? 43 : this.objectOwner.hashCode());
        result = result * 59 + (this.clientHostname == null ? 43 : this.clientHostname.hashCode());
        result = result * 59 + (this.clientIp == null ? 43 : this.clientIp.hashCode());
        result = result * 59 + (this.auditTrailId == null ? 43 : this.auditTrailId.hashCode());
        result = result * 59 + (this.isAlerted == null ? 43 : this.isAlerted.hashCode());
        result = result * 59 + (this.actionTaken == null ? 43 : this.actionTaken.hashCode());
        result = result * 59 + (this.clientProgram == null ? 43 : this.clientProgram.hashCode());
        result = result * 59 + (this.commandText == null ? 43 : this.commandText.hashCode());
        result = result * 59 + (this.commandParam == null ? 43 : this.commandParam.hashCode());
        result = result * 59 + (this.extendedEventAttributes == null ? 43 : this.extendedEventAttributes.hashCode());
        result = result * 59 + (this.auditLocation == null ? 43 : this.auditLocation.hashCode());
        result = result * 59 + (this.osTerminal == null ? 43 : this.osTerminal.hashCode());
        result = result * 59 + (this.clientId == null ? 43 : this.clientId.hashCode());
        result = result * 59 + (this.auditPolicies == null ? 43 : this.auditPolicies.hashCode());
        result = result * 59 + (this.auditType == null ? 43 : this.auditType.hashCode());
        result = result * 59 + (this.peerTargetDatabaseKey == null ? 43 : this.peerTargetDatabaseKey.hashCode());
        result = result * 59 + (this.trailSource == null ? 43 : this.trailSource.hashCode());
        result = result * 59 + (this.databaseUniqueName == null ? 43 : this.databaseUniqueName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AuditType implements BmcEnum
    {
        Standard("STANDARD"),
        FineGrained("FINE_GRAINED"),
        Xs("XS"),
        DatabaseVault("DATABASE_VAULT"),
        LabelSecurity("LABEL_SECURITY"),
        Rman("RMAN"),
        Datapump("DATAPUMP"),
        DirectPathApi("DIRECT_PATH_API"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AuditType> map;

        private AuditType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuditType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AuditType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AuditType.class);
            map = new HashMap<String, AuditType>();
            for (AuditType v : AuditType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AuditLocation implements BmcEnum
    {
        AuditTable("AUDIT_TABLE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AuditLocation> map;

        private AuditLocation(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuditLocation create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AuditLocation', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AuditLocation.class);
            map = new HashMap<String, AuditLocation>();
            for (AuditLocation v : AuditLocation.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum OperationStatus implements BmcEnum
    {
        Success("SUCCESS"),
        Failure("FAILURE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, OperationStatus> map;

        private OperationStatus(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static OperationStatus create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'OperationStatus', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(OperationStatus.class);
            map = new HashMap<String, OperationStatus>();
            for (OperationStatus v : OperationStatus.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TargetClass implements BmcEnum
    {
        Database("DATABASE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TargetClass> map;

        private TargetClass(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetClass create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TargetClass', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TargetClass.class);
            map = new HashMap<String, TargetClass>();
            for (TargetClass v : TargetClass.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum DatabaseType implements BmcEnum
    {
        DatabaseCloudService("DATABASE_CLOUD_SERVICE"),
        AutonomousDatabase("AUTONOMOUS_DATABASE"),
        InstalledDatabase("INSTALLED_DATABASE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, DatabaseType> map;

        private DatabaseType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static DatabaseType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'DatabaseType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(DatabaseType.class);
            map = new HashMap<String, DatabaseType>();
            for (DatabaseType v : DatabaseType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbUserName")
        private String dbUserName;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="targetName")
        private String targetName;
        @JsonProperty(value="databaseType")
        private DatabaseType databaseType;
        @JsonProperty(value="targetClass")
        private TargetClass targetClass;
        @JsonProperty(value="auditEventTime")
        private Date auditEventTime;
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="osUserName")
        private String osUserName;
        @JsonProperty(value="operation")
        private String operation;
        @JsonProperty(value="operationStatus")
        private OperationStatus operationStatus;
        @JsonProperty(value="eventName")
        private String eventName;
        @JsonProperty(value="errorCode")
        private String errorCode;
        @JsonProperty(value="errorMessage")
        private String errorMessage;
        @JsonProperty(value="objectType")
        private String objectType;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="objectOwner")
        private String objectOwner;
        @JsonProperty(value="clientHostname")
        private String clientHostname;
        @JsonProperty(value="clientIp")
        private String clientIp;
        @JsonProperty(value="auditTrailId")
        private String auditTrailId;
        @JsonProperty(value="isAlerted")
        private Boolean isAlerted;
        @JsonProperty(value="actionTaken")
        private String actionTaken;
        @JsonProperty(value="clientProgram")
        private String clientProgram;
        @JsonProperty(value="commandText")
        private String commandText;
        @JsonProperty(value="commandParam")
        private String commandParam;
        @JsonProperty(value="extendedEventAttributes")
        private String extendedEventAttributes;
        @JsonProperty(value="auditLocation")
        private AuditLocation auditLocation;
        @JsonProperty(value="osTerminal")
        private String osTerminal;
        @JsonProperty(value="clientId")
        private String clientId;
        @JsonProperty(value="auditPolicies")
        private String auditPolicies;
        @JsonProperty(value="auditType")
        private AuditType auditType;
        @JsonProperty(value="peerTargetDatabaseKey")
        private Integer peerTargetDatabaseKey;
        @JsonProperty(value="trailSource")
        private AuditTrailSource trailSource;
        @JsonProperty(value="databaseUniqueName")
        private String databaseUniqueName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbUserName(String dbUserName) {
            this.dbUserName = dbUserName;
            this.__explicitlySet__.add("dbUserName");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetName(String targetName) {
            this.targetName = targetName;
            this.__explicitlySet__.add("targetName");
            return this;
        }

        public Builder databaseType(DatabaseType databaseType) {
            this.databaseType = databaseType;
            this.__explicitlySet__.add("databaseType");
            return this;
        }

        public Builder targetClass(TargetClass targetClass) {
            this.targetClass = targetClass;
            this.__explicitlySet__.add("targetClass");
            return this;
        }

        public Builder auditEventTime(Date auditEventTime) {
            this.auditEventTime = auditEventTime;
            this.__explicitlySet__.add("auditEventTime");
            return this;
        }

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder osUserName(String osUserName) {
            this.osUserName = osUserName;
            this.__explicitlySet__.add("osUserName");
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder operationStatus(OperationStatus operationStatus) {
            this.operationStatus = operationStatus;
            this.__explicitlySet__.add("operationStatus");
            return this;
        }

        public Builder eventName(String eventName) {
            this.eventName = eventName;
            this.__explicitlySet__.add("eventName");
            return this;
        }

        public Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            this.__explicitlySet__.add("errorCode");
            return this;
        }

        public Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            this.__explicitlySet__.add("errorMessage");
            return this;
        }

        public Builder objectType(String objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder objectOwner(String objectOwner) {
            this.objectOwner = objectOwner;
            this.__explicitlySet__.add("objectOwner");
            return this;
        }

        public Builder clientHostname(String clientHostname) {
            this.clientHostname = clientHostname;
            this.__explicitlySet__.add("clientHostname");
            return this;
        }

        public Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            this.__explicitlySet__.add("clientIp");
            return this;
        }

        public Builder auditTrailId(String auditTrailId) {
            this.auditTrailId = auditTrailId;
            this.__explicitlySet__.add("auditTrailId");
            return this;
        }

        public Builder isAlerted(Boolean isAlerted) {
            this.isAlerted = isAlerted;
            this.__explicitlySet__.add("isAlerted");
            return this;
        }

        public Builder actionTaken(String actionTaken) {
            this.actionTaken = actionTaken;
            this.__explicitlySet__.add("actionTaken");
            return this;
        }

        public Builder clientProgram(String clientProgram) {
            this.clientProgram = clientProgram;
            this.__explicitlySet__.add("clientProgram");
            return this;
        }

        public Builder commandText(String commandText) {
            this.commandText = commandText;
            this.__explicitlySet__.add("commandText");
            return this;
        }

        public Builder commandParam(String commandParam) {
            this.commandParam = commandParam;
            this.__explicitlySet__.add("commandParam");
            return this;
        }

        public Builder extendedEventAttributes(String extendedEventAttributes) {
            this.extendedEventAttributes = extendedEventAttributes;
            this.__explicitlySet__.add("extendedEventAttributes");
            return this;
        }

        public Builder auditLocation(AuditLocation auditLocation) {
            this.auditLocation = auditLocation;
            this.__explicitlySet__.add("auditLocation");
            return this;
        }

        public Builder osTerminal(String osTerminal) {
            this.osTerminal = osTerminal;
            this.__explicitlySet__.add("osTerminal");
            return this;
        }

        public Builder clientId(String clientId) {
            this.clientId = clientId;
            this.__explicitlySet__.add("clientId");
            return this;
        }

        public Builder auditPolicies(String auditPolicies) {
            this.auditPolicies = auditPolicies;
            this.__explicitlySet__.add("auditPolicies");
            return this;
        }

        public Builder auditType(AuditType auditType) {
            this.auditType = auditType;
            this.__explicitlySet__.add("auditType");
            return this;
        }

        public Builder peerTargetDatabaseKey(Integer peerTargetDatabaseKey) {
            this.peerTargetDatabaseKey = peerTargetDatabaseKey;
            this.__explicitlySet__.add("peerTargetDatabaseKey");
            return this;
        }

        public Builder trailSource(AuditTrailSource trailSource) {
            this.trailSource = trailSource;
            this.__explicitlySet__.add("trailSource");
            return this;
        }

        public Builder databaseUniqueName(String databaseUniqueName) {
            this.databaseUniqueName = databaseUniqueName;
            this.__explicitlySet__.add("databaseUniqueName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public AuditEventSummary build() {
            AuditEventSummary model = new AuditEventSummary(this.id, this.compartmentId, this.dbUserName, this.targetId, this.targetName, this.databaseType, this.targetClass, this.auditEventTime, this.timeCollected, this.osUserName, this.operation, this.operationStatus, this.eventName, this.errorCode, this.errorMessage, this.objectType, this.objectName, this.objectOwner, this.clientHostname, this.clientIp, this.auditTrailId, this.isAlerted, this.actionTaken, this.clientProgram, this.commandText, this.commandParam, this.extendedEventAttributes, this.auditLocation, this.osTerminal, this.clientId, this.auditPolicies, this.auditType, this.peerTargetDatabaseKey, this.trailSource, this.databaseUniqueName, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuditEventSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbUserName")) {
                this.dbUserName(model.getDbUserName());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetName")) {
                this.targetName(model.getTargetName());
            }
            if (model.wasPropertyExplicitlySet("databaseType")) {
                this.databaseType(model.getDatabaseType());
            }
            if (model.wasPropertyExplicitlySet("targetClass")) {
                this.targetClass(model.getTargetClass());
            }
            if (model.wasPropertyExplicitlySet("auditEventTime")) {
                this.auditEventTime(model.getAuditEventTime());
            }
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("osUserName")) {
                this.osUserName(model.getOsUserName());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("operationStatus")) {
                this.operationStatus(model.getOperationStatus());
            }
            if (model.wasPropertyExplicitlySet("eventName")) {
                this.eventName(model.getEventName());
            }
            if (model.wasPropertyExplicitlySet("errorCode")) {
                this.errorCode(model.getErrorCode());
            }
            if (model.wasPropertyExplicitlySet("errorMessage")) {
                this.errorMessage(model.getErrorMessage());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("objectOwner")) {
                this.objectOwner(model.getObjectOwner());
            }
            if (model.wasPropertyExplicitlySet("clientHostname")) {
                this.clientHostname(model.getClientHostname());
            }
            if (model.wasPropertyExplicitlySet("clientIp")) {
                this.clientIp(model.getClientIp());
            }
            if (model.wasPropertyExplicitlySet("auditTrailId")) {
                this.auditTrailId(model.getAuditTrailId());
            }
            if (model.wasPropertyExplicitlySet("isAlerted")) {
                this.isAlerted(model.getIsAlerted());
            }
            if (model.wasPropertyExplicitlySet("actionTaken")) {
                this.actionTaken(model.getActionTaken());
            }
            if (model.wasPropertyExplicitlySet("clientProgram")) {
                this.clientProgram(model.getClientProgram());
            }
            if (model.wasPropertyExplicitlySet("commandText")) {
                this.commandText(model.getCommandText());
            }
            if (model.wasPropertyExplicitlySet("commandParam")) {
                this.commandParam(model.getCommandParam());
            }
            if (model.wasPropertyExplicitlySet("extendedEventAttributes")) {
                this.extendedEventAttributes(model.getExtendedEventAttributes());
            }
            if (model.wasPropertyExplicitlySet("auditLocation")) {
                this.auditLocation(model.getAuditLocation());
            }
            if (model.wasPropertyExplicitlySet("osTerminal")) {
                this.osTerminal(model.getOsTerminal());
            }
            if (model.wasPropertyExplicitlySet("clientId")) {
                this.clientId(model.getClientId());
            }
            if (model.wasPropertyExplicitlySet("auditPolicies")) {
                this.auditPolicies(model.getAuditPolicies());
            }
            if (model.wasPropertyExplicitlySet("auditType")) {
                this.auditType(model.getAuditType());
            }
            if (model.wasPropertyExplicitlySet("peerTargetDatabaseKey")) {
                this.peerTargetDatabaseKey(model.getPeerTargetDatabaseKey());
            }
            if (model.wasPropertyExplicitlySet("trailSource")) {
                this.trailSource(model.getTrailSource());
            }
            if (model.wasPropertyExplicitlySet("databaseUniqueName")) {
                this.databaseUniqueName(model.getDatabaseUniqueName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

