/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateSensitiveColumnDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="appName")
    private final String appName;
    @JsonProperty(value="schemaName")
    private final String schemaName;
    @JsonProperty(value="objectName")
    private final String objectName;
    @JsonProperty(value="columnName")
    private final String columnName;
    @JsonProperty(value="objectType")
    private final ObjectType objectType;
    @JsonProperty(value="dataType")
    private final String dataType;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="sensitiveTypeId")
    private final String sensitiveTypeId;
    @JsonProperty(value="parentColumnKeys")
    private final List<String> parentColumnKeys;
    @JsonProperty(value="relationType")
    private final RelationType relationType;
    @JsonProperty(value="appDefinedChildColumnKeys")
    private final List<String> appDefinedChildColumnKeys;
    @JsonProperty(value="dbDefinedChildColumnKeys")
    private final List<String> dbDefinedChildColumnKeys;

    @Deprecated
    @ConstructorProperties(value={"appName", "schemaName", "objectName", "columnName", "objectType", "dataType", "status", "sensitiveTypeId", "parentColumnKeys", "relationType", "appDefinedChildColumnKeys", "dbDefinedChildColumnKeys"})
    public CreateSensitiveColumnDetails(String appName, String schemaName, String objectName, String columnName, ObjectType objectType, String dataType, Status status, String sensitiveTypeId, List<String> parentColumnKeys, RelationType relationType, List<String> appDefinedChildColumnKeys, List<String> dbDefinedChildColumnKeys) {
        this.appName = appName;
        this.schemaName = schemaName;
        this.objectName = objectName;
        this.columnName = columnName;
        this.objectType = objectType;
        this.dataType = dataType;
        this.status = status;
        this.sensitiveTypeId = sensitiveTypeId;
        this.parentColumnKeys = parentColumnKeys;
        this.relationType = relationType;
        this.appDefinedChildColumnKeys = appDefinedChildColumnKeys;
        this.dbDefinedChildColumnKeys = dbDefinedChildColumnKeys;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAppName() {
        return this.appName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public ObjectType getObjectType() {
        return this.objectType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getSensitiveTypeId() {
        return this.sensitiveTypeId;
    }

    public List<String> getParentColumnKeys() {
        return this.parentColumnKeys;
    }

    public RelationType getRelationType() {
        return this.relationType;
    }

    public List<String> getAppDefinedChildColumnKeys() {
        return this.appDefinedChildColumnKeys;
    }

    public List<String> getDbDefinedChildColumnKeys() {
        return this.dbDefinedChildColumnKeys;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateSensitiveColumnDetails(");
        sb.append("super=").append(super.toString());
        sb.append("appName=").append(String.valueOf(this.appName));
        sb.append(", schemaName=").append(String.valueOf(this.schemaName));
        sb.append(", objectName=").append(String.valueOf(this.objectName));
        sb.append(", columnName=").append(String.valueOf(this.columnName));
        sb.append(", objectType=").append(String.valueOf((Object)this.objectType));
        sb.append(", dataType=").append(String.valueOf(this.dataType));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", sensitiveTypeId=").append(String.valueOf(this.sensitiveTypeId));
        sb.append(", parentColumnKeys=").append(String.valueOf(this.parentColumnKeys));
        sb.append(", relationType=").append(String.valueOf((Object)this.relationType));
        sb.append(", appDefinedChildColumnKeys=").append(String.valueOf(this.appDefinedChildColumnKeys));
        sb.append(", dbDefinedChildColumnKeys=").append(String.valueOf(this.dbDefinedChildColumnKeys));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateSensitiveColumnDetails)) {
            return false;
        }
        CreateSensitiveColumnDetails other = (CreateSensitiveColumnDetails)((Object)o);
        return Objects.equals(this.appName, other.appName) && Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.objectName, other.objectName) && Objects.equals(this.columnName, other.columnName) && Objects.equals((Object)this.objectType, (Object)other.objectType) && Objects.equals(this.dataType, other.dataType) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.sensitiveTypeId, other.sensitiveTypeId) && Objects.equals(this.parentColumnKeys, other.parentColumnKeys) && Objects.equals((Object)this.relationType, (Object)other.relationType) && Objects.equals(this.appDefinedChildColumnKeys, other.appDefinedChildColumnKeys) && Objects.equals(this.dbDefinedChildColumnKeys, other.dbDefinedChildColumnKeys) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.appName == null ? 43 : this.appName.hashCode());
        result = result * 59 + (this.schemaName == null ? 43 : this.schemaName.hashCode());
        result = result * 59 + (this.objectName == null ? 43 : this.objectName.hashCode());
        result = result * 59 + (this.columnName == null ? 43 : this.columnName.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.dataType == null ? 43 : this.dataType.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.sensitiveTypeId == null ? 43 : this.sensitiveTypeId.hashCode());
        result = result * 59 + (this.parentColumnKeys == null ? 43 : this.parentColumnKeys.hashCode());
        result = result * 59 + (this.relationType == null ? 43 : this.relationType.hashCode());
        result = result * 59 + (this.appDefinedChildColumnKeys == null ? 43 : this.appDefinedChildColumnKeys.hashCode());
        result = result * 59 + (this.dbDefinedChildColumnKeys == null ? 43 : this.dbDefinedChildColumnKeys.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum RelationType implements BmcEnum
    {
        None("NONE"),
        AppDefined("APP_DEFINED"),
        DbDefined("DB_DEFINED");

        private final String value;
        private static Map<String, RelationType> map;

        private RelationType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static RelationType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid RelationType: " + key);
        }

        static {
            map = new HashMap<String, RelationType>();
            for (RelationType v : RelationType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Valid("VALID"),
        Invalid("INVALID");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ObjectType implements BmcEnum
    {
        Table("TABLE"),
        EditioningView("EDITIONING_VIEW");

        private final String value;
        private static Map<String, ObjectType> map;

        private ObjectType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ObjectType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ObjectType: " + key);
        }

        static {
            map = new HashMap<String, ObjectType>();
            for (ObjectType v : ObjectType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="appName")
        private String appName;
        @JsonProperty(value="schemaName")
        private String schemaName;
        @JsonProperty(value="objectName")
        private String objectName;
        @JsonProperty(value="columnName")
        private String columnName;
        @JsonProperty(value="objectType")
        private ObjectType objectType;
        @JsonProperty(value="dataType")
        private String dataType;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="sensitiveTypeId")
        private String sensitiveTypeId;
        @JsonProperty(value="parentColumnKeys")
        private List<String> parentColumnKeys;
        @JsonProperty(value="relationType")
        private RelationType relationType;
        @JsonProperty(value="appDefinedChildColumnKeys")
        private List<String> appDefinedChildColumnKeys;
        @JsonProperty(value="dbDefinedChildColumnKeys")
        private List<String> dbDefinedChildColumnKeys;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder appName(String appName) {
            this.appName = appName;
            this.__explicitlySet__.add("appName");
            return this;
        }

        public Builder schemaName(String schemaName) {
            this.schemaName = schemaName;
            this.__explicitlySet__.add("schemaName");
            return this;
        }

        public Builder objectName(String objectName) {
            this.objectName = objectName;
            this.__explicitlySet__.add("objectName");
            return this;
        }

        public Builder columnName(String columnName) {
            this.columnName = columnName;
            this.__explicitlySet__.add("columnName");
            return this;
        }

        public Builder objectType(ObjectType objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder dataType(String dataType) {
            this.dataType = dataType;
            this.__explicitlySet__.add("dataType");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder sensitiveTypeId(String sensitiveTypeId) {
            this.sensitiveTypeId = sensitiveTypeId;
            this.__explicitlySet__.add("sensitiveTypeId");
            return this;
        }

        public Builder parentColumnKeys(List<String> parentColumnKeys) {
            this.parentColumnKeys = parentColumnKeys;
            this.__explicitlySet__.add("parentColumnKeys");
            return this;
        }

        public Builder relationType(RelationType relationType) {
            this.relationType = relationType;
            this.__explicitlySet__.add("relationType");
            return this;
        }

        public Builder appDefinedChildColumnKeys(List<String> appDefinedChildColumnKeys) {
            this.appDefinedChildColumnKeys = appDefinedChildColumnKeys;
            this.__explicitlySet__.add("appDefinedChildColumnKeys");
            return this;
        }

        public Builder dbDefinedChildColumnKeys(List<String> dbDefinedChildColumnKeys) {
            this.dbDefinedChildColumnKeys = dbDefinedChildColumnKeys;
            this.__explicitlySet__.add("dbDefinedChildColumnKeys");
            return this;
        }

        public CreateSensitiveColumnDetails build() {
            CreateSensitiveColumnDetails model = new CreateSensitiveColumnDetails(this.appName, this.schemaName, this.objectName, this.columnName, this.objectType, this.dataType, this.status, this.sensitiveTypeId, this.parentColumnKeys, this.relationType, this.appDefinedChildColumnKeys, this.dbDefinedChildColumnKeys);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateSensitiveColumnDetails model) {
            if (model.wasPropertyExplicitlySet("appName")) {
                this.appName(model.getAppName());
            }
            if (model.wasPropertyExplicitlySet("schemaName")) {
                this.schemaName(model.getSchemaName());
            }
            if (model.wasPropertyExplicitlySet("objectName")) {
                this.objectName(model.getObjectName());
            }
            if (model.wasPropertyExplicitlySet("columnName")) {
                this.columnName(model.getColumnName());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("dataType")) {
                this.dataType(model.getDataType());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("sensitiveTypeId")) {
                this.sensitiveTypeId(model.getSensitiveTypeId());
            }
            if (model.wasPropertyExplicitlySet("parentColumnKeys")) {
                this.parentColumnKeys(model.getParentColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("relationType")) {
                this.relationType(model.getRelationType());
            }
            if (model.wasPropertyExplicitlySet("appDefinedChildColumnKeys")) {
                this.appDefinedChildColumnKeys(model.getAppDefinedChildColumnKeys());
            }
            if (model.wasPropertyExplicitlySet("dbDefinedChildColumnKeys")) {
                this.dbDefinedChildColumnKeys(model.getDbDefinedChildColumnKeys());
            }
            return this;
        }
    }
}

