/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class GenerateHealthReportDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="checkType")
    private final CheckType checkType;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="tablespace")
    private final String tablespace;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"checkType", "targetId", "compartmentId", "tablespace", "freeformTags", "definedTags"})
    public GenerateHealthReportDetails(CheckType checkType, String targetId, String compartmentId, String tablespace, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.checkType = checkType;
        this.targetId = targetId;
        this.compartmentId = compartmentId;
        this.tablespace = tablespace;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public CheckType getCheckType() {
        return this.checkType;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTablespace() {
        return this.tablespace;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("GenerateHealthReportDetails(");
        sb.append("super=").append(super.toString());
        sb.append("checkType=").append(String.valueOf((Object)this.checkType));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", tablespace=").append(String.valueOf(this.tablespace));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateHealthReportDetails)) {
            return false;
        }
        GenerateHealthReportDetails other = (GenerateHealthReportDetails)((Object)o);
        return Objects.equals((Object)this.checkType, (Object)other.checkType) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.tablespace, other.tablespace) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.checkType == null ? 43 : this.checkType.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.tablespace == null ? 43 : this.tablespace.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum CheckType implements BmcEnum
    {
        All("ALL");

        private final String value;
        private static Map<String, CheckType> map;

        private CheckType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static CheckType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid CheckType: " + key);
        }

        static {
            map = new HashMap<String, CheckType>();
            for (CheckType v : CheckType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="checkType")
        private CheckType checkType;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="tablespace")
        private String tablespace;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder checkType(CheckType checkType) {
            this.checkType = checkType;
            this.__explicitlySet__.add("checkType");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder tablespace(String tablespace) {
            this.tablespace = tablespace;
            this.__explicitlySet__.add("tablespace");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public GenerateHealthReportDetails build() {
            GenerateHealthReportDetails model = new GenerateHealthReportDetails(this.checkType, this.targetId, this.compartmentId, this.tablespace, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(GenerateHealthReportDetails model) {
            if (model.wasPropertyExplicitlySet("checkType")) {
                this.checkType(model.getCheckType());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("tablespace")) {
                this.tablespace(model.getTablespace());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

