/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.MaskingAnalyticsDimensions;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaskingAnalyticsSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="metricName")
    private final MetricName metricName;
    @JsonProperty(value="dimensions")
    private final MaskingAnalyticsDimensions dimensions;
    @JsonProperty(value="count")
    private final Long count;

    @Deprecated
    @ConstructorProperties(value={"metricName", "dimensions", "count"})
    public MaskingAnalyticsSummary(MetricName metricName, MaskingAnalyticsDimensions dimensions, Long count) {
        this.metricName = metricName;
        this.dimensions = dimensions;
        this.count = count;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MetricName getMetricName() {
        return this.metricName;
    }

    public MaskingAnalyticsDimensions getDimensions() {
        return this.dimensions;
    }

    public Long getCount() {
        return this.count;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaskingAnalyticsSummary(");
        sb.append("super=").append(super.toString());
        sb.append("metricName=").append(String.valueOf((Object)this.metricName));
        sb.append(", dimensions=").append(String.valueOf((Object)this.dimensions));
        sb.append(", count=").append(String.valueOf(this.count));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskingAnalyticsSummary)) {
            return false;
        }
        MaskingAnalyticsSummary other = (MaskingAnalyticsSummary)((Object)o);
        return Objects.equals((Object)this.metricName, (Object)other.metricName) && Objects.equals((Object)this.dimensions, (Object)other.dimensions) && Objects.equals(this.count, other.count) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.metricName == null ? 43 : this.metricName.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.count == null ? 43 : this.count.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MetricName implements BmcEnum
    {
        MaskingPolicy("MASKING_POLICY"),
        MaskingDatabase("MASKING_DATABASE"),
        MaskingWorkRequest("MASKING_WORK_REQUEST"),
        MaskedSensitiveType("MASKED_SENSITIVE_TYPE"),
        MaskedSchema("MASKED_SCHEMA"),
        MaskedTable("MASKED_TABLE"),
        MaskedColumn("MASKED_COLUMN"),
        MaskedDataValue("MASKED_DATA_VALUE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MetricName> map;

        private MetricName(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MetricName create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MetricName', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MetricName.class);
            map = new HashMap<String, MetricName>();
            for (MetricName v : MetricName.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="metricName")
        private MetricName metricName;
        @JsonProperty(value="dimensions")
        private MaskingAnalyticsDimensions dimensions;
        @JsonProperty(value="count")
        private Long count;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder metricName(MetricName metricName) {
            this.metricName = metricName;
            this.__explicitlySet__.add("metricName");
            return this;
        }

        public Builder dimensions(MaskingAnalyticsDimensions dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder count(Long count) {
            this.count = count;
            this.__explicitlySet__.add("count");
            return this;
        }

        public MaskingAnalyticsSummary build() {
            MaskingAnalyticsSummary model = new MaskingAnalyticsSummary(this.metricName, this.dimensions, this.count);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaskingAnalyticsSummary model) {
            if (model.wasPropertyExplicitlySet("metricName")) {
                this.metricName(model.getMetricName());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("count")) {
                this.count(model.getCount());
            }
            return this;
        }
    }
}

