/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class MaskingPolicyHealthReportLogSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="messageType")
    private final MessageType messageType;
    @JsonProperty(value="timestamp")
    private final Date timestamp;
    @JsonProperty(value="message")
    private final String message;
    @JsonProperty(value="remediation")
    private final String remediation;
    @JsonProperty(value="description")
    private final String description;

    @Deprecated
    @ConstructorProperties(value={"messageType", "timestamp", "message", "remediation", "description"})
    public MaskingPolicyHealthReportLogSummary(MessageType messageType, Date timestamp, String message, String remediation, String description) {
        this.messageType = messageType;
        this.timestamp = timestamp;
        this.message = message;
        this.remediation = remediation;
        this.description = description;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRemediation() {
        return this.remediation;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("MaskingPolicyHealthReportLogSummary(");
        sb.append("super=").append(super.toString());
        sb.append("messageType=").append(String.valueOf((Object)this.messageType));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(", message=").append(String.valueOf(this.message));
        sb.append(", remediation=").append(String.valueOf(this.remediation));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MaskingPolicyHealthReportLogSummary)) {
            return false;
        }
        MaskingPolicyHealthReportLogSummary other = (MaskingPolicyHealthReportLogSummary)((Object)o);
        return Objects.equals((Object)this.messageType, (Object)other.messageType) && Objects.equals(this.timestamp, other.timestamp) && Objects.equals(this.message, other.message) && Objects.equals(this.remediation, other.remediation) && Objects.equals(this.description, other.description) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.messageType == null ? 43 : this.messageType.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + (this.message == null ? 43 : this.message.hashCode());
        result = result * 59 + (this.remediation == null ? 43 : this.remediation.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum MessageType implements BmcEnum
    {
        Pass("PASS"),
        Warning("WARNING"),
        Error("ERROR"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, MessageType> map;

        private MessageType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static MessageType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'MessageType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(MessageType.class);
            map = new HashMap<String, MessageType>();
            for (MessageType v : MessageType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="messageType")
        private MessageType messageType;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonProperty(value="message")
        private String message;
        @JsonProperty(value="remediation")
        private String remediation;
        @JsonProperty(value="description")
        private String description;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder messageType(MessageType messageType) {
            this.messageType = messageType;
            this.__explicitlySet__.add("messageType");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.__explicitlySet__.add("message");
            return this;
        }

        public Builder remediation(String remediation) {
            this.remediation = remediation;
            this.__explicitlySet__.add("remediation");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public MaskingPolicyHealthReportLogSummary build() {
            MaskingPolicyHealthReportLogSummary model = new MaskingPolicyHealthReportLogSummary(this.messageType, this.timestamp, this.message, this.remediation, this.description);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(MaskingPolicyHealthReportLogSummary model) {
            if (model.wasPropertyExplicitlySet("messageType")) {
                this.messageType(model.getMessageType());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            if (model.wasPropertyExplicitlySet("message")) {
                this.message(model.getMessage());
            }
            if (model.wasPropertyExplicitlySet("remediation")) {
                this.remediation(model.getRemediation());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            return this;
        }
    }
}

