/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ProfileSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="userAssessmentId")
    private final String userAssessmentId;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="profileName")
    private final String profileName;
    @JsonProperty(value="userCount")
    private final Integer userCount;
    @JsonProperty(value="failedLoginAttempts")
    private final String failedLoginAttempts;
    @JsonProperty(value="passwordVerificationFunction")
    private final String passwordVerificationFunction;
    @JsonProperty(value="sessionsPerUser")
    private final String sessionsPerUser;
    @JsonProperty(value="inactiveAccountTime")
    private final String inactiveAccountTime;
    @JsonProperty(value="passwordLockTime")
    private final String passwordLockTime;
    @JsonProperty(value="isUserCreated")
    private final Boolean isUserCreated;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"userAssessmentId", "compartmentId", "targetId", "profileName", "userCount", "failedLoginAttempts", "passwordVerificationFunction", "sessionsPerUser", "inactiveAccountTime", "passwordLockTime", "isUserCreated", "freeformTags", "definedTags"})
    public ProfileSummary(String userAssessmentId, String compartmentId, String targetId, String profileName, Integer userCount, String failedLoginAttempts, String passwordVerificationFunction, String sessionsPerUser, String inactiveAccountTime, String passwordLockTime, Boolean isUserCreated, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.userAssessmentId = userAssessmentId;
        this.compartmentId = compartmentId;
        this.targetId = targetId;
        this.profileName = profileName;
        this.userCount = userCount;
        this.failedLoginAttempts = failedLoginAttempts;
        this.passwordVerificationFunction = passwordVerificationFunction;
        this.sessionsPerUser = sessionsPerUser;
        this.inactiveAccountTime = inactiveAccountTime;
        this.passwordLockTime = passwordLockTime;
        this.isUserCreated = isUserCreated;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getUserAssessmentId() {
        return this.userAssessmentId;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public Integer getUserCount() {
        return this.userCount;
    }

    public String getFailedLoginAttempts() {
        return this.failedLoginAttempts;
    }

    public String getPasswordVerificationFunction() {
        return this.passwordVerificationFunction;
    }

    public String getSessionsPerUser() {
        return this.sessionsPerUser;
    }

    public String getInactiveAccountTime() {
        return this.inactiveAccountTime;
    }

    public String getPasswordLockTime() {
        return this.passwordLockTime;
    }

    public Boolean getIsUserCreated() {
        return this.isUserCreated;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ProfileSummary(");
        sb.append("super=").append(super.toString());
        sb.append("userAssessmentId=").append(String.valueOf(this.userAssessmentId));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", profileName=").append(String.valueOf(this.profileName));
        sb.append(", userCount=").append(String.valueOf(this.userCount));
        sb.append(", failedLoginAttempts=").append(String.valueOf(this.failedLoginAttempts));
        sb.append(", passwordVerificationFunction=").append(String.valueOf(this.passwordVerificationFunction));
        sb.append(", sessionsPerUser=").append(String.valueOf(this.sessionsPerUser));
        sb.append(", inactiveAccountTime=").append(String.valueOf(this.inactiveAccountTime));
        sb.append(", passwordLockTime=").append(String.valueOf(this.passwordLockTime));
        sb.append(", isUserCreated=").append(String.valueOf(this.isUserCreated));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileSummary)) {
            return false;
        }
        ProfileSummary other = (ProfileSummary)((Object)o);
        return Objects.equals(this.userAssessmentId, other.userAssessmentId) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.profileName, other.profileName) && Objects.equals(this.userCount, other.userCount) && Objects.equals(this.failedLoginAttempts, other.failedLoginAttempts) && Objects.equals(this.passwordVerificationFunction, other.passwordVerificationFunction) && Objects.equals(this.sessionsPerUser, other.sessionsPerUser) && Objects.equals(this.inactiveAccountTime, other.inactiveAccountTime) && Objects.equals(this.passwordLockTime, other.passwordLockTime) && Objects.equals(this.isUserCreated, other.isUserCreated) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.userAssessmentId == null ? 43 : this.userAssessmentId.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.profileName == null ? 43 : this.profileName.hashCode());
        result = result * 59 + (this.userCount == null ? 43 : this.userCount.hashCode());
        result = result * 59 + (this.failedLoginAttempts == null ? 43 : this.failedLoginAttempts.hashCode());
        result = result * 59 + (this.passwordVerificationFunction == null ? 43 : this.passwordVerificationFunction.hashCode());
        result = result * 59 + (this.sessionsPerUser == null ? 43 : this.sessionsPerUser.hashCode());
        result = result * 59 + (this.inactiveAccountTime == null ? 43 : this.inactiveAccountTime.hashCode());
        result = result * 59 + (this.passwordLockTime == null ? 43 : this.passwordLockTime.hashCode());
        result = result * 59 + (this.isUserCreated == null ? 43 : this.isUserCreated.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="userAssessmentId")
        private String userAssessmentId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="profileName")
        private String profileName;
        @JsonProperty(value="userCount")
        private Integer userCount;
        @JsonProperty(value="failedLoginAttempts")
        private String failedLoginAttempts;
        @JsonProperty(value="passwordVerificationFunction")
        private String passwordVerificationFunction;
        @JsonProperty(value="sessionsPerUser")
        private String sessionsPerUser;
        @JsonProperty(value="inactiveAccountTime")
        private String inactiveAccountTime;
        @JsonProperty(value="passwordLockTime")
        private String passwordLockTime;
        @JsonProperty(value="isUserCreated")
        private Boolean isUserCreated;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder userAssessmentId(String userAssessmentId) {
            this.userAssessmentId = userAssessmentId;
            this.__explicitlySet__.add("userAssessmentId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder profileName(String profileName) {
            this.profileName = profileName;
            this.__explicitlySet__.add("profileName");
            return this;
        }

        public Builder userCount(Integer userCount) {
            this.userCount = userCount;
            this.__explicitlySet__.add("userCount");
            return this;
        }

        public Builder failedLoginAttempts(String failedLoginAttempts) {
            this.failedLoginAttempts = failedLoginAttempts;
            this.__explicitlySet__.add("failedLoginAttempts");
            return this;
        }

        public Builder passwordVerificationFunction(String passwordVerificationFunction) {
            this.passwordVerificationFunction = passwordVerificationFunction;
            this.__explicitlySet__.add("passwordVerificationFunction");
            return this;
        }

        public Builder sessionsPerUser(String sessionsPerUser) {
            this.sessionsPerUser = sessionsPerUser;
            this.__explicitlySet__.add("sessionsPerUser");
            return this;
        }

        public Builder inactiveAccountTime(String inactiveAccountTime) {
            this.inactiveAccountTime = inactiveAccountTime;
            this.__explicitlySet__.add("inactiveAccountTime");
            return this;
        }

        public Builder passwordLockTime(String passwordLockTime) {
            this.passwordLockTime = passwordLockTime;
            this.__explicitlySet__.add("passwordLockTime");
            return this;
        }

        public Builder isUserCreated(Boolean isUserCreated) {
            this.isUserCreated = isUserCreated;
            this.__explicitlySet__.add("isUserCreated");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public ProfileSummary build() {
            ProfileSummary model = new ProfileSummary(this.userAssessmentId, this.compartmentId, this.targetId, this.profileName, this.userCount, this.failedLoginAttempts, this.passwordVerificationFunction, this.sessionsPerUser, this.inactiveAccountTime, this.passwordLockTime, this.isUserCreated, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ProfileSummary model) {
            if (model.wasPropertyExplicitlySet("userAssessmentId")) {
                this.userAssessmentId(model.getUserAssessmentId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("profileName")) {
                this.profileName(model.getProfileName());
            }
            if (model.wasPropertyExplicitlySet("userCount")) {
                this.userCount(model.getUserCount());
            }
            if (model.wasPropertyExplicitlySet("failedLoginAttempts")) {
                this.failedLoginAttempts(model.getFailedLoginAttempts());
            }
            if (model.wasPropertyExplicitlySet("passwordVerificationFunction")) {
                this.passwordVerificationFunction(model.getPasswordVerificationFunction());
            }
            if (model.wasPropertyExplicitlySet("sessionsPerUser")) {
                this.sessionsPerUser(model.getSessionsPerUser());
            }
            if (model.wasPropertyExplicitlySet("inactiveAccountTime")) {
                this.inactiveAccountTime(model.getInactiveAccountTime());
            }
            if (model.wasPropertyExplicitlySet("passwordLockTime")) {
                this.passwordLockTime(model.getPasswordLockTime());
            }
            if (model.wasPropertyExplicitlySet("isUserCreated")) {
                this.isUserCreated(model.getIsUserCreated());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

