/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class RandomDecimalNumberFormatEntry
extends FormatEntry {
    @JsonProperty(value="startValue")
    private final Double startValue;
    @JsonProperty(value="endValue")
    private final Double endValue;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RandomDecimalNumberFormatEntry(String description, Double startValue, Double endValue) {
        super(description);
        this.startValue = startValue;
        this.endValue = endValue;
    }

    public Double getStartValue() {
        return this.startValue;
    }

    public Double getEndValue() {
        return this.endValue;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RandomDecimalNumberFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", startValue=").append(String.valueOf(this.startValue));
        sb.append(", endValue=").append(String.valueOf(this.endValue));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RandomDecimalNumberFormatEntry)) {
            return false;
        }
        RandomDecimalNumberFormatEntry other = (RandomDecimalNumberFormatEntry)((Object)o);
        return Objects.equals(this.startValue, other.startValue) && Objects.equals(this.endValue, other.endValue) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.startValue == null ? 43 : this.startValue.hashCode());
        result = result * 59 + (this.endValue == null ? 43 : this.endValue.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="startValue")
        private Double startValue;
        @JsonProperty(value="endValue")
        private Double endValue;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder startValue(Double startValue) {
            this.startValue = startValue;
            this.__explicitlySet__.add("startValue");
            return this;
        }

        public Builder endValue(Double endValue) {
            this.endValue = endValue;
            this.__explicitlySet__.add("endValue");
            return this;
        }

        public RandomDecimalNumberFormatEntry build() {
            RandomDecimalNumberFormatEntry model = new RandomDecimalNumberFormatEntry(this.description, this.startValue, this.endValue);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RandomDecimalNumberFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("startValue")) {
                this.startValue(model.getStartValue());
            }
            if (model.wasPropertyExplicitlySet("endValue")) {
                this.endValue(model.getEndValue());
            }
            return this;
        }
    }
}

