/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class RegularExpressionFormatEntry
extends FormatEntry {
    @JsonProperty(value="regularExpression")
    private final String regularExpression;
    @JsonProperty(value="replaceWith")
    private final String replaceWith;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public RegularExpressionFormatEntry(String description, String regularExpression, String replaceWith) {
        super(description);
        this.regularExpression = regularExpression;
        this.replaceWith = replaceWith;
    }

    public String getRegularExpression() {
        return this.regularExpression;
    }

    public String getReplaceWith() {
        return this.replaceWith;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RegularExpressionFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", regularExpression=").append(String.valueOf(this.regularExpression));
        sb.append(", replaceWith=").append(String.valueOf(this.replaceWith));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RegularExpressionFormatEntry)) {
            return false;
        }
        RegularExpressionFormatEntry other = (RegularExpressionFormatEntry)((Object)o);
        return Objects.equals(this.regularExpression, other.regularExpression) && Objects.equals(this.replaceWith, other.replaceWith) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.regularExpression == null ? 43 : this.regularExpression.hashCode());
        result = result * 59 + (this.replaceWith == null ? 43 : this.replaceWith.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="regularExpression")
        private String regularExpression;
        @JsonProperty(value="replaceWith")
        private String replaceWith;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder regularExpression(String regularExpression) {
            this.regularExpression = regularExpression;
            this.__explicitlySet__.add("regularExpression");
            return this;
        }

        public Builder replaceWith(String replaceWith) {
            this.replaceWith = replaceWith;
            this.__explicitlySet__.add("replaceWith");
            return this;
        }

        public RegularExpressionFormatEntry build() {
            RegularExpressionFormatEntry model = new RegularExpressionFormatEntry(this.description, this.regularExpression, this.replaceWith);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RegularExpressionFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("regularExpression")) {
                this.regularExpression(model.getRegularExpression());
            }
            if (model.wasPropertyExplicitlySet("replaceWith")) {
                this.replaceWith(model.getReplaceWith());
            }
            return this;
        }
    }
}

