/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class RoleGrantPathSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="key")
    private final String key;
    @JsonProperty(value="grantee")
    private final String grantee;
    @JsonProperty(value="grantedRole")
    private final String grantedRole;
    @JsonProperty(value="depthLevel")
    private final Integer depthLevel;

    @Deprecated
    @ConstructorProperties(value={"key", "grantee", "grantedRole", "depthLevel"})
    public RoleGrantPathSummary(String key, String grantee, String grantedRole, Integer depthLevel) {
        this.key = key;
        this.grantee = grantee;
        this.grantedRole = grantedRole;
        this.depthLevel = depthLevel;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getGrantedRole() {
        return this.grantedRole;
    }

    public Integer getDepthLevel() {
        return this.depthLevel;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("RoleGrantPathSummary(");
        sb.append("super=").append(super.toString());
        sb.append("key=").append(String.valueOf(this.key));
        sb.append(", grantee=").append(String.valueOf(this.grantee));
        sb.append(", grantedRole=").append(String.valueOf(this.grantedRole));
        sb.append(", depthLevel=").append(String.valueOf(this.depthLevel));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof RoleGrantPathSummary)) {
            return false;
        }
        RoleGrantPathSummary other = (RoleGrantPathSummary)((Object)o);
        return Objects.equals(this.key, other.key) && Objects.equals(this.grantee, other.grantee) && Objects.equals(this.grantedRole, other.grantedRole) && Objects.equals(this.depthLevel, other.depthLevel) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.key == null ? 43 : this.key.hashCode());
        result = result * 59 + (this.grantee == null ? 43 : this.grantee.hashCode());
        result = result * 59 + (this.grantedRole == null ? 43 : this.grantedRole.hashCode());
        result = result * 59 + (this.depthLevel == null ? 43 : this.depthLevel.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="key")
        private String key;
        @JsonProperty(value="grantee")
        private String grantee;
        @JsonProperty(value="grantedRole")
        private String grantedRole;
        @JsonProperty(value="depthLevel")
        private Integer depthLevel;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder key(String key) {
            this.key = key;
            this.__explicitlySet__.add("key");
            return this;
        }

        public Builder grantee(String grantee) {
            this.grantee = grantee;
            this.__explicitlySet__.add("grantee");
            return this;
        }

        public Builder grantedRole(String grantedRole) {
            this.grantedRole = grantedRole;
            this.__explicitlySet__.add("grantedRole");
            return this;
        }

        public Builder depthLevel(Integer depthLevel) {
            this.depthLevel = depthLevel;
            this.__explicitlySet__.add("depthLevel");
            return this;
        }

        public RoleGrantPathSummary build() {
            RoleGrantPathSummary model = new RoleGrantPathSummary(this.key, this.grantee, this.grantedRole, this.depthLevel);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(RoleGrantPathSummary model) {
            if (model.wasPropertyExplicitlySet("key")) {
                this.key(model.getKey());
            }
            if (model.wasPropertyExplicitlySet("grantee")) {
                this.grantee(model.getGrantee());
            }
            if (model.wasPropertyExplicitlySet("grantedRole")) {
                this.grantedRole(model.getGrantedRole());
            }
            if (model.wasPropertyExplicitlySet("depthLevel")) {
                this.depthLevel(model.getDepthLevel());
            }
            return this;
        }
    }
}

