/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class ShuffleFormatEntry
extends FormatEntry {
    @JsonProperty(value="groupingColumns")
    private final List<String> groupingColumns;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public ShuffleFormatEntry(String description, List<String> groupingColumns) {
        super(description);
        this.groupingColumns = groupingColumns;
    }

    public List<String> getGroupingColumns() {
        return this.groupingColumns;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ShuffleFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", groupingColumns=").append(String.valueOf(this.groupingColumns));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ShuffleFormatEntry)) {
            return false;
        }
        ShuffleFormatEntry other = (ShuffleFormatEntry)((Object)o);
        return Objects.equals(this.groupingColumns, other.groupingColumns) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.groupingColumns == null ? 43 : this.groupingColumns.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="groupingColumns")
        private List<String> groupingColumns;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder groupingColumns(List<String> groupingColumns) {
            this.groupingColumns = groupingColumns;
            this.__explicitlySet__.add("groupingColumns");
            return this;
        }

        public ShuffleFormatEntry build() {
            ShuffleFormatEntry model = new ShuffleFormatEntry(this.description, this.groupingColumns);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ShuffleFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("groupingColumns")) {
                this.groupingColumns(model.getGroupingColumns());
            }
            return this;
        }
    }
}

