/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlFirewallConfig
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="violationLogAutoPurge")
    private final ViolationLogAutoPurge violationLogAutoPurge;
    @JsonProperty(value="excludeJob")
    private final ExcludeJob excludeJob;
    @JsonProperty(value="timeStatusUpdated")
    private final Date timeStatusUpdated;

    @Deprecated
    @ConstructorProperties(value={"status", "violationLogAutoPurge", "excludeJob", "timeStatusUpdated"})
    public SqlFirewallConfig(Status status, ViolationLogAutoPurge violationLogAutoPurge, ExcludeJob excludeJob, Date timeStatusUpdated) {
        this.status = status;
        this.violationLogAutoPurge = violationLogAutoPurge;
        this.excludeJob = excludeJob;
        this.timeStatusUpdated = timeStatusUpdated;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public ViolationLogAutoPurge getViolationLogAutoPurge() {
        return this.violationLogAutoPurge;
    }

    public ExcludeJob getExcludeJob() {
        return this.excludeJob;
    }

    public Date getTimeStatusUpdated() {
        return this.timeStatusUpdated;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlFirewallConfig(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", violationLogAutoPurge=").append(String.valueOf((Object)this.violationLogAutoPurge));
        sb.append(", excludeJob=").append(String.valueOf((Object)this.excludeJob));
        sb.append(", timeStatusUpdated=").append(String.valueOf(this.timeStatusUpdated));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFirewallConfig)) {
            return false;
        }
        SqlFirewallConfig other = (SqlFirewallConfig)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.violationLogAutoPurge, (Object)other.violationLogAutoPurge) && Objects.equals((Object)this.excludeJob, (Object)other.excludeJob) && Objects.equals(this.timeStatusUpdated, other.timeStatusUpdated) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.violationLogAutoPurge == null ? 43 : this.violationLogAutoPurge.hashCode());
        result = result * 59 + (this.excludeJob == null ? 43 : this.excludeJob.hashCode());
        result = result * 59 + (this.timeStatusUpdated == null ? 43 : this.timeStatusUpdated.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExcludeJob implements BmcEnum
    {
        Excluded("EXCLUDED"),
        Included("INCLUDED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ExcludeJob> map;

        private ExcludeJob(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExcludeJob create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ExcludeJob', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ExcludeJob.class);
            map = new HashMap<String, ExcludeJob>();
            for (ExcludeJob v : ExcludeJob.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ViolationLogAutoPurge implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ViolationLogAutoPurge> map;

        private ViolationLogAutoPurge(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ViolationLogAutoPurge create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ViolationLogAutoPurge', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ViolationLogAutoPurge.class);
            map = new HashMap<String, ViolationLogAutoPurge>();
            for (ViolationLogAutoPurge v : ViolationLogAutoPurge.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="violationLogAutoPurge")
        private ViolationLogAutoPurge violationLogAutoPurge;
        @JsonProperty(value="excludeJob")
        private ExcludeJob excludeJob;
        @JsonProperty(value="timeStatusUpdated")
        private Date timeStatusUpdated;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder violationLogAutoPurge(ViolationLogAutoPurge violationLogAutoPurge) {
            this.violationLogAutoPurge = violationLogAutoPurge;
            this.__explicitlySet__.add("violationLogAutoPurge");
            return this;
        }

        public Builder excludeJob(ExcludeJob excludeJob) {
            this.excludeJob = excludeJob;
            this.__explicitlySet__.add("excludeJob");
            return this;
        }

        public Builder timeStatusUpdated(Date timeStatusUpdated) {
            this.timeStatusUpdated = timeStatusUpdated;
            this.__explicitlySet__.add("timeStatusUpdated");
            return this;
        }

        public SqlFirewallConfig build() {
            SqlFirewallConfig model = new SqlFirewallConfig(this.status, this.violationLogAutoPurge, this.excludeJob, this.timeStatusUpdated);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlFirewallConfig model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("violationLogAutoPurge")) {
                this.violationLogAutoPurge(model.getViolationLogAutoPurge());
            }
            if (model.wasPropertyExplicitlySet("excludeJob")) {
                this.excludeJob(model.getExcludeJob());
            }
            if (model.wasPropertyExplicitlySet("timeStatusUpdated")) {
                this.timeStatusUpdated(model.getTimeStatusUpdated());
            }
            return this;
        }
    }
}

