/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateSqlFirewallConfigDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="violationLogAutoPurge")
    private final ViolationLogAutoPurge violationLogAutoPurge;
    @JsonProperty(value="excludeJob")
    private final ExcludeJob excludeJob;

    @Deprecated
    @ConstructorProperties(value={"status", "violationLogAutoPurge", "excludeJob"})
    public UpdateSqlFirewallConfigDetails(Status status, ViolationLogAutoPurge violationLogAutoPurge, ExcludeJob excludeJob) {
        this.status = status;
        this.violationLogAutoPurge = violationLogAutoPurge;
        this.excludeJob = excludeJob;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Status getStatus() {
        return this.status;
    }

    public ViolationLogAutoPurge getViolationLogAutoPurge() {
        return this.violationLogAutoPurge;
    }

    public ExcludeJob getExcludeJob() {
        return this.excludeJob;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSqlFirewallConfigDetails(");
        sb.append("super=").append(super.toString());
        sb.append("status=").append(String.valueOf((Object)this.status));
        sb.append(", violationLogAutoPurge=").append(String.valueOf((Object)this.violationLogAutoPurge));
        sb.append(", excludeJob=").append(String.valueOf((Object)this.excludeJob));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSqlFirewallConfigDetails)) {
            return false;
        }
        UpdateSqlFirewallConfigDetails other = (UpdateSqlFirewallConfigDetails)((Object)o);
        return Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.violationLogAutoPurge, (Object)other.violationLogAutoPurge) && Objects.equals((Object)this.excludeJob, (Object)other.excludeJob) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.violationLogAutoPurge == null ? 43 : this.violationLogAutoPurge.hashCode());
        result = result * 59 + (this.excludeJob == null ? 43 : this.excludeJob.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ExcludeJob implements BmcEnum
    {
        Excluded("EXCLUDED"),
        Included("INCLUDED");

        private final String value;
        private static Map<String, ExcludeJob> map;

        private ExcludeJob(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ExcludeJob create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ExcludeJob: " + key);
        }

        static {
            map = new HashMap<String, ExcludeJob>();
            for (ExcludeJob v : ExcludeJob.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ViolationLogAutoPurge implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED");

        private final String value;
        private static Map<String, ViolationLogAutoPurge> map;

        private ViolationLogAutoPurge(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ViolationLogAutoPurge create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ViolationLogAutoPurge: " + key);
        }

        static {
            map = new HashMap<String, ViolationLogAutoPurge>();
            for (ViolationLogAutoPurge v : ViolationLogAutoPurge.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="violationLogAutoPurge")
        private ViolationLogAutoPurge violationLogAutoPurge;
        @JsonProperty(value="excludeJob")
        private ExcludeJob excludeJob;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder violationLogAutoPurge(ViolationLogAutoPurge violationLogAutoPurge) {
            this.violationLogAutoPurge = violationLogAutoPurge;
            this.__explicitlySet__.add("violationLogAutoPurge");
            return this;
        }

        public Builder excludeJob(ExcludeJob excludeJob) {
            this.excludeJob = excludeJob;
            this.__explicitlySet__.add("excludeJob");
            return this;
        }

        public UpdateSqlFirewallConfigDetails build() {
            UpdateSqlFirewallConfigDetails model = new UpdateSqlFirewallConfigDetails(this.status, this.violationLogAutoPurge, this.excludeJob);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateSqlFirewallConfigDetails model) {
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("violationLogAutoPurge")) {
                this.violationLogAutoPurge(model.getViolationLogAutoPurge());
            }
            if (model.wasPropertyExplicitlySet("excludeJob")) {
                this.excludeJob(model.getExcludeJob());
            }
            return this;
        }
    }
}

