/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UpdateSqlFirewallPolicyDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="enforcementScope")
    private final EnforcementScope enforcementScope;
    @JsonProperty(value="violationAction")
    private final ViolationAction violationAction;
    @JsonProperty(value="violationAudit")
    private final ViolationAudit violationAudit;
    @JsonProperty(value="allowedClientIps")
    private final List<String> allowedClientIps;
    @JsonProperty(value="allowedClientOsUsernames")
    private final List<String> allowedClientOsUsernames;
    @JsonProperty(value="allowedClientPrograms")
    private final List<String> allowedClientPrograms;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"displayName", "description", "status", "enforcementScope", "violationAction", "violationAudit", "allowedClientIps", "allowedClientOsUsernames", "allowedClientPrograms", "freeformTags", "definedTags"})
    public UpdateSqlFirewallPolicyDetails(String displayName, String description, Status status, EnforcementScope enforcementScope, ViolationAction violationAction, ViolationAudit violationAudit, List<String> allowedClientIps, List<String> allowedClientOsUsernames, List<String> allowedClientPrograms, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.displayName = displayName;
        this.description = description;
        this.status = status;
        this.enforcementScope = enforcementScope;
        this.violationAction = violationAction;
        this.violationAudit = violationAudit;
        this.allowedClientIps = allowedClientIps;
        this.allowedClientOsUsernames = allowedClientOsUsernames;
        this.allowedClientPrograms = allowedClientPrograms;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Status getStatus() {
        return this.status;
    }

    public EnforcementScope getEnforcementScope() {
        return this.enforcementScope;
    }

    public ViolationAction getViolationAction() {
        return this.violationAction;
    }

    public ViolationAudit getViolationAudit() {
        return this.violationAudit;
    }

    public List<String> getAllowedClientIps() {
        return this.allowedClientIps;
    }

    public List<String> getAllowedClientOsUsernames() {
        return this.allowedClientOsUsernames;
    }

    public List<String> getAllowedClientPrograms() {
        return this.allowedClientPrograms;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UpdateSqlFirewallPolicyDetails(");
        sb.append("super=").append(super.toString());
        sb.append("displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", enforcementScope=").append(String.valueOf((Object)this.enforcementScope));
        sb.append(", violationAction=").append(String.valueOf((Object)this.violationAction));
        sb.append(", violationAudit=").append(String.valueOf((Object)this.violationAudit));
        sb.append(", allowedClientIps=").append(String.valueOf(this.allowedClientIps));
        sb.append(", allowedClientOsUsernames=").append(String.valueOf(this.allowedClientOsUsernames));
        sb.append(", allowedClientPrograms=").append(String.valueOf(this.allowedClientPrograms));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSqlFirewallPolicyDetails)) {
            return false;
        }
        UpdateSqlFirewallPolicyDetails other = (UpdateSqlFirewallPolicyDetails)((Object)o);
        return Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals((Object)this.enforcementScope, (Object)other.enforcementScope) && Objects.equals((Object)this.violationAction, (Object)other.violationAction) && Objects.equals((Object)this.violationAudit, (Object)other.violationAudit) && Objects.equals(this.allowedClientIps, other.allowedClientIps) && Objects.equals(this.allowedClientOsUsernames, other.allowedClientOsUsernames) && Objects.equals(this.allowedClientPrograms, other.allowedClientPrograms) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.enforcementScope == null ? 43 : this.enforcementScope.hashCode());
        result = result * 59 + (this.violationAction == null ? 43 : this.violationAction.hashCode());
        result = result * 59 + (this.violationAudit == null ? 43 : this.violationAudit.hashCode());
        result = result * 59 + (this.allowedClientIps == null ? 43 : this.allowedClientIps.hashCode());
        result = result * 59 + (this.allowedClientOsUsernames == null ? 43 : this.allowedClientOsUsernames.hashCode());
        result = result * 59 + (this.allowedClientPrograms == null ? 43 : this.allowedClientPrograms.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ViolationAudit implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED");

        private final String value;
        private static Map<String, ViolationAudit> map;

        private ViolationAudit(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ViolationAudit create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ViolationAudit: " + key);
        }

        static {
            map = new HashMap<String, ViolationAudit>();
            for (ViolationAudit v : ViolationAudit.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum ViolationAction implements BmcEnum
    {
        Block("BLOCK"),
        Observe("OBSERVE");

        private final String value;
        private static Map<String, ViolationAction> map;

        private ViolationAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ViolationAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid ViolationAction: " + key);
        }

        static {
            map = new HashMap<String, ViolationAction>();
            for (ViolationAction v : ViolationAction.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EnforcementScope implements BmcEnum
    {
        EnforceContext("ENFORCE_CONTEXT"),
        EnforceSql("ENFORCE_SQL"),
        EnforceAll("ENFORCE_ALL");

        private final String value;
        private static Map<String, EnforcementScope> map;

        private EnforcementScope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnforcementScope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid EnforcementScope: " + key);
        }

        static {
            map = new HashMap<String, EnforcementScope>();
            for (EnforcementScope v : EnforcementScope.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum Status implements BmcEnum
    {
        Enabled("ENABLED"),
        Disabled("DISABLED");

        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid Status: " + key);
        }

        static {
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="enforcementScope")
        private EnforcementScope enforcementScope;
        @JsonProperty(value="violationAction")
        private ViolationAction violationAction;
        @JsonProperty(value="violationAudit")
        private ViolationAudit violationAudit;
        @JsonProperty(value="allowedClientIps")
        private List<String> allowedClientIps;
        @JsonProperty(value="allowedClientOsUsernames")
        private List<String> allowedClientOsUsernames;
        @JsonProperty(value="allowedClientPrograms")
        private List<String> allowedClientPrograms;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder enforcementScope(EnforcementScope enforcementScope) {
            this.enforcementScope = enforcementScope;
            this.__explicitlySet__.add("enforcementScope");
            return this;
        }

        public Builder violationAction(ViolationAction violationAction) {
            this.violationAction = violationAction;
            this.__explicitlySet__.add("violationAction");
            return this;
        }

        public Builder violationAudit(ViolationAudit violationAudit) {
            this.violationAudit = violationAudit;
            this.__explicitlySet__.add("violationAudit");
            return this;
        }

        public Builder allowedClientIps(List<String> allowedClientIps) {
            this.allowedClientIps = allowedClientIps;
            this.__explicitlySet__.add("allowedClientIps");
            return this;
        }

        public Builder allowedClientOsUsernames(List<String> allowedClientOsUsernames) {
            this.allowedClientOsUsernames = allowedClientOsUsernames;
            this.__explicitlySet__.add("allowedClientOsUsernames");
            return this;
        }

        public Builder allowedClientPrograms(List<String> allowedClientPrograms) {
            this.allowedClientPrograms = allowedClientPrograms;
            this.__explicitlySet__.add("allowedClientPrograms");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public UpdateSqlFirewallPolicyDetails build() {
            UpdateSqlFirewallPolicyDetails model = new UpdateSqlFirewallPolicyDetails(this.displayName, this.description, this.status, this.enforcementScope, this.violationAction, this.violationAudit, this.allowedClientIps, this.allowedClientOsUsernames, this.allowedClientPrograms, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UpdateSqlFirewallPolicyDetails model) {
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("enforcementScope")) {
                this.enforcementScope(model.getEnforcementScope());
            }
            if (model.wasPropertyExplicitlySet("violationAction")) {
                this.violationAction(model.getViolationAction());
            }
            if (model.wasPropertyExplicitlySet("violationAudit")) {
                this.violationAudit(model.getViolationAudit());
            }
            if (model.wasPropertyExplicitlySet("allowedClientIps")) {
                this.allowedClientIps(model.getAllowedClientIps());
            }
            if (model.wasPropertyExplicitlySet("allowedClientOsUsernames")) {
                this.allowedClientOsUsernames(model.getAllowedClientOsUsernames());
            }
            if (model.wasPropertyExplicitlySet("allowedClientPrograms")) {
                this.allowedClientPrograms(model.getAllowedClientPrograms());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

