/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.DownloadMaskingPolicyDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DownloadMaskingPolicyRequest
extends BmcRequest<DownloadMaskingPolicyDetails> {
    private String maskingPolicyId;
    private DownloadMaskingPolicyDetails downloadMaskingPolicyDetails;
    private String opcRequestId;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public DownloadMaskingPolicyDetails getDownloadMaskingPolicyDetails() {
        return this.downloadMaskingPolicyDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public DownloadMaskingPolicyDetails getBody$() {
        return this.downloadMaskingPolicyDetails;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).downloadMaskingPolicyDetails(this.downloadMaskingPolicyDetails).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",downloadMaskingPolicyDetails=").append(String.valueOf((Object)this.downloadMaskingPolicyDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DownloadMaskingPolicyRequest)) {
            return false;
        }
        DownloadMaskingPolicyRequest other = (DownloadMaskingPolicyRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.downloadMaskingPolicyDetails, (Object)other.downloadMaskingPolicyDetails) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.downloadMaskingPolicyDetails == null ? 43 : this.downloadMaskingPolicyDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DownloadMaskingPolicyRequest, DownloadMaskingPolicyDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private DownloadMaskingPolicyDetails downloadMaskingPolicyDetails = null;
        private String opcRequestId = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder downloadMaskingPolicyDetails(DownloadMaskingPolicyDetails downloadMaskingPolicyDetails) {
            this.downloadMaskingPolicyDetails = downloadMaskingPolicyDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DownloadMaskingPolicyRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.downloadMaskingPolicyDetails(o.getDownloadMaskingPolicyDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DownloadMaskingPolicyRequest build() {
            DownloadMaskingPolicyRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(DownloadMaskingPolicyDetails body) {
            this.downloadMaskingPolicyDetails(body);
            return this;
        }

        public DownloadMaskingPolicyRequest buildWithoutInvocationCallback() {
            DownloadMaskingPolicyRequest request = new DownloadMaskingPolicyRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.downloadMaskingPolicyDetails = this.downloadMaskingPolicyDetails;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

