/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.GenerateHealthReportDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GenerateHealthReportRequest
extends BmcRequest<GenerateHealthReportDetails> {
    private String maskingPolicyId;
    private GenerateHealthReportDetails generateHealthReportDetails;
    private String opcRequestId;
    private String opcRetryToken;

    public String getMaskingPolicyId() {
        return this.maskingPolicyId;
    }

    public GenerateHealthReportDetails getGenerateHealthReportDetails() {
        return this.generateHealthReportDetails;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public GenerateHealthReportDetails getBody$() {
        return this.generateHealthReportDetails;
    }

    public Builder toBuilder() {
        return new Builder().maskingPolicyId(this.maskingPolicyId).generateHealthReportDetails(this.generateHealthReportDetails).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",maskingPolicyId=").append(String.valueOf(this.maskingPolicyId));
        sb.append(",generateHealthReportDetails=").append(String.valueOf((Object)this.generateHealthReportDetails));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GenerateHealthReportRequest)) {
            return false;
        }
        GenerateHealthReportRequest other = (GenerateHealthReportRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.maskingPolicyId, other.maskingPolicyId) && Objects.equals((Object)this.generateHealthReportDetails, (Object)other.generateHealthReportDetails) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.maskingPolicyId == null ? 43 : this.maskingPolicyId.hashCode());
        result = result * 59 + (this.generateHealthReportDetails == null ? 43 : this.generateHealthReportDetails.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GenerateHealthReportRequest, GenerateHealthReportDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String maskingPolicyId = null;
        private GenerateHealthReportDetails generateHealthReportDetails = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder maskingPolicyId(String maskingPolicyId) {
            this.maskingPolicyId = maskingPolicyId;
            return this;
        }

        public Builder generateHealthReportDetails(GenerateHealthReportDetails generateHealthReportDetails) {
            this.generateHealthReportDetails = generateHealthReportDetails;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GenerateHealthReportRequest o) {
            this.maskingPolicyId(o.getMaskingPolicyId());
            this.generateHealthReportDetails(o.getGenerateHealthReportDetails());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GenerateHealthReportRequest build() {
            GenerateHealthReportRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(GenerateHealthReportDetails body) {
            this.generateHealthReportDetails(body);
            return this;
        }

        public GenerateHealthReportRequest buildWithoutInvocationCallback() {
            GenerateHealthReportRequest request = new GenerateHealthReportRequest();
            request.maskingPolicyId = this.maskingPolicyId;
            request.generateHealthReportDetails = this.generateHealthReportDetails;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

