/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDataSafePrivateEndpointRequest
extends BmcRequest<Void> {
    private String dataSafePrivateEndpointId;
    private String opcRequestId;

    public String getDataSafePrivateEndpointId() {
        return this.dataSafePrivateEndpointId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().dataSafePrivateEndpointId(this.dataSafePrivateEndpointId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",dataSafePrivateEndpointId=").append(String.valueOf(this.dataSafePrivateEndpointId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDataSafePrivateEndpointRequest)) {
            return false;
        }
        GetDataSafePrivateEndpointRequest other = (GetDataSafePrivateEndpointRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.dataSafePrivateEndpointId, other.dataSafePrivateEndpointId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.dataSafePrivateEndpointId == null ? 43 : this.dataSafePrivateEndpointId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDataSafePrivateEndpointRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String dataSafePrivateEndpointId = null;
        private String opcRequestId = null;

        public Builder dataSafePrivateEndpointId(String dataSafePrivateEndpointId) {
            this.dataSafePrivateEndpointId = dataSafePrivateEndpointId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDataSafePrivateEndpointRequest o) {
            this.dataSafePrivateEndpointId(o.getDataSafePrivateEndpointId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDataSafePrivateEndpointRequest build() {
            GetDataSafePrivateEndpointRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDataSafePrivateEndpointRequest buildWithoutInvocationCallback() {
            GetDataSafePrivateEndpointRequest request = new GetDataSafePrivateEndpointRequest();
            request.dataSafePrivateEndpointId = this.dataSafePrivateEndpointId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

