/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetDatabaseSecurityConfigRequest
extends BmcRequest<Void> {
    private String databaseSecurityConfigId;
    private String opcRequestId;

    public String getDatabaseSecurityConfigId() {
        return this.databaseSecurityConfigId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().databaseSecurityConfigId(this.databaseSecurityConfigId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",databaseSecurityConfigId=").append(String.valueOf(this.databaseSecurityConfigId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetDatabaseSecurityConfigRequest)) {
            return false;
        }
        GetDatabaseSecurityConfigRequest other = (GetDatabaseSecurityConfigRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.databaseSecurityConfigId, other.databaseSecurityConfigId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.databaseSecurityConfigId == null ? 43 : this.databaseSecurityConfigId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetDatabaseSecurityConfigRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String databaseSecurityConfigId = null;
        private String opcRequestId = null;

        public Builder databaseSecurityConfigId(String databaseSecurityConfigId) {
            this.databaseSecurityConfigId = databaseSecurityConfigId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetDatabaseSecurityConfigRequest o) {
            this.databaseSecurityConfigId(o.getDatabaseSecurityConfigId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetDatabaseSecurityConfigRequest build() {
            GetDatabaseSecurityConfigRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetDatabaseSecurityConfigRequest buildWithoutInvocationCallback() {
            GetDatabaseSecurityConfigRequest request = new GetDatabaseSecurityConfigRequest();
            request.databaseSecurityConfigId = this.databaseSecurityConfigId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

