/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListRoleGrantPathsRequest
extends BmcRequest<Void> {
    private String securityPolicyReportId;
    private String grantee;
    private String grantedRole;
    private Integer limit;
    private String page;
    private String opcRequestId;

    public String getSecurityPolicyReportId() {
        return this.securityPolicyReportId;
    }

    public String getGrantee() {
        return this.grantee;
    }

    public String getGrantedRole() {
        return this.grantedRole;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityPolicyReportId(this.securityPolicyReportId).grantee(this.grantee).grantedRole(this.grantedRole).limit(this.limit).page(this.page).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityPolicyReportId=").append(String.valueOf(this.securityPolicyReportId));
        sb.append(",grantee=").append(String.valueOf(this.grantee));
        sb.append(",grantedRole=").append(String.valueOf(this.grantedRole));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListRoleGrantPathsRequest)) {
            return false;
        }
        ListRoleGrantPathsRequest other = (ListRoleGrantPathsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityPolicyReportId, other.securityPolicyReportId) && Objects.equals(this.grantee, other.grantee) && Objects.equals(this.grantedRole, other.grantedRole) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityPolicyReportId == null ? 43 : this.securityPolicyReportId.hashCode());
        result = result * 59 + (this.grantee == null ? 43 : this.grantee.hashCode());
        result = result * 59 + (this.grantedRole == null ? 43 : this.grantedRole.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListRoleGrantPathsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityPolicyReportId = null;
        private String grantee = null;
        private String grantedRole = null;
        private Integer limit = null;
        private String page = null;
        private String opcRequestId = null;

        public Builder securityPolicyReportId(String securityPolicyReportId) {
            this.securityPolicyReportId = securityPolicyReportId;
            return this;
        }

        public Builder grantee(String grantee) {
            this.grantee = grantee;
            return this;
        }

        public Builder grantedRole(String grantedRole) {
            this.grantedRole = grantedRole;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListRoleGrantPathsRequest o) {
            this.securityPolicyReportId(o.getSecurityPolicyReportId());
            this.grantee(o.getGrantee());
            this.grantedRole(o.getGrantedRole());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListRoleGrantPathsRequest build() {
            ListRoleGrantPathsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListRoleGrantPathsRequest buildWithoutInvocationCallback() {
            ListRoleGrantPathsRequest request = new ListRoleGrantPathsRequest();
            request.securityPolicyReportId = this.securityPolicyReportId;
            request.grantee = this.grantee;
            request.grantedRole = this.grantedRole;
            request.limit = this.limit;
            request.page = this.page;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

