/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.datasafe.model.SecurityPolicyEntryStateDeploymentStatus;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class ListSecurityPolicyEntryStatesRequest
extends BmcRequest<Void> {
    private String securityPolicyDeploymentId;
    private Integer limit;
    private String page;
    private SecurityPolicyEntryStateDeploymentStatus deploymentStatus;
    private String securityPolicyEntryId;
    private String opcRequestId;

    public String getSecurityPolicyDeploymentId() {
        return this.securityPolicyDeploymentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getPage() {
        return this.page;
    }

    public SecurityPolicyEntryStateDeploymentStatus getDeploymentStatus() {
        return this.deploymentStatus;
    }

    public String getSecurityPolicyEntryId() {
        return this.securityPolicyEntryId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().securityPolicyDeploymentId(this.securityPolicyDeploymentId).limit(this.limit).page(this.page).deploymentStatus(this.deploymentStatus).securityPolicyEntryId(this.securityPolicyEntryId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",securityPolicyDeploymentId=").append(String.valueOf(this.securityPolicyDeploymentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",deploymentStatus=").append(String.valueOf((Object)this.deploymentStatus));
        sb.append(",securityPolicyEntryId=").append(String.valueOf(this.securityPolicyEntryId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSecurityPolicyEntryStatesRequest)) {
            return false;
        }
        ListSecurityPolicyEntryStatesRequest other = (ListSecurityPolicyEntryStatesRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.securityPolicyDeploymentId, other.securityPolicyDeploymentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.deploymentStatus, (Object)other.deploymentStatus) && Objects.equals(this.securityPolicyEntryId, other.securityPolicyEntryId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.securityPolicyDeploymentId == null ? 43 : this.securityPolicyDeploymentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.deploymentStatus == null ? 43 : this.deploymentStatus.hashCode());
        result = result * 59 + (this.securityPolicyEntryId == null ? 43 : this.securityPolicyEntryId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListSecurityPolicyEntryStatesRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String securityPolicyDeploymentId = null;
        private Integer limit = null;
        private String page = null;
        private SecurityPolicyEntryStateDeploymentStatus deploymentStatus = null;
        private String securityPolicyEntryId = null;
        private String opcRequestId = null;

        public Builder securityPolicyDeploymentId(String securityPolicyDeploymentId) {
            this.securityPolicyDeploymentId = securityPolicyDeploymentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder deploymentStatus(SecurityPolicyEntryStateDeploymentStatus deploymentStatus) {
            this.deploymentStatus = deploymentStatus;
            return this;
        }

        public Builder securityPolicyEntryId(String securityPolicyEntryId) {
            this.securityPolicyEntryId = securityPolicyEntryId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListSecurityPolicyEntryStatesRequest o) {
            this.securityPolicyDeploymentId(o.getSecurityPolicyDeploymentId());
            this.limit(o.getLimit());
            this.page(o.getPage());
            this.deploymentStatus(o.getDeploymentStatus());
            this.securityPolicyEntryId(o.getSecurityPolicyEntryId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListSecurityPolicyEntryStatesRequest build() {
            ListSecurityPolicyEntryStatesRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListSecurityPolicyEntryStatesRequest buildWithoutInvocationCallback() {
            ListSecurityPolicyEntryStatesRequest request = new ListSecurityPolicyEntryStatesRequest();
            request.securityPolicyDeploymentId = this.securityPolicyDeploymentId;
            request.limit = this.limit;
            request.page = this.page;
            request.deploymentStatus = this.deploymentStatus;
            request.securityPolicyEntryId = this.securityPolicyEntryId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

