/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListUsersRequest
extends BmcRequest<Void> {
    private String userAssessmentId;
    private Integer limit;
    private Boolean compartmentIdInSubtree;
    private AccessLevel accessLevel;
    private String userCategory;
    private String userRole;
    private String userProfile;
    private String userType;
    private String userKey;
    private String accountStatus;
    private String authenticationType;
    private String userName;
    private String targetId;
    private Date timeLastLoginGreaterThanOrEqualTo;
    private Date timeLastLoginLessThan;
    private Date timeUserCreatedGreaterThanOrEqualTo;
    private Date timeUserCreatedLessThan;
    private Date timePasswordLastChangedGreaterThanOrEqualTo;
    private Date timePasswordLastChangedLessThan;
    private String page;
    private SortOrder sortOrder;
    private SortBy sortBy;
    private String opcRequestId;
    private List<String> schemaList;
    private Boolean areAllSchemasAccessible;

    public String getUserAssessmentId() {
        return this.userAssessmentId;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public AccessLevel getAccessLevel() {
        return this.accessLevel;
    }

    public String getUserCategory() {
        return this.userCategory;
    }

    public String getUserRole() {
        return this.userRole;
    }

    public String getUserProfile() {
        return this.userProfile;
    }

    public String getUserType() {
        return this.userType;
    }

    public String getUserKey() {
        return this.userKey;
    }

    public String getAccountStatus() {
        return this.accountStatus;
    }

    public String getAuthenticationType() {
        return this.authenticationType;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public Date getTimeLastLoginGreaterThanOrEqualTo() {
        return this.timeLastLoginGreaterThanOrEqualTo;
    }

    public Date getTimeLastLoginLessThan() {
        return this.timeLastLoginLessThan;
    }

    public Date getTimeUserCreatedGreaterThanOrEqualTo() {
        return this.timeUserCreatedGreaterThanOrEqualTo;
    }

    public Date getTimeUserCreatedLessThan() {
        return this.timeUserCreatedLessThan;
    }

    public Date getTimePasswordLastChangedGreaterThanOrEqualTo() {
        return this.timePasswordLastChangedGreaterThanOrEqualTo;
    }

    public Date getTimePasswordLastChangedLessThan() {
        return this.timePasswordLastChangedLessThan;
    }

    public String getPage() {
        return this.page;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public List<String> getSchemaList() {
        return this.schemaList;
    }

    public Boolean getAreAllSchemasAccessible() {
        return this.areAllSchemasAccessible;
    }

    public Builder toBuilder() {
        return new Builder().userAssessmentId(this.userAssessmentId).limit(this.limit).compartmentIdInSubtree(this.compartmentIdInSubtree).accessLevel(this.accessLevel).userCategory(this.userCategory).userRole(this.userRole).userProfile(this.userProfile).userType(this.userType).userKey(this.userKey).accountStatus(this.accountStatus).authenticationType(this.authenticationType).userName(this.userName).targetId(this.targetId).timeLastLoginGreaterThanOrEqualTo(this.timeLastLoginGreaterThanOrEqualTo).timeLastLoginLessThan(this.timeLastLoginLessThan).timeUserCreatedGreaterThanOrEqualTo(this.timeUserCreatedGreaterThanOrEqualTo).timeUserCreatedLessThan(this.timeUserCreatedLessThan).timePasswordLastChangedGreaterThanOrEqualTo(this.timePasswordLastChangedGreaterThanOrEqualTo).timePasswordLastChangedLessThan(this.timePasswordLastChangedLessThan).page(this.page).sortOrder(this.sortOrder).sortBy(this.sortBy).opcRequestId(this.opcRequestId).schemaList(this.schemaList).areAllSchemasAccessible(this.areAllSchemasAccessible);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userAssessmentId=").append(String.valueOf(this.userAssessmentId));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",accessLevel=").append(String.valueOf((Object)this.accessLevel));
        sb.append(",userCategory=").append(String.valueOf(this.userCategory));
        sb.append(",userRole=").append(String.valueOf(this.userRole));
        sb.append(",userProfile=").append(String.valueOf(this.userProfile));
        sb.append(",userType=").append(String.valueOf(this.userType));
        sb.append(",userKey=").append(String.valueOf(this.userKey));
        sb.append(",accountStatus=").append(String.valueOf(this.accountStatus));
        sb.append(",authenticationType=").append(String.valueOf(this.authenticationType));
        sb.append(",userName=").append(String.valueOf(this.userName));
        sb.append(",targetId=").append(String.valueOf(this.targetId));
        sb.append(",timeLastLoginGreaterThanOrEqualTo=").append(String.valueOf(this.timeLastLoginGreaterThanOrEqualTo));
        sb.append(",timeLastLoginLessThan=").append(String.valueOf(this.timeLastLoginLessThan));
        sb.append(",timeUserCreatedGreaterThanOrEqualTo=").append(String.valueOf(this.timeUserCreatedGreaterThanOrEqualTo));
        sb.append(",timeUserCreatedLessThan=").append(String.valueOf(this.timeUserCreatedLessThan));
        sb.append(",timePasswordLastChangedGreaterThanOrEqualTo=").append(String.valueOf(this.timePasswordLastChangedGreaterThanOrEqualTo));
        sb.append(",timePasswordLastChangedLessThan=").append(String.valueOf(this.timePasswordLastChangedLessThan));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",schemaList=").append(String.valueOf(this.schemaList));
        sb.append(",areAllSchemasAccessible=").append(String.valueOf(this.areAllSchemasAccessible));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListUsersRequest)) {
            return false;
        }
        ListUsersRequest other = (ListUsersRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userAssessmentId, other.userAssessmentId) && Objects.equals(this.limit, other.limit) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.accessLevel, (Object)other.accessLevel) && Objects.equals(this.userCategory, other.userCategory) && Objects.equals(this.userRole, other.userRole) && Objects.equals(this.userProfile, other.userProfile) && Objects.equals(this.userType, other.userType) && Objects.equals(this.userKey, other.userKey) && Objects.equals(this.accountStatus, other.accountStatus) && Objects.equals(this.authenticationType, other.authenticationType) && Objects.equals(this.userName, other.userName) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.timeLastLoginGreaterThanOrEqualTo, other.timeLastLoginGreaterThanOrEqualTo) && Objects.equals(this.timeLastLoginLessThan, other.timeLastLoginLessThan) && Objects.equals(this.timeUserCreatedGreaterThanOrEqualTo, other.timeUserCreatedGreaterThanOrEqualTo) && Objects.equals(this.timeUserCreatedLessThan, other.timeUserCreatedLessThan) && Objects.equals(this.timePasswordLastChangedGreaterThanOrEqualTo, other.timePasswordLastChangedGreaterThanOrEqualTo) && Objects.equals(this.timePasswordLastChangedLessThan, other.timePasswordLastChangedLessThan) && Objects.equals(this.page, other.page) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.schemaList, other.schemaList) && Objects.equals(this.areAllSchemasAccessible, other.areAllSchemasAccessible);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userAssessmentId == null ? 43 : this.userAssessmentId.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.accessLevel == null ? 43 : this.accessLevel.hashCode());
        result = result * 59 + (this.userCategory == null ? 43 : this.userCategory.hashCode());
        result = result * 59 + (this.userRole == null ? 43 : this.userRole.hashCode());
        result = result * 59 + (this.userProfile == null ? 43 : this.userProfile.hashCode());
        result = result * 59 + (this.userType == null ? 43 : this.userType.hashCode());
        result = result * 59 + (this.userKey == null ? 43 : this.userKey.hashCode());
        result = result * 59 + (this.accountStatus == null ? 43 : this.accountStatus.hashCode());
        result = result * 59 + (this.authenticationType == null ? 43 : this.authenticationType.hashCode());
        result = result * 59 + (this.userName == null ? 43 : this.userName.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.timeLastLoginGreaterThanOrEqualTo == null ? 43 : this.timeLastLoginGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeLastLoginLessThan == null ? 43 : this.timeLastLoginLessThan.hashCode());
        result = result * 59 + (this.timeUserCreatedGreaterThanOrEqualTo == null ? 43 : this.timeUserCreatedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timeUserCreatedLessThan == null ? 43 : this.timeUserCreatedLessThan.hashCode());
        result = result * 59 + (this.timePasswordLastChangedGreaterThanOrEqualTo == null ? 43 : this.timePasswordLastChangedGreaterThanOrEqualTo.hashCode());
        result = result * 59 + (this.timePasswordLastChangedLessThan == null ? 43 : this.timePasswordLastChangedLessThan.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.schemaList == null ? 43 : this.schemaList.hashCode());
        result = result * 59 + (this.areAllSchemasAccessible == null ? 43 : this.areAllSchemasAccessible.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListUsersRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userAssessmentId = null;
        private Integer limit = null;
        private Boolean compartmentIdInSubtree = null;
        private AccessLevel accessLevel = null;
        private String userCategory = null;
        private String userRole = null;
        private String userProfile = null;
        private String userType = null;
        private String userKey = null;
        private String accountStatus = null;
        private String authenticationType = null;
        private String userName = null;
        private String targetId = null;
        private Date timeLastLoginGreaterThanOrEqualTo = null;
        private Date timeLastLoginLessThan = null;
        private Date timeUserCreatedGreaterThanOrEqualTo = null;
        private Date timeUserCreatedLessThan = null;
        private Date timePasswordLastChangedGreaterThanOrEqualTo = null;
        private Date timePasswordLastChangedLessThan = null;
        private String page = null;
        private SortOrder sortOrder = null;
        private SortBy sortBy = null;
        private String opcRequestId = null;
        private List<String> schemaList = null;
        private Boolean areAllSchemasAccessible = null;

        public Builder userAssessmentId(String userAssessmentId) {
            this.userAssessmentId = userAssessmentId;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder accessLevel(AccessLevel accessLevel) {
            this.accessLevel = accessLevel;
            return this;
        }

        public Builder userCategory(String userCategory) {
            this.userCategory = userCategory;
            return this;
        }

        public Builder userRole(String userRole) {
            this.userRole = userRole;
            return this;
        }

        public Builder userProfile(String userProfile) {
            this.userProfile = userProfile;
            return this;
        }

        public Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        public Builder userKey(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public Builder accountStatus(String accountStatus) {
            this.accountStatus = accountStatus;
            return this;
        }

        public Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        public Builder userName(String userName) {
            this.userName = userName;
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            return this;
        }

        public Builder timeLastLoginGreaterThanOrEqualTo(Date timeLastLoginGreaterThanOrEqualTo) {
            this.timeLastLoginGreaterThanOrEqualTo = timeLastLoginGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeLastLoginLessThan(Date timeLastLoginLessThan) {
            this.timeLastLoginLessThan = timeLastLoginLessThan;
            return this;
        }

        public Builder timeUserCreatedGreaterThanOrEqualTo(Date timeUserCreatedGreaterThanOrEqualTo) {
            this.timeUserCreatedGreaterThanOrEqualTo = timeUserCreatedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timeUserCreatedLessThan(Date timeUserCreatedLessThan) {
            this.timeUserCreatedLessThan = timeUserCreatedLessThan;
            return this;
        }

        public Builder timePasswordLastChangedGreaterThanOrEqualTo(Date timePasswordLastChangedGreaterThanOrEqualTo) {
            this.timePasswordLastChangedGreaterThanOrEqualTo = timePasswordLastChangedGreaterThanOrEqualTo;
            return this;
        }

        public Builder timePasswordLastChangedLessThan(Date timePasswordLastChangedLessThan) {
            this.timePasswordLastChangedLessThan = timePasswordLastChangedLessThan;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder schemaList(List<String> schemaList) {
            this.schemaList = schemaList;
            return this;
        }

        public Builder schemaList(String singularValue) {
            return this.schemaList(Arrays.asList(singularValue));
        }

        public Builder areAllSchemasAccessible(Boolean areAllSchemasAccessible) {
            this.areAllSchemasAccessible = areAllSchemasAccessible;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListUsersRequest o) {
            this.userAssessmentId(o.getUserAssessmentId());
            this.limit(o.getLimit());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.accessLevel(o.getAccessLevel());
            this.userCategory(o.getUserCategory());
            this.userRole(o.getUserRole());
            this.userProfile(o.getUserProfile());
            this.userType(o.getUserType());
            this.userKey(o.getUserKey());
            this.accountStatus(o.getAccountStatus());
            this.authenticationType(o.getAuthenticationType());
            this.userName(o.getUserName());
            this.targetId(o.getTargetId());
            this.timeLastLoginGreaterThanOrEqualTo(o.getTimeLastLoginGreaterThanOrEqualTo());
            this.timeLastLoginLessThan(o.getTimeLastLoginLessThan());
            this.timeUserCreatedGreaterThanOrEqualTo(o.getTimeUserCreatedGreaterThanOrEqualTo());
            this.timeUserCreatedLessThan(o.getTimeUserCreatedLessThan());
            this.timePasswordLastChangedGreaterThanOrEqualTo(o.getTimePasswordLastChangedGreaterThanOrEqualTo());
            this.timePasswordLastChangedLessThan(o.getTimePasswordLastChangedLessThan());
            this.page(o.getPage());
            this.sortOrder(o.getSortOrder());
            this.sortBy(o.getSortBy());
            this.opcRequestId(o.getOpcRequestId());
            this.schemaList(o.getSchemaList());
            this.areAllSchemasAccessible(o.getAreAllSchemasAccessible());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListUsersRequest build() {
            ListUsersRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListUsersRequest buildWithoutInvocationCallback() {
            ListUsersRequest request = new ListUsersRequest();
            request.userAssessmentId = this.userAssessmentId;
            request.limit = this.limit;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.accessLevel = this.accessLevel;
            request.userCategory = this.userCategory;
            request.userRole = this.userRole;
            request.userProfile = this.userProfile;
            request.userType = this.userType;
            request.userKey = this.userKey;
            request.accountStatus = this.accountStatus;
            request.authenticationType = this.authenticationType;
            request.userName = this.userName;
            request.targetId = this.targetId;
            request.timeLastLoginGreaterThanOrEqualTo = this.timeLastLoginGreaterThanOrEqualTo;
            request.timeLastLoginLessThan = this.timeLastLoginLessThan;
            request.timeUserCreatedGreaterThanOrEqualTo = this.timeUserCreatedGreaterThanOrEqualTo;
            request.timeUserCreatedLessThan = this.timeUserCreatedLessThan;
            request.timePasswordLastChangedGreaterThanOrEqualTo = this.timePasswordLastChangedGreaterThanOrEqualTo;
            request.timePasswordLastChangedLessThan = this.timePasswordLastChangedLessThan;
            request.page = this.page;
            request.sortOrder = this.sortOrder;
            request.sortBy = this.sortBy;
            request.opcRequestId = this.opcRequestId;
            request.schemaList = this.schemaList;
            request.areAllSchemasAccessible = this.areAllSchemasAccessible;
            return request;
        }
    }

    public static enum SortBy implements BmcEnum
    {
        UserName("userName"),
        UserCategory("userCategory"),
        AccountStatus("accountStatus"),
        TimeLastLogin("timeLastLogin"),
        TargetId("targetId"),
        TimeUserCreated("timeUserCreated"),
        AuthenticationType("authenticationType"),
        TimePasswordChanged("timePasswordChanged");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum AccessLevel implements BmcEnum
    {
        Restricted("RESTRICTED"),
        Accessible("ACCESSIBLE");

        private final String value;
        private static Map<String, AccessLevel> map;

        private AccessLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AccessLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid AccessLevel: " + key);
        }

        static {
            map = new HashMap<String, AccessLevel>();
            for (AccessLevel v : AccessLevel.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

