/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.UpdateReportDefinitionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateReportDefinitionRequest
extends BmcRequest<UpdateReportDefinitionDetails> {
    private String reportDefinitionId;
    private UpdateReportDefinitionDetails updateReportDefinitionDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getReportDefinitionId() {
        return this.reportDefinitionId;
    }

    public UpdateReportDefinitionDetails getUpdateReportDefinitionDetails() {
        return this.updateReportDefinitionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public UpdateReportDefinitionDetails getBody$() {
        return this.updateReportDefinitionDetails;
    }

    public Builder toBuilder() {
        return new Builder().reportDefinitionId(this.reportDefinitionId).updateReportDefinitionDetails(this.updateReportDefinitionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",reportDefinitionId=").append(String.valueOf(this.reportDefinitionId));
        sb.append(",updateReportDefinitionDetails=").append(String.valueOf((Object)this.updateReportDefinitionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateReportDefinitionRequest)) {
            return false;
        }
        UpdateReportDefinitionRequest other = (UpdateReportDefinitionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.reportDefinitionId, other.reportDefinitionId) && Objects.equals((Object)this.updateReportDefinitionDetails, (Object)other.updateReportDefinitionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.reportDefinitionId == null ? 43 : this.reportDefinitionId.hashCode());
        result = result * 59 + (this.updateReportDefinitionDetails == null ? 43 : this.updateReportDefinitionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateReportDefinitionRequest, UpdateReportDefinitionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String reportDefinitionId = null;
        private UpdateReportDefinitionDetails updateReportDefinitionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder reportDefinitionId(String reportDefinitionId) {
            this.reportDefinitionId = reportDefinitionId;
            return this;
        }

        public Builder updateReportDefinitionDetails(UpdateReportDefinitionDetails updateReportDefinitionDetails) {
            this.updateReportDefinitionDetails = updateReportDefinitionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateReportDefinitionRequest o) {
            this.reportDefinitionId(o.getReportDefinitionId());
            this.updateReportDefinitionDetails(o.getUpdateReportDefinitionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateReportDefinitionRequest build() {
            UpdateReportDefinitionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateReportDefinitionDetails body) {
            this.updateReportDefinitionDetails(body);
            return this;
        }

        public UpdateReportDefinitionRequest buildWithoutInvocationCallback() {
            UpdateReportDefinitionRequest request = new UpdateReportDefinitionRequest();
            request.reportDefinitionId = this.reportDefinitionId;
            request.updateReportDefinitionDetails = this.updateReportDefinitionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

