/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.UpdateSqlCollectionDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class UpdateSqlCollectionRequest
extends BmcRequest<UpdateSqlCollectionDetails> {
    private String sqlCollectionId;
    private UpdateSqlCollectionDetails updateSqlCollectionDetails;
    private String ifMatch;
    private String opcRequestId;

    public String getSqlCollectionId() {
        return this.sqlCollectionId;
    }

    public UpdateSqlCollectionDetails getUpdateSqlCollectionDetails() {
        return this.updateSqlCollectionDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    @InternalSdk
    public UpdateSqlCollectionDetails getBody$() {
        return this.updateSqlCollectionDetails;
    }

    public Builder toBuilder() {
        return new Builder().sqlCollectionId(this.sqlCollectionId).updateSqlCollectionDetails(this.updateSqlCollectionDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",sqlCollectionId=").append(String.valueOf(this.sqlCollectionId));
        sb.append(",updateSqlCollectionDetails=").append(String.valueOf((Object)this.updateSqlCollectionDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UpdateSqlCollectionRequest)) {
            return false;
        }
        UpdateSqlCollectionRequest other = (UpdateSqlCollectionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.sqlCollectionId, other.sqlCollectionId) && Objects.equals((Object)this.updateSqlCollectionDetails, (Object)other.updateSqlCollectionDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlCollectionId == null ? 43 : this.sqlCollectionId.hashCode());
        result = result * 59 + (this.updateSqlCollectionDetails == null ? 43 : this.updateSqlCollectionDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<UpdateSqlCollectionRequest, UpdateSqlCollectionDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String sqlCollectionId = null;
        private UpdateSqlCollectionDetails updateSqlCollectionDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;

        public Builder sqlCollectionId(String sqlCollectionId) {
            this.sqlCollectionId = sqlCollectionId;
            return this;
        }

        public Builder updateSqlCollectionDetails(UpdateSqlCollectionDetails updateSqlCollectionDetails) {
            this.updateSqlCollectionDetails = updateSqlCollectionDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(UpdateSqlCollectionRequest o) {
            this.sqlCollectionId(o.getSqlCollectionId());
            this.updateSqlCollectionDetails(o.getUpdateSqlCollectionDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public UpdateSqlCollectionRequest build() {
            UpdateSqlCollectionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(UpdateSqlCollectionDetails body) {
            this.updateSqlCollectionDetails(body);
            return this;
        }

        public UpdateSqlCollectionRequest buildWithoutInvocationCallback() {
            UpdateSqlCollectionRequest request = new UpdateSqlCollectionRequest();
            request.sqlCollectionId = this.sqlCollectionId;
            request.updateSqlCollectionDetails = this.updateSqlCollectionDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

