/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.responses;

import com.oracle.bmc.datasafe.model.AlertCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListAlertsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private String opcPrevPage;
    private AlertCollection alertCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public AlertCollection getAlertCollection() {
        return this.alertCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "opcPrevPage", "alertCollection"})
    private ListAlertsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, String opcPrevPage, AlertCollection alertCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcPrevPage = opcPrevPage;
        this.alertCollection = alertCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcPrevPage=").append(String.valueOf(this.opcPrevPage));
        sb.append(",alertCollection=").append(String.valueOf((Object)this.alertCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAlertsResponse)) {
            return false;
        }
        ListAlertsResponse other = (ListAlertsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcPrevPage, other.opcPrevPage) && Objects.equals((Object)this.alertCollection, (Object)other.alertCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcPrevPage == null ? 43 : this.opcPrevPage.hashCode());
        result = result * 59 + (this.alertCollection == null ? 43 : this.alertCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListAlertsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private String opcPrevPage;
        private AlertCollection alertCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder alertCollection(AlertCollection alertCollection) {
            this.alertCollection = alertCollection;
            return this;
        }

        public Builder copy(ListAlertsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcPrevPage(o.getOpcPrevPage());
            this.alertCollection(o.getAlertCollection());
            return this;
        }

        public ListAlertsResponse build() {
            return new ListAlertsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.opcPrevPage, this.alertCollection);
        }
    }
}

