/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.responses;

import com.oracle.bmc.datasafe.model.SensitiveObjectCollection;
import com.oracle.bmc.responses.BmcResponse;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ListSensitiveObjectsResponse
extends BmcResponse {
    private String opcRequestId;
    private String opcNextPage;
    private String opcPrevPage;
    private SensitiveObjectCollection sensitiveObjectCollection;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcNextPage() {
        return this.opcNextPage;
    }

    public String getOpcPrevPage() {
        return this.opcPrevPage;
    }

    public SensitiveObjectCollection getSensitiveObjectCollection() {
        return this.sensitiveObjectCollection;
    }

    @ConstructorProperties(value={"__httpStatusCode__", "headers", "opcRequestId", "opcNextPage", "opcPrevPage", "sensitiveObjectCollection"})
    private ListSensitiveObjectsResponse(int __httpStatusCode__, Map<String, List<String>> headers, String opcRequestId, String opcNextPage, String opcPrevPage, SensitiveObjectCollection sensitiveObjectCollection) {
        super(__httpStatusCode__, headers);
        this.opcRequestId = opcRequestId;
        this.opcNextPage = opcNextPage;
        this.opcPrevPage = opcPrevPage;
        this.sensitiveObjectCollection = sensitiveObjectCollection;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcNextPage=").append(String.valueOf(this.opcNextPage));
        sb.append(",opcPrevPage=").append(String.valueOf(this.opcPrevPage));
        sb.append(",sensitiveObjectCollection=").append(String.valueOf((Object)this.sensitiveObjectCollection));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListSensitiveObjectsResponse)) {
            return false;
        }
        ListSensitiveObjectsResponse other = (ListSensitiveObjectsResponse)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcNextPage, other.opcNextPage) && Objects.equals(this.opcPrevPage, other.opcPrevPage) && Objects.equals((Object)this.sensitiveObjectCollection, (Object)other.sensitiveObjectCollection);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcNextPage == null ? 43 : this.opcNextPage.hashCode());
        result = result * 59 + (this.opcPrevPage == null ? 43 : this.opcPrevPage.hashCode());
        result = result * 59 + (this.sensitiveObjectCollection == null ? 43 : this.sensitiveObjectCollection.hashCode());
        return result;
    }

    public static class Builder
    implements BmcResponse.Builder<ListSensitiveObjectsResponse> {
        private int __httpStatusCode__;
        private Map<String, List<String>> headers;
        private String opcRequestId;
        private String opcNextPage;
        private String opcPrevPage;
        private SensitiveObjectCollection sensitiveObjectCollection;

        public Builder __httpStatusCode__(int __httpStatusCode__) {
            this.__httpStatusCode__ = __httpStatusCode__;
            return this;
        }

        public Builder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcNextPage(String opcNextPage) {
            this.opcNextPage = opcNextPage;
            return this;
        }

        public Builder opcPrevPage(String opcPrevPage) {
            this.opcPrevPage = opcPrevPage;
            return this;
        }

        public Builder sensitiveObjectCollection(SensitiveObjectCollection sensitiveObjectCollection) {
            this.sensitiveObjectCollection = sensitiveObjectCollection;
            return this;
        }

        public Builder copy(ListSensitiveObjectsResponse o) {
            this.__httpStatusCode__(o.get__httpStatusCode__());
            this.headers(o.getHeaders());
            this.opcRequestId(o.getOpcRequestId());
            this.opcNextPage(o.getOpcNextPage());
            this.opcPrevPage(o.getOpcPrevPage());
            this.sensitiveObjectCollection(o.getSensitiveObjectCollection());
            return this;
        }

        public ListSensitiveObjectsResponse build() {
            return new ListSensitiveObjectsResponse(this.__httpStatusCode__, this.headers, this.opcRequestId, this.opcNextPage, this.opcPrevPage, this.sensitiveObjectCollection);
        }
    }
}

