/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AuditEventAggregationDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="auditEventTime")
    private final List<Date> auditEventTime;
    @JsonProperty(value="dbUserName")
    private final List<String> dbUserName;
    @JsonProperty(value="targetId")
    private final List<String> targetId;
    @JsonProperty(value="targetName")
    private final List<String> targetName;
    @JsonProperty(value="targetClass")
    private final List<TargetClass> targetClass;
    @JsonProperty(value="objectType")
    private final List<String> objectType;
    @JsonProperty(value="clientHostname")
    private final List<String> clientHostname;
    @JsonProperty(value="clientProgram")
    private final List<String> clientProgram;
    @JsonProperty(value="clientId")
    private final List<String> clientId;
    @JsonProperty(value="auditType")
    private final List<AuditType> auditType;
    @JsonProperty(value="eventName")
    private final List<String> eventName;

    @Deprecated
    @ConstructorProperties(value={"auditEventTime", "dbUserName", "targetId", "targetName", "targetClass", "objectType", "clientHostname", "clientProgram", "clientId", "auditType", "eventName"})
    public AuditEventAggregationDimensions(List<Date> auditEventTime, List<String> dbUserName, List<String> targetId, List<String> targetName, List<TargetClass> targetClass, List<String> objectType, List<String> clientHostname, List<String> clientProgram, List<String> clientId, List<AuditType> auditType, List<String> eventName) {
        this.auditEventTime = auditEventTime;
        this.dbUserName = dbUserName;
        this.targetId = targetId;
        this.targetName = targetName;
        this.targetClass = targetClass;
        this.objectType = objectType;
        this.clientHostname = clientHostname;
        this.clientProgram = clientProgram;
        this.clientId = clientId;
        this.auditType = auditType;
        this.eventName = eventName;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public List<Date> getAuditEventTime() {
        return this.auditEventTime;
    }

    public List<String> getDbUserName() {
        return this.dbUserName;
    }

    public List<String> getTargetId() {
        return this.targetId;
    }

    public List<String> getTargetName() {
        return this.targetName;
    }

    public List<TargetClass> getTargetClass() {
        return this.targetClass;
    }

    public List<String> getObjectType() {
        return this.objectType;
    }

    public List<String> getClientHostname() {
        return this.clientHostname;
    }

    public List<String> getClientProgram() {
        return this.clientProgram;
    }

    public List<String> getClientId() {
        return this.clientId;
    }

    public List<AuditType> getAuditType() {
        return this.auditType;
    }

    public List<String> getEventName() {
        return this.eventName;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AuditEventAggregationDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("auditEventTime=").append(String.valueOf(this.auditEventTime));
        sb.append(", dbUserName=").append(String.valueOf(this.dbUserName));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetName=").append(String.valueOf(this.targetName));
        sb.append(", targetClass=").append(String.valueOf(this.targetClass));
        sb.append(", objectType=").append(String.valueOf(this.objectType));
        sb.append(", clientHostname=").append(String.valueOf(this.clientHostname));
        sb.append(", clientProgram=").append(String.valueOf(this.clientProgram));
        sb.append(", clientId=").append(String.valueOf(this.clientId));
        sb.append(", auditType=").append(String.valueOf(this.auditType));
        sb.append(", eventName=").append(String.valueOf(this.eventName));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AuditEventAggregationDimensions)) {
            return false;
        }
        AuditEventAggregationDimensions other = (AuditEventAggregationDimensions)((Object)o);
        return Objects.equals(this.auditEventTime, other.auditEventTime) && Objects.equals(this.dbUserName, other.dbUserName) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.targetClass, other.targetClass) && Objects.equals(this.objectType, other.objectType) && Objects.equals(this.clientHostname, other.clientHostname) && Objects.equals(this.clientProgram, other.clientProgram) && Objects.equals(this.clientId, other.clientId) && Objects.equals(this.auditType, other.auditType) && Objects.equals(this.eventName, other.eventName) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.auditEventTime == null ? 43 : this.auditEventTime.hashCode());
        result = result * 59 + (this.dbUserName == null ? 43 : this.dbUserName.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.targetClass == null ? 43 : this.targetClass.hashCode());
        result = result * 59 + (this.objectType == null ? 43 : this.objectType.hashCode());
        result = result * 59 + (this.clientHostname == null ? 43 : this.clientHostname.hashCode());
        result = result * 59 + (this.clientProgram == null ? 43 : this.clientProgram.hashCode());
        result = result * 59 + (this.clientId == null ? 43 : this.clientId.hashCode());
        result = result * 59 + (this.auditType == null ? 43 : this.auditType.hashCode());
        result = result * 59 + (this.eventName == null ? 43 : this.eventName.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum AuditType implements BmcEnum
    {
        Standard("STANDARD"),
        FineGrained("FINE_GRAINED"),
        Xs("XS"),
        DatabaseVault("DATABASE_VAULT"),
        LabelSecurity("LABEL_SECURITY"),
        Rman("RMAN"),
        Datapump("DATAPUMP"),
        DirectPathApi("DIRECT_PATH_API"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, AuditType> map;

        private AuditType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static AuditType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'AuditType', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(AuditType.class);
            map = new HashMap<String, AuditType>();
            for (AuditType v : AuditType.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TargetClass implements BmcEnum
    {
        Database("DATABASE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TargetClass> map;

        private TargetClass(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetClass create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TargetClass', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TargetClass.class);
            map = new HashMap<String, TargetClass>();
            for (TargetClass v : TargetClass.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="auditEventTime")
        private List<Date> auditEventTime;
        @JsonProperty(value="dbUserName")
        private List<String> dbUserName;
        @JsonProperty(value="targetId")
        private List<String> targetId;
        @JsonProperty(value="targetName")
        private List<String> targetName;
        @JsonProperty(value="targetClass")
        private List<TargetClass> targetClass;
        @JsonProperty(value="objectType")
        private List<String> objectType;
        @JsonProperty(value="clientHostname")
        private List<String> clientHostname;
        @JsonProperty(value="clientProgram")
        private List<String> clientProgram;
        @JsonProperty(value="clientId")
        private List<String> clientId;
        @JsonProperty(value="auditType")
        private List<AuditType> auditType;
        @JsonProperty(value="eventName")
        private List<String> eventName;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder auditEventTime(List<Date> auditEventTime) {
            this.auditEventTime = auditEventTime;
            this.__explicitlySet__.add("auditEventTime");
            return this;
        }

        public Builder dbUserName(List<String> dbUserName) {
            this.dbUserName = dbUserName;
            this.__explicitlySet__.add("dbUserName");
            return this;
        }

        public Builder targetId(List<String> targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetName(List<String> targetName) {
            this.targetName = targetName;
            this.__explicitlySet__.add("targetName");
            return this;
        }

        public Builder targetClass(List<TargetClass> targetClass) {
            this.targetClass = targetClass;
            this.__explicitlySet__.add("targetClass");
            return this;
        }

        public Builder objectType(List<String> objectType) {
            this.objectType = objectType;
            this.__explicitlySet__.add("objectType");
            return this;
        }

        public Builder clientHostname(List<String> clientHostname) {
            this.clientHostname = clientHostname;
            this.__explicitlySet__.add("clientHostname");
            return this;
        }

        public Builder clientProgram(List<String> clientProgram) {
            this.clientProgram = clientProgram;
            this.__explicitlySet__.add("clientProgram");
            return this;
        }

        public Builder clientId(List<String> clientId) {
            this.clientId = clientId;
            this.__explicitlySet__.add("clientId");
            return this;
        }

        public Builder auditType(List<AuditType> auditType) {
            this.auditType = auditType;
            this.__explicitlySet__.add("auditType");
            return this;
        }

        public Builder eventName(List<String> eventName) {
            this.eventName = eventName;
            this.__explicitlySet__.add("eventName");
            return this;
        }

        public AuditEventAggregationDimensions build() {
            AuditEventAggregationDimensions model = new AuditEventAggregationDimensions(this.auditEventTime, this.dbUserName, this.targetId, this.targetName, this.targetClass, this.objectType, this.clientHostname, this.clientProgram, this.clientId, this.auditType, this.eventName);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AuditEventAggregationDimensions model) {
            if (model.wasPropertyExplicitlySet("auditEventTime")) {
                this.auditEventTime(model.getAuditEventTime());
            }
            if (model.wasPropertyExplicitlySet("dbUserName")) {
                this.dbUserName(model.getDbUserName());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetName")) {
                this.targetName(model.getTargetName());
            }
            if (model.wasPropertyExplicitlySet("targetClass")) {
                this.targetClass(model.getTargetClass());
            }
            if (model.wasPropertyExplicitlySet("objectType")) {
                this.objectType(model.getObjectType());
            }
            if (model.wasPropertyExplicitlySet("clientHostname")) {
                this.clientHostname(model.getClientHostname());
            }
            if (model.wasPropertyExplicitlySet("clientProgram")) {
                this.clientProgram(model.getClientProgram());
            }
            if (model.wasPropertyExplicitlySet("clientId")) {
                this.clientId(model.getClientId());
            }
            if (model.wasPropertyExplicitlySet("auditType")) {
                this.auditType(model.getAuditType());
            }
            if (model.wasPropertyExplicitlySet("eventName")) {
                this.eventName(model.getEventName());
            }
            return this;
        }
    }
}

