/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.FormatEntry;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonFilter(value="explicitlySetFilter")
public final class SQLExpressionFormatEntry
extends FormatEntry {
    @JsonProperty(value="sqlExpression")
    private final String sqlExpression;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public SQLExpressionFormatEntry(String description, String sqlExpression) {
        super(description);
        this.sqlExpression = sqlExpression;
    }

    public String getSqlExpression() {
        return this.sqlExpression;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SQLExpressionFormatEntry(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", sqlExpression=").append(String.valueOf(this.sqlExpression));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SQLExpressionFormatEntry)) {
            return false;
        }
        SQLExpressionFormatEntry other = (SQLExpressionFormatEntry)((Object)o);
        return Objects.equals(this.sqlExpression, other.sqlExpression) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.sqlExpression == null ? 43 : this.sqlExpression.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="sqlExpression")
        private String sqlExpression;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder sqlExpression(String sqlExpression) {
            this.sqlExpression = sqlExpression;
            this.__explicitlySet__.add("sqlExpression");
            return this;
        }

        public SQLExpressionFormatEntry build() {
            SQLExpressionFormatEntry model = new SQLExpressionFormatEntry(this.description, this.sqlExpression);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SQLExpressionFormatEntry model) {
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("sqlExpression")) {
                this.sqlExpression(model.getSqlExpression());
            }
            return this;
        }
    }
}

