/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SectionStatistics
extends ExplicitlySetBmcModel {
    @JsonProperty(value="targetsCount")
    private final Integer targetsCount;
    @JsonProperty(value="auditingFindingsCount")
    private final Integer auditingFindingsCount;
    @JsonProperty(value="authorizationControlFindingsCount")
    private final Integer authorizationControlFindingsCount;
    @JsonProperty(value="dataEncryptionFindingsCount")
    private final Integer dataEncryptionFindingsCount;
    @JsonProperty(value="dbConfigurationFindingsCount")
    private final Integer dbConfigurationFindingsCount;
    @JsonProperty(value="fineGrainedAccessControlFindingsCount")
    private final Integer fineGrainedAccessControlFindingsCount;
    @JsonProperty(value="privilegesAndRolesFindingsCount")
    private final Integer privilegesAndRolesFindingsCount;
    @JsonProperty(value="userAccountsFindingsCount")
    private final Integer userAccountsFindingsCount;

    @Deprecated
    @ConstructorProperties(value={"targetsCount", "auditingFindingsCount", "authorizationControlFindingsCount", "dataEncryptionFindingsCount", "dbConfigurationFindingsCount", "fineGrainedAccessControlFindingsCount", "privilegesAndRolesFindingsCount", "userAccountsFindingsCount"})
    public SectionStatistics(Integer targetsCount, Integer auditingFindingsCount, Integer authorizationControlFindingsCount, Integer dataEncryptionFindingsCount, Integer dbConfigurationFindingsCount, Integer fineGrainedAccessControlFindingsCount, Integer privilegesAndRolesFindingsCount, Integer userAccountsFindingsCount) {
        this.targetsCount = targetsCount;
        this.auditingFindingsCount = auditingFindingsCount;
        this.authorizationControlFindingsCount = authorizationControlFindingsCount;
        this.dataEncryptionFindingsCount = dataEncryptionFindingsCount;
        this.dbConfigurationFindingsCount = dbConfigurationFindingsCount;
        this.fineGrainedAccessControlFindingsCount = fineGrainedAccessControlFindingsCount;
        this.privilegesAndRolesFindingsCount = privilegesAndRolesFindingsCount;
        this.userAccountsFindingsCount = userAccountsFindingsCount;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public Integer getTargetsCount() {
        return this.targetsCount;
    }

    public Integer getAuditingFindingsCount() {
        return this.auditingFindingsCount;
    }

    public Integer getAuthorizationControlFindingsCount() {
        return this.authorizationControlFindingsCount;
    }

    public Integer getDataEncryptionFindingsCount() {
        return this.dataEncryptionFindingsCount;
    }

    public Integer getDbConfigurationFindingsCount() {
        return this.dbConfigurationFindingsCount;
    }

    public Integer getFineGrainedAccessControlFindingsCount() {
        return this.fineGrainedAccessControlFindingsCount;
    }

    public Integer getPrivilegesAndRolesFindingsCount() {
        return this.privilegesAndRolesFindingsCount;
    }

    public Integer getUserAccountsFindingsCount() {
        return this.userAccountsFindingsCount;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SectionStatistics(");
        sb.append("super=").append(super.toString());
        sb.append("targetsCount=").append(String.valueOf(this.targetsCount));
        sb.append(", auditingFindingsCount=").append(String.valueOf(this.auditingFindingsCount));
        sb.append(", authorizationControlFindingsCount=").append(String.valueOf(this.authorizationControlFindingsCount));
        sb.append(", dataEncryptionFindingsCount=").append(String.valueOf(this.dataEncryptionFindingsCount));
        sb.append(", dbConfigurationFindingsCount=").append(String.valueOf(this.dbConfigurationFindingsCount));
        sb.append(", fineGrainedAccessControlFindingsCount=").append(String.valueOf(this.fineGrainedAccessControlFindingsCount));
        sb.append(", privilegesAndRolesFindingsCount=").append(String.valueOf(this.privilegesAndRolesFindingsCount));
        sb.append(", userAccountsFindingsCount=").append(String.valueOf(this.userAccountsFindingsCount));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SectionStatistics)) {
            return false;
        }
        SectionStatistics other = (SectionStatistics)((Object)o);
        return Objects.equals(this.targetsCount, other.targetsCount) && Objects.equals(this.auditingFindingsCount, other.auditingFindingsCount) && Objects.equals(this.authorizationControlFindingsCount, other.authorizationControlFindingsCount) && Objects.equals(this.dataEncryptionFindingsCount, other.dataEncryptionFindingsCount) && Objects.equals(this.dbConfigurationFindingsCount, other.dbConfigurationFindingsCount) && Objects.equals(this.fineGrainedAccessControlFindingsCount, other.fineGrainedAccessControlFindingsCount) && Objects.equals(this.privilegesAndRolesFindingsCount, other.privilegesAndRolesFindingsCount) && Objects.equals(this.userAccountsFindingsCount, other.userAccountsFindingsCount) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.targetsCount == null ? 43 : this.targetsCount.hashCode());
        result = result * 59 + (this.auditingFindingsCount == null ? 43 : this.auditingFindingsCount.hashCode());
        result = result * 59 + (this.authorizationControlFindingsCount == null ? 43 : this.authorizationControlFindingsCount.hashCode());
        result = result * 59 + (this.dataEncryptionFindingsCount == null ? 43 : this.dataEncryptionFindingsCount.hashCode());
        result = result * 59 + (this.dbConfigurationFindingsCount == null ? 43 : this.dbConfigurationFindingsCount.hashCode());
        result = result * 59 + (this.fineGrainedAccessControlFindingsCount == null ? 43 : this.fineGrainedAccessControlFindingsCount.hashCode());
        result = result * 59 + (this.privilegesAndRolesFindingsCount == null ? 43 : this.privilegesAndRolesFindingsCount.hashCode());
        result = result * 59 + (this.userAccountsFindingsCount == null ? 43 : this.userAccountsFindingsCount.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="targetsCount")
        private Integer targetsCount;
        @JsonProperty(value="auditingFindingsCount")
        private Integer auditingFindingsCount;
        @JsonProperty(value="authorizationControlFindingsCount")
        private Integer authorizationControlFindingsCount;
        @JsonProperty(value="dataEncryptionFindingsCount")
        private Integer dataEncryptionFindingsCount;
        @JsonProperty(value="dbConfigurationFindingsCount")
        private Integer dbConfigurationFindingsCount;
        @JsonProperty(value="fineGrainedAccessControlFindingsCount")
        private Integer fineGrainedAccessControlFindingsCount;
        @JsonProperty(value="privilegesAndRolesFindingsCount")
        private Integer privilegesAndRolesFindingsCount;
        @JsonProperty(value="userAccountsFindingsCount")
        private Integer userAccountsFindingsCount;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder targetsCount(Integer targetsCount) {
            this.targetsCount = targetsCount;
            this.__explicitlySet__.add("targetsCount");
            return this;
        }

        public Builder auditingFindingsCount(Integer auditingFindingsCount) {
            this.auditingFindingsCount = auditingFindingsCount;
            this.__explicitlySet__.add("auditingFindingsCount");
            return this;
        }

        public Builder authorizationControlFindingsCount(Integer authorizationControlFindingsCount) {
            this.authorizationControlFindingsCount = authorizationControlFindingsCount;
            this.__explicitlySet__.add("authorizationControlFindingsCount");
            return this;
        }

        public Builder dataEncryptionFindingsCount(Integer dataEncryptionFindingsCount) {
            this.dataEncryptionFindingsCount = dataEncryptionFindingsCount;
            this.__explicitlySet__.add("dataEncryptionFindingsCount");
            return this;
        }

        public Builder dbConfigurationFindingsCount(Integer dbConfigurationFindingsCount) {
            this.dbConfigurationFindingsCount = dbConfigurationFindingsCount;
            this.__explicitlySet__.add("dbConfigurationFindingsCount");
            return this;
        }

        public Builder fineGrainedAccessControlFindingsCount(Integer fineGrainedAccessControlFindingsCount) {
            this.fineGrainedAccessControlFindingsCount = fineGrainedAccessControlFindingsCount;
            this.__explicitlySet__.add("fineGrainedAccessControlFindingsCount");
            return this;
        }

        public Builder privilegesAndRolesFindingsCount(Integer privilegesAndRolesFindingsCount) {
            this.privilegesAndRolesFindingsCount = privilegesAndRolesFindingsCount;
            this.__explicitlySet__.add("privilegesAndRolesFindingsCount");
            return this;
        }

        public Builder userAccountsFindingsCount(Integer userAccountsFindingsCount) {
            this.userAccountsFindingsCount = userAccountsFindingsCount;
            this.__explicitlySet__.add("userAccountsFindingsCount");
            return this;
        }

        public SectionStatistics build() {
            SectionStatistics model = new SectionStatistics(this.targetsCount, this.auditingFindingsCount, this.authorizationControlFindingsCount, this.dataEncryptionFindingsCount, this.dbConfigurationFindingsCount, this.fineGrainedAccessControlFindingsCount, this.privilegesAndRolesFindingsCount, this.userAccountsFindingsCount);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SectionStatistics model) {
            if (model.wasPropertyExplicitlySet("targetsCount")) {
                this.targetsCount(model.getTargetsCount());
            }
            if (model.wasPropertyExplicitlySet("auditingFindingsCount")) {
                this.auditingFindingsCount(model.getAuditingFindingsCount());
            }
            if (model.wasPropertyExplicitlySet("authorizationControlFindingsCount")) {
                this.authorizationControlFindingsCount(model.getAuthorizationControlFindingsCount());
            }
            if (model.wasPropertyExplicitlySet("dataEncryptionFindingsCount")) {
                this.dataEncryptionFindingsCount(model.getDataEncryptionFindingsCount());
            }
            if (model.wasPropertyExplicitlySet("dbConfigurationFindingsCount")) {
                this.dbConfigurationFindingsCount(model.getDbConfigurationFindingsCount());
            }
            if (model.wasPropertyExplicitlySet("fineGrainedAccessControlFindingsCount")) {
                this.fineGrainedAccessControlFindingsCount(model.getFineGrainedAccessControlFindingsCount());
            }
            if (model.wasPropertyExplicitlySet("privilegesAndRolesFindingsCount")) {
                this.privilegesAndRolesFindingsCount(model.getPrivilegesAndRolesFindingsCount());
            }
            if (model.wasPropertyExplicitlySet("userAccountsFindingsCount")) {
                this.userAccountsFindingsCount(model.getUserAccountsFindingsCount());
            }
            return this;
        }
    }
}

