/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.SqlFirewallPolicyLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlFirewallPolicyDimensions
extends ExplicitlySetBmcModel {
    @JsonProperty(value="securityPolicyId")
    private final String securityPolicyId;
    @JsonProperty(value="enforcementScope")
    private final EnforcementScope enforcementScope;
    @JsonProperty(value="violationAction")
    private final ViolationAction violationAction;
    @JsonProperty(value="lifecycleState")
    private final SqlFirewallPolicyLifecycleState lifecycleState;

    @Deprecated
    @ConstructorProperties(value={"securityPolicyId", "enforcementScope", "violationAction", "lifecycleState"})
    public SqlFirewallPolicyDimensions(String securityPolicyId, EnforcementScope enforcementScope, ViolationAction violationAction, SqlFirewallPolicyLifecycleState lifecycleState) {
        this.securityPolicyId = securityPolicyId;
        this.enforcementScope = enforcementScope;
        this.violationAction = violationAction;
        this.lifecycleState = lifecycleState;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSecurityPolicyId() {
        return this.securityPolicyId;
    }

    public EnforcementScope getEnforcementScope() {
        return this.enforcementScope;
    }

    public ViolationAction getViolationAction() {
        return this.violationAction;
    }

    public SqlFirewallPolicyLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlFirewallPolicyDimensions(");
        sb.append("super=").append(super.toString());
        sb.append("securityPolicyId=").append(String.valueOf(this.securityPolicyId));
        sb.append(", enforcementScope=").append(String.valueOf((Object)this.enforcementScope));
        sb.append(", violationAction=").append(String.valueOf((Object)this.violationAction));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFirewallPolicyDimensions)) {
            return false;
        }
        SqlFirewallPolicyDimensions other = (SqlFirewallPolicyDimensions)((Object)o);
        return Objects.equals(this.securityPolicyId, other.securityPolicyId) && Objects.equals((Object)this.enforcementScope, (Object)other.enforcementScope) && Objects.equals((Object)this.violationAction, (Object)other.violationAction) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.securityPolicyId == null ? 43 : this.securityPolicyId.hashCode());
        result = result * 59 + (this.enforcementScope == null ? 43 : this.enforcementScope.hashCode());
        result = result * 59 + (this.violationAction == null ? 43 : this.violationAction.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ViolationAction implements BmcEnum
    {
        Block("BLOCK"),
        Observe("OBSERVE"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ViolationAction> map;

        private ViolationAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ViolationAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ViolationAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ViolationAction.class);
            map = new HashMap<String, ViolationAction>();
            for (ViolationAction v : ViolationAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum EnforcementScope implements BmcEnum
    {
        EnforceContext("ENFORCE_CONTEXT"),
        EnforceSql("ENFORCE_SQL"),
        EnforceAll("ENFORCE_ALL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, EnforcementScope> map;

        private EnforcementScope(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static EnforcementScope create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'EnforcementScope', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(EnforcementScope.class);
            map = new HashMap<String, EnforcementScope>();
            for (EnforcementScope v : EnforcementScope.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="securityPolicyId")
        private String securityPolicyId;
        @JsonProperty(value="enforcementScope")
        private EnforcementScope enforcementScope;
        @JsonProperty(value="violationAction")
        private ViolationAction violationAction;
        @JsonProperty(value="lifecycleState")
        private SqlFirewallPolicyLifecycleState lifecycleState;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder securityPolicyId(String securityPolicyId) {
            this.securityPolicyId = securityPolicyId;
            this.__explicitlySet__.add("securityPolicyId");
            return this;
        }

        public Builder enforcementScope(EnforcementScope enforcementScope) {
            this.enforcementScope = enforcementScope;
            this.__explicitlySet__.add("enforcementScope");
            return this;
        }

        public Builder violationAction(ViolationAction violationAction) {
            this.violationAction = violationAction;
            this.__explicitlySet__.add("violationAction");
            return this;
        }

        public Builder lifecycleState(SqlFirewallPolicyLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public SqlFirewallPolicyDimensions build() {
            SqlFirewallPolicyDimensions model = new SqlFirewallPolicyDimensions(this.securityPolicyId, this.enforcementScope, this.violationAction, this.lifecycleState);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlFirewallPolicyDimensions model) {
            if (model.wasPropertyExplicitlySet("securityPolicyId")) {
                this.securityPolicyId(model.getSecurityPolicyId());
            }
            if (model.wasPropertyExplicitlySet("enforcementScope")) {
                this.enforcementScope(model.getEnforcementScope());
            }
            if (model.wasPropertyExplicitlySet("violationAction")) {
                this.violationAction(model.getViolationAction());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            return this;
        }
    }
}

