/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class SqlFirewallViolationSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="dbUserName")
    private final String dbUserName;
    @JsonProperty(value="targetId")
    private final String targetId;
    @JsonProperty(value="targetName")
    private final String targetName;
    @JsonProperty(value="operationTime")
    private final Date operationTime;
    @JsonProperty(value="timeCollected")
    private final Date timeCollected;
    @JsonProperty(value="clientOsUserName")
    private final String clientOsUserName;
    @JsonProperty(value="operation")
    private final String operation;
    @JsonProperty(value="sqlText")
    private final String sqlText;
    @JsonProperty(value="sqlAccessedObjects")
    private final String sqlAccessedObjects;
    @JsonProperty(value="currentDbUserName")
    private final String currentDbUserName;
    @JsonProperty(value="sqlLevel")
    private final SqlLevel sqlLevel;
    @JsonProperty(value="clientIp")
    private final String clientIp;
    @JsonProperty(value="clientProgram")
    private final String clientProgram;
    @JsonProperty(value="violationCause")
    private final String violationCause;
    @JsonProperty(value="violationAction")
    private final ViolationAction violationAction;

    @Deprecated
    @ConstructorProperties(value={"id", "compartmentId", "dbUserName", "targetId", "targetName", "operationTime", "timeCollected", "clientOsUserName", "operation", "sqlText", "sqlAccessedObjects", "currentDbUserName", "sqlLevel", "clientIp", "clientProgram", "violationCause", "violationAction"})
    public SqlFirewallViolationSummary(String id, String compartmentId, String dbUserName, String targetId, String targetName, Date operationTime, Date timeCollected, String clientOsUserName, String operation, String sqlText, String sqlAccessedObjects, String currentDbUserName, SqlLevel sqlLevel, String clientIp, String clientProgram, String violationCause, ViolationAction violationAction) {
        this.id = id;
        this.compartmentId = compartmentId;
        this.dbUserName = dbUserName;
        this.targetId = targetId;
        this.targetName = targetName;
        this.operationTime = operationTime;
        this.timeCollected = timeCollected;
        this.clientOsUserName = clientOsUserName;
        this.operation = operation;
        this.sqlText = sqlText;
        this.sqlAccessedObjects = sqlAccessedObjects;
        this.currentDbUserName = currentDbUserName;
        this.sqlLevel = sqlLevel;
        this.clientIp = clientIp;
        this.clientProgram = clientProgram;
        this.violationCause = violationCause;
        this.violationAction = violationAction;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDbUserName() {
        return this.dbUserName;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public String getTargetName() {
        return this.targetName;
    }

    public Date getOperationTime() {
        return this.operationTime;
    }

    public Date getTimeCollected() {
        return this.timeCollected;
    }

    public String getClientOsUserName() {
        return this.clientOsUserName;
    }

    public String getOperation() {
        return this.operation;
    }

    public String getSqlText() {
        return this.sqlText;
    }

    public String getSqlAccessedObjects() {
        return this.sqlAccessedObjects;
    }

    public String getCurrentDbUserName() {
        return this.currentDbUserName;
    }

    public SqlLevel getSqlLevel() {
        return this.sqlLevel;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public String getClientProgram() {
        return this.clientProgram;
    }

    public String getViolationCause() {
        return this.violationCause;
    }

    public ViolationAction getViolationAction() {
        return this.violationAction;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("SqlFirewallViolationSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", dbUserName=").append(String.valueOf(this.dbUserName));
        sb.append(", targetId=").append(String.valueOf(this.targetId));
        sb.append(", targetName=").append(String.valueOf(this.targetName));
        sb.append(", operationTime=").append(String.valueOf(this.operationTime));
        sb.append(", timeCollected=").append(String.valueOf(this.timeCollected));
        sb.append(", clientOsUserName=").append(String.valueOf(this.clientOsUserName));
        sb.append(", operation=").append(String.valueOf(this.operation));
        sb.append(", sqlText=").append(String.valueOf(this.sqlText));
        sb.append(", sqlAccessedObjects=").append(String.valueOf(this.sqlAccessedObjects));
        sb.append(", currentDbUserName=").append(String.valueOf(this.currentDbUserName));
        sb.append(", sqlLevel=").append(String.valueOf((Object)this.sqlLevel));
        sb.append(", clientIp=").append(String.valueOf(this.clientIp));
        sb.append(", clientProgram=").append(String.valueOf(this.clientProgram));
        sb.append(", violationCause=").append(String.valueOf(this.violationCause));
        sb.append(", violationAction=").append(String.valueOf((Object)this.violationAction));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFirewallViolationSummary)) {
            return false;
        }
        SqlFirewallViolationSummary other = (SqlFirewallViolationSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.dbUserName, other.dbUserName) && Objects.equals(this.targetId, other.targetId) && Objects.equals(this.targetName, other.targetName) && Objects.equals(this.operationTime, other.operationTime) && Objects.equals(this.timeCollected, other.timeCollected) && Objects.equals(this.clientOsUserName, other.clientOsUserName) && Objects.equals(this.operation, other.operation) && Objects.equals(this.sqlText, other.sqlText) && Objects.equals(this.sqlAccessedObjects, other.sqlAccessedObjects) && Objects.equals(this.currentDbUserName, other.currentDbUserName) && Objects.equals((Object)this.sqlLevel, (Object)other.sqlLevel) && Objects.equals(this.clientIp, other.clientIp) && Objects.equals(this.clientProgram, other.clientProgram) && Objects.equals(this.violationCause, other.violationCause) && Objects.equals((Object)this.violationAction, (Object)other.violationAction) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.dbUserName == null ? 43 : this.dbUserName.hashCode());
        result = result * 59 + (this.targetId == null ? 43 : this.targetId.hashCode());
        result = result * 59 + (this.targetName == null ? 43 : this.targetName.hashCode());
        result = result * 59 + (this.operationTime == null ? 43 : this.operationTime.hashCode());
        result = result * 59 + (this.timeCollected == null ? 43 : this.timeCollected.hashCode());
        result = result * 59 + (this.clientOsUserName == null ? 43 : this.clientOsUserName.hashCode());
        result = result * 59 + (this.operation == null ? 43 : this.operation.hashCode());
        result = result * 59 + (this.sqlText == null ? 43 : this.sqlText.hashCode());
        result = result * 59 + (this.sqlAccessedObjects == null ? 43 : this.sqlAccessedObjects.hashCode());
        result = result * 59 + (this.currentDbUserName == null ? 43 : this.currentDbUserName.hashCode());
        result = result * 59 + (this.sqlLevel == null ? 43 : this.sqlLevel.hashCode());
        result = result * 59 + (this.clientIp == null ? 43 : this.clientIp.hashCode());
        result = result * 59 + (this.clientProgram == null ? 43 : this.clientProgram.hashCode());
        result = result * 59 + (this.violationCause == null ? 43 : this.violationCause.hashCode());
        result = result * 59 + (this.violationAction == null ? 43 : this.violationAction.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum ViolationAction implements BmcEnum
    {
        Blocked("BLOCKED"),
        Allowed("ALLOWED"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, ViolationAction> map;

        private ViolationAction(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static ViolationAction create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'ViolationAction', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(ViolationAction.class);
            map = new HashMap<String, ViolationAction>();
            for (ViolationAction v : ViolationAction.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SqlLevel implements BmcEnum
    {
        UserIssuedSql("USER_ISSUED_SQL"),
        AllSql("ALL_SQL"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, SqlLevel> map;

        private SqlLevel(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SqlLevel create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'SqlLevel', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(SqlLevel.class);
            map = new HashMap<String, SqlLevel>();
            for (SqlLevel v : SqlLevel.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="dbUserName")
        private String dbUserName;
        @JsonProperty(value="targetId")
        private String targetId;
        @JsonProperty(value="targetName")
        private String targetName;
        @JsonProperty(value="operationTime")
        private Date operationTime;
        @JsonProperty(value="timeCollected")
        private Date timeCollected;
        @JsonProperty(value="clientOsUserName")
        private String clientOsUserName;
        @JsonProperty(value="operation")
        private String operation;
        @JsonProperty(value="sqlText")
        private String sqlText;
        @JsonProperty(value="sqlAccessedObjects")
        private String sqlAccessedObjects;
        @JsonProperty(value="currentDbUserName")
        private String currentDbUserName;
        @JsonProperty(value="sqlLevel")
        private SqlLevel sqlLevel;
        @JsonProperty(value="clientIp")
        private String clientIp;
        @JsonProperty(value="clientProgram")
        private String clientProgram;
        @JsonProperty(value="violationCause")
        private String violationCause;
        @JsonProperty(value="violationAction")
        private ViolationAction violationAction;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder dbUserName(String dbUserName) {
            this.dbUserName = dbUserName;
            this.__explicitlySet__.add("dbUserName");
            return this;
        }

        public Builder targetId(String targetId) {
            this.targetId = targetId;
            this.__explicitlySet__.add("targetId");
            return this;
        }

        public Builder targetName(String targetName) {
            this.targetName = targetName;
            this.__explicitlySet__.add("targetName");
            return this;
        }

        public Builder operationTime(Date operationTime) {
            this.operationTime = operationTime;
            this.__explicitlySet__.add("operationTime");
            return this;
        }

        public Builder timeCollected(Date timeCollected) {
            this.timeCollected = timeCollected;
            this.__explicitlySet__.add("timeCollected");
            return this;
        }

        public Builder clientOsUserName(String clientOsUserName) {
            this.clientOsUserName = clientOsUserName;
            this.__explicitlySet__.add("clientOsUserName");
            return this;
        }

        public Builder operation(String operation) {
            this.operation = operation;
            this.__explicitlySet__.add("operation");
            return this;
        }

        public Builder sqlText(String sqlText) {
            this.sqlText = sqlText;
            this.__explicitlySet__.add("sqlText");
            return this;
        }

        public Builder sqlAccessedObjects(String sqlAccessedObjects) {
            this.sqlAccessedObjects = sqlAccessedObjects;
            this.__explicitlySet__.add("sqlAccessedObjects");
            return this;
        }

        public Builder currentDbUserName(String currentDbUserName) {
            this.currentDbUserName = currentDbUserName;
            this.__explicitlySet__.add("currentDbUserName");
            return this;
        }

        public Builder sqlLevel(SqlLevel sqlLevel) {
            this.sqlLevel = sqlLevel;
            this.__explicitlySet__.add("sqlLevel");
            return this;
        }

        public Builder clientIp(String clientIp) {
            this.clientIp = clientIp;
            this.__explicitlySet__.add("clientIp");
            return this;
        }

        public Builder clientProgram(String clientProgram) {
            this.clientProgram = clientProgram;
            this.__explicitlySet__.add("clientProgram");
            return this;
        }

        public Builder violationCause(String violationCause) {
            this.violationCause = violationCause;
            this.__explicitlySet__.add("violationCause");
            return this;
        }

        public Builder violationAction(ViolationAction violationAction) {
            this.violationAction = violationAction;
            this.__explicitlySet__.add("violationAction");
            return this;
        }

        public SqlFirewallViolationSummary build() {
            SqlFirewallViolationSummary model = new SqlFirewallViolationSummary(this.id, this.compartmentId, this.dbUserName, this.targetId, this.targetName, this.operationTime, this.timeCollected, this.clientOsUserName, this.operation, this.sqlText, this.sqlAccessedObjects, this.currentDbUserName, this.sqlLevel, this.clientIp, this.clientProgram, this.violationCause, this.violationAction);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(SqlFirewallViolationSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("dbUserName")) {
                this.dbUserName(model.getDbUserName());
            }
            if (model.wasPropertyExplicitlySet("targetId")) {
                this.targetId(model.getTargetId());
            }
            if (model.wasPropertyExplicitlySet("targetName")) {
                this.targetName(model.getTargetName());
            }
            if (model.wasPropertyExplicitlySet("operationTime")) {
                this.operationTime(model.getOperationTime());
            }
            if (model.wasPropertyExplicitlySet("timeCollected")) {
                this.timeCollected(model.getTimeCollected());
            }
            if (model.wasPropertyExplicitlySet("clientOsUserName")) {
                this.clientOsUserName(model.getClientOsUserName());
            }
            if (model.wasPropertyExplicitlySet("operation")) {
                this.operation(model.getOperation());
            }
            if (model.wasPropertyExplicitlySet("sqlText")) {
                this.sqlText(model.getSqlText());
            }
            if (model.wasPropertyExplicitlySet("sqlAccessedObjects")) {
                this.sqlAccessedObjects(model.getSqlAccessedObjects());
            }
            if (model.wasPropertyExplicitlySet("currentDbUserName")) {
                this.currentDbUserName(model.getCurrentDbUserName());
            }
            if (model.wasPropertyExplicitlySet("sqlLevel")) {
                this.sqlLevel(model.getSqlLevel());
            }
            if (model.wasPropertyExplicitlySet("clientIp")) {
                this.clientIp(model.getClientIp());
            }
            if (model.wasPropertyExplicitlySet("clientProgram")) {
                this.clientProgram(model.getClientProgram());
            }
            if (model.wasPropertyExplicitlySet("violationCause")) {
                this.violationCause(model.getViolationCause());
            }
            if (model.wasPropertyExplicitlySet("violationAction")) {
                this.violationAction(model.getViolationAction());
            }
            return this;
        }
    }
}

