/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.datasafe.model.UserAssessmentLifecycleState;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class UserAssessment
extends ExplicitlySetBmcModel {
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="ignoredTargets")
    private final List<Object> ignoredTargets;
    @JsonProperty(value="ignoredAssessmentIds")
    private final List<Object> ignoredAssessmentIds;
    @JsonProperty(value="isBaseline")
    private final Boolean isBaseline;
    @JsonProperty(value="isDeviatedFromBaseline")
    private final Boolean isDeviatedFromBaseline;
    @JsonProperty(value="lastComparedBaselineId")
    private final String lastComparedBaselineId;
    @JsonProperty(value="lifecycleState")
    private final UserAssessmentLifecycleState lifecycleState;
    @JsonProperty(value="lifecycleDetails")
    private final String lifecycleDetails;
    @JsonProperty(value="scheduleAssessmentId")
    private final String scheduleAssessmentId;
    @JsonProperty(value="schedule")
    private final String schedule;
    @JsonProperty(value="statistics")
    private final Map<String, Map<String, Object>> statistics;
    @JsonProperty(value="targetIds")
    private final List<String> targetIds;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="timeUpdated")
    private final Date timeUpdated;
    @JsonProperty(value="timeLastAssessed")
    private final Date timeLastAssessed;
    @JsonProperty(value="triggeredBy")
    private final TriggeredBy triggeredBy;
    @JsonProperty(value="type")
    private final Type type;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;

    @Deprecated
    @ConstructorProperties(value={"compartmentId", "description", "displayName", "id", "ignoredTargets", "ignoredAssessmentIds", "isBaseline", "isDeviatedFromBaseline", "lastComparedBaselineId", "lifecycleState", "lifecycleDetails", "scheduleAssessmentId", "schedule", "statistics", "targetIds", "timeCreated", "timeUpdated", "timeLastAssessed", "triggeredBy", "type", "freeformTags", "definedTags", "systemTags"})
    public UserAssessment(String compartmentId, String description, String displayName, String id, List<Object> ignoredTargets, List<Object> ignoredAssessmentIds, Boolean isBaseline, Boolean isDeviatedFromBaseline, String lastComparedBaselineId, UserAssessmentLifecycleState lifecycleState, String lifecycleDetails, String scheduleAssessmentId, String schedule, Map<String, Map<String, Object>> statistics, List<String> targetIds, Date timeCreated, Date timeUpdated, Date timeLastAssessed, TriggeredBy triggeredBy, Type type, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags) {
        this.compartmentId = compartmentId;
        this.description = description;
        this.displayName = displayName;
        this.id = id;
        this.ignoredTargets = ignoredTargets;
        this.ignoredAssessmentIds = ignoredAssessmentIds;
        this.isBaseline = isBaseline;
        this.isDeviatedFromBaseline = isDeviatedFromBaseline;
        this.lastComparedBaselineId = lastComparedBaselineId;
        this.lifecycleState = lifecycleState;
        this.lifecycleDetails = lifecycleDetails;
        this.scheduleAssessmentId = scheduleAssessmentId;
        this.schedule = schedule;
        this.statistics = statistics;
        this.targetIds = targetIds;
        this.timeCreated = timeCreated;
        this.timeUpdated = timeUpdated;
        this.timeLastAssessed = timeLastAssessed;
        this.triggeredBy = triggeredBy;
        this.type = type;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public List<Object> getIgnoredTargets() {
        return this.ignoredTargets;
    }

    public List<Object> getIgnoredAssessmentIds() {
        return this.ignoredAssessmentIds;
    }

    public Boolean getIsBaseline() {
        return this.isBaseline;
    }

    public Boolean getIsDeviatedFromBaseline() {
        return this.isDeviatedFromBaseline;
    }

    public String getLastComparedBaselineId() {
        return this.lastComparedBaselineId;
    }

    public UserAssessmentLifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public String getLifecycleDetails() {
        return this.lifecycleDetails;
    }

    public String getScheduleAssessmentId() {
        return this.scheduleAssessmentId;
    }

    public String getSchedule() {
        return this.schedule;
    }

    public Map<String, Map<String, Object>> getStatistics() {
        return this.statistics;
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public Date getTimeUpdated() {
        return this.timeUpdated;
    }

    public Date getTimeLastAssessed() {
        return this.timeLastAssessed;
    }

    public TriggeredBy getTriggeredBy() {
        return this.triggeredBy;
    }

    public Type getType() {
        return this.type;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("UserAssessment(");
        sb.append("super=").append(super.toString());
        sb.append("compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", ignoredTargets=").append(String.valueOf(this.ignoredTargets));
        sb.append(", ignoredAssessmentIds=").append(String.valueOf(this.ignoredAssessmentIds));
        sb.append(", isBaseline=").append(String.valueOf(this.isBaseline));
        sb.append(", isDeviatedFromBaseline=").append(String.valueOf(this.isDeviatedFromBaseline));
        sb.append(", lastComparedBaselineId=").append(String.valueOf(this.lastComparedBaselineId));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", lifecycleDetails=").append(String.valueOf(this.lifecycleDetails));
        sb.append(", scheduleAssessmentId=").append(String.valueOf(this.scheduleAssessmentId));
        sb.append(", schedule=").append(String.valueOf(this.schedule));
        sb.append(", statistics=").append(String.valueOf(this.statistics));
        sb.append(", targetIds=").append(String.valueOf(this.targetIds));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", timeUpdated=").append(String.valueOf(this.timeUpdated));
        sb.append(", timeLastAssessed=").append(String.valueOf(this.timeLastAssessed));
        sb.append(", triggeredBy=").append(String.valueOf((Object)this.triggeredBy));
        sb.append(", type=").append(String.valueOf((Object)this.type));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserAssessment)) {
            return false;
        }
        UserAssessment other = (UserAssessment)((Object)o);
        return Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.description, other.description) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.id, other.id) && Objects.equals(this.ignoredTargets, other.ignoredTargets) && Objects.equals(this.ignoredAssessmentIds, other.ignoredAssessmentIds) && Objects.equals(this.isBaseline, other.isBaseline) && Objects.equals(this.isDeviatedFromBaseline, other.isDeviatedFromBaseline) && Objects.equals(this.lastComparedBaselineId, other.lastComparedBaselineId) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.lifecycleDetails, other.lifecycleDetails) && Objects.equals(this.scheduleAssessmentId, other.scheduleAssessmentId) && Objects.equals(this.schedule, other.schedule) && Objects.equals(this.statistics, other.statistics) && Objects.equals(this.targetIds, other.targetIds) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.timeUpdated, other.timeUpdated) && Objects.equals(this.timeLastAssessed, other.timeLastAssessed) && Objects.equals((Object)this.triggeredBy, (Object)other.triggeredBy) && Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.ignoredTargets == null ? 43 : this.ignoredTargets.hashCode());
        result = result * 59 + (this.ignoredAssessmentIds == null ? 43 : this.ignoredAssessmentIds.hashCode());
        result = result * 59 + (this.isBaseline == null ? 43 : this.isBaseline.hashCode());
        result = result * 59 + (this.isDeviatedFromBaseline == null ? 43 : this.isDeviatedFromBaseline.hashCode());
        result = result * 59 + (this.lastComparedBaselineId == null ? 43 : this.lastComparedBaselineId.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.lifecycleDetails == null ? 43 : this.lifecycleDetails.hashCode());
        result = result * 59 + (this.scheduleAssessmentId == null ? 43 : this.scheduleAssessmentId.hashCode());
        result = result * 59 + (this.schedule == null ? 43 : this.schedule.hashCode());
        result = result * 59 + (this.statistics == null ? 43 : this.statistics.hashCode());
        result = result * 59 + (this.targetIds == null ? 43 : this.targetIds.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.timeUpdated == null ? 43 : this.timeUpdated.hashCode());
        result = result * 59 + (this.timeLastAssessed == null ? 43 : this.timeLastAssessed.hashCode());
        result = result * 59 + (this.triggeredBy == null ? 43 : this.triggeredBy.hashCode());
        result = result * 59 + (this.type == null ? 43 : this.type.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Type implements BmcEnum
    {
        Latest("LATEST"),
        Saved("SAVED"),
        SaveSchedule("SAVE_SCHEDULE"),
        Compartment("COMPARTMENT"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Type> map;

        private Type(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Type create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Type', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Type.class);
            map = new HashMap<String, Type>();
            for (Type v : Type.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TriggeredBy implements BmcEnum
    {
        User("USER"),
        System("SYSTEM"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, TriggeredBy> map;

        private TriggeredBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TriggeredBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'TriggeredBy', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(TriggeredBy.class);
            map = new HashMap<String, TriggeredBy>();
            for (TriggeredBy v : TriggeredBy.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="ignoredTargets")
        private List<Object> ignoredTargets;
        @JsonProperty(value="ignoredAssessmentIds")
        private List<Object> ignoredAssessmentIds;
        @JsonProperty(value="isBaseline")
        private Boolean isBaseline;
        @JsonProperty(value="isDeviatedFromBaseline")
        private Boolean isDeviatedFromBaseline;
        @JsonProperty(value="lastComparedBaselineId")
        private String lastComparedBaselineId;
        @JsonProperty(value="lifecycleState")
        private UserAssessmentLifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="scheduleAssessmentId")
        private String scheduleAssessmentId;
        @JsonProperty(value="schedule")
        private String schedule;
        @JsonProperty(value="statistics")
        private Map<String, Map<String, Object>> statistics;
        @JsonProperty(value="targetIds")
        private List<String> targetIds;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="timeLastAssessed")
        private Date timeLastAssessed;
        @JsonProperty(value="triggeredBy")
        private TriggeredBy triggeredBy;
        @JsonProperty(value="type")
        private Type type;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder ignoredTargets(List<Object> ignoredTargets) {
            this.ignoredTargets = ignoredTargets;
            this.__explicitlySet__.add("ignoredTargets");
            return this;
        }

        public Builder ignoredAssessmentIds(List<Object> ignoredAssessmentIds) {
            this.ignoredAssessmentIds = ignoredAssessmentIds;
            this.__explicitlySet__.add("ignoredAssessmentIds");
            return this;
        }

        public Builder isBaseline(Boolean isBaseline) {
            this.isBaseline = isBaseline;
            this.__explicitlySet__.add("isBaseline");
            return this;
        }

        public Builder isDeviatedFromBaseline(Boolean isDeviatedFromBaseline) {
            this.isDeviatedFromBaseline = isDeviatedFromBaseline;
            this.__explicitlySet__.add("isDeviatedFromBaseline");
            return this;
        }

        public Builder lastComparedBaselineId(String lastComparedBaselineId) {
            this.lastComparedBaselineId = lastComparedBaselineId;
            this.__explicitlySet__.add("lastComparedBaselineId");
            return this;
        }

        public Builder lifecycleState(UserAssessmentLifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder scheduleAssessmentId(String scheduleAssessmentId) {
            this.scheduleAssessmentId = scheduleAssessmentId;
            this.__explicitlySet__.add("scheduleAssessmentId");
            return this;
        }

        public Builder schedule(String schedule) {
            this.schedule = schedule;
            this.__explicitlySet__.add("schedule");
            return this;
        }

        public Builder statistics(Map<String, Map<String, Object>> statistics) {
            this.statistics = statistics;
            this.__explicitlySet__.add("statistics");
            return this;
        }

        public Builder targetIds(List<String> targetIds) {
            this.targetIds = targetIds;
            this.__explicitlySet__.add("targetIds");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder timeLastAssessed(Date timeLastAssessed) {
            this.timeLastAssessed = timeLastAssessed;
            this.__explicitlySet__.add("timeLastAssessed");
            return this;
        }

        public Builder triggeredBy(TriggeredBy triggeredBy) {
            this.triggeredBy = triggeredBy;
            this.__explicitlySet__.add("triggeredBy");
            return this;
        }

        public Builder type(Type type) {
            this.type = type;
            this.__explicitlySet__.add("type");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public UserAssessment build() {
            UserAssessment model = new UserAssessment(this.compartmentId, this.description, this.displayName, this.id, this.ignoredTargets, this.ignoredAssessmentIds, this.isBaseline, this.isDeviatedFromBaseline, this.lastComparedBaselineId, this.lifecycleState, this.lifecycleDetails, this.scheduleAssessmentId, this.schedule, this.statistics, this.targetIds, this.timeCreated, this.timeUpdated, this.timeLastAssessed, this.triggeredBy, this.type, this.freeformTags, this.definedTags, this.systemTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(UserAssessment model) {
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("ignoredTargets")) {
                this.ignoredTargets(model.getIgnoredTargets());
            }
            if (model.wasPropertyExplicitlySet("ignoredAssessmentIds")) {
                this.ignoredAssessmentIds(model.getIgnoredAssessmentIds());
            }
            if (model.wasPropertyExplicitlySet("isBaseline")) {
                this.isBaseline(model.getIsBaseline());
            }
            if (model.wasPropertyExplicitlySet("isDeviatedFromBaseline")) {
                this.isDeviatedFromBaseline(model.getIsDeviatedFromBaseline());
            }
            if (model.wasPropertyExplicitlySet("lastComparedBaselineId")) {
                this.lastComparedBaselineId(model.getLastComparedBaselineId());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("scheduleAssessmentId")) {
                this.scheduleAssessmentId(model.getScheduleAssessmentId());
            }
            if (model.wasPropertyExplicitlySet("schedule")) {
                this.schedule(model.getSchedule());
            }
            if (model.wasPropertyExplicitlySet("statistics")) {
                this.statistics(model.getStatistics());
            }
            if (model.wasPropertyExplicitlySet("targetIds")) {
                this.targetIds(model.getTargetIds());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("timeLastAssessed")) {
                this.timeLastAssessed(model.getTimeLastAssessed());
            }
            if (model.wasPropertyExplicitlySet("triggeredBy")) {
                this.triggeredBy(model.getTriggeredBy());
            }
            if (model.wasPropertyExplicitlySet("type")) {
                this.type(model.getType());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            return this;
        }
    }
}

