/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.datasafe.requests;

import com.oracle.bmc.InternalSdk;
import com.oracle.bmc.datasafe.model.CreatePeerTargetDatabaseDetails;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class CreatePeerTargetDatabaseRequest
extends BmcRequest<CreatePeerTargetDatabaseDetails> {
    private String targetDatabaseId;
    private CreatePeerTargetDatabaseDetails createPeerTargetDatabaseDetails;
    private String ifMatch;
    private String opcRequestId;
    private String opcRetryToken;

    public String getTargetDatabaseId() {
        return this.targetDatabaseId;
    }

    public CreatePeerTargetDatabaseDetails getCreatePeerTargetDatabaseDetails() {
        return this.createPeerTargetDatabaseDetails;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getOpcRetryToken() {
        return this.opcRetryToken;
    }

    @InternalSdk
    public CreatePeerTargetDatabaseDetails getBody$() {
        return this.createPeerTargetDatabaseDetails;
    }

    public Builder toBuilder() {
        return new Builder().targetDatabaseId(this.targetDatabaseId).createPeerTargetDatabaseDetails(this.createPeerTargetDatabaseDetails).ifMatch(this.ifMatch).opcRequestId(this.opcRequestId).opcRetryToken(this.opcRetryToken);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",targetDatabaseId=").append(String.valueOf(this.targetDatabaseId));
        sb.append(",createPeerTargetDatabaseDetails=").append(String.valueOf((Object)this.createPeerTargetDatabaseDetails));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",opcRetryToken=").append(String.valueOf(this.opcRetryToken));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreatePeerTargetDatabaseRequest)) {
            return false;
        }
        CreatePeerTargetDatabaseRequest other = (CreatePeerTargetDatabaseRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.targetDatabaseId, other.targetDatabaseId) && Objects.equals((Object)this.createPeerTargetDatabaseDetails, (Object)other.createPeerTargetDatabaseDetails) && Objects.equals(this.ifMatch, other.ifMatch) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.opcRetryToken, other.opcRetryToken);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.targetDatabaseId == null ? 43 : this.targetDatabaseId.hashCode());
        result = result * 59 + (this.createPeerTargetDatabaseDetails == null ? 43 : this.createPeerTargetDatabaseDetails.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.opcRetryToken == null ? 43 : this.opcRetryToken.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<CreatePeerTargetDatabaseRequest, CreatePeerTargetDatabaseDetails> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String targetDatabaseId = null;
        private CreatePeerTargetDatabaseDetails createPeerTargetDatabaseDetails = null;
        private String ifMatch = null;
        private String opcRequestId = null;
        private String opcRetryToken = null;

        public Builder targetDatabaseId(String targetDatabaseId) {
            this.targetDatabaseId = targetDatabaseId;
            return this;
        }

        public Builder createPeerTargetDatabaseDetails(CreatePeerTargetDatabaseDetails createPeerTargetDatabaseDetails) {
            this.createPeerTargetDatabaseDetails = createPeerTargetDatabaseDetails;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder opcRetryToken(String opcRetryToken) {
            this.opcRetryToken = opcRetryToken;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(CreatePeerTargetDatabaseRequest o) {
            this.targetDatabaseId(o.getTargetDatabaseId());
            this.createPeerTargetDatabaseDetails(o.getCreatePeerTargetDatabaseDetails());
            this.ifMatch(o.getIfMatch());
            this.opcRequestId(o.getOpcRequestId());
            this.opcRetryToken(o.getOpcRetryToken());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public CreatePeerTargetDatabaseRequest build() {
            CreatePeerTargetDatabaseRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        @InternalSdk
        public Builder body$(CreatePeerTargetDatabaseDetails body) {
            this.createPeerTargetDatabaseDetails(body);
            return this;
        }

        public CreatePeerTargetDatabaseRequest buildWithoutInvocationCallback() {
            CreatePeerTargetDatabaseRequest request = new CreatePeerTargetDatabaseRequest();
            request.targetDatabaseId = this.targetDatabaseId;
            request.createPeerTargetDatabaseDetails = this.createPeerTargetDatabaseDetails;
            request.ifMatch = this.ifMatch;
            request.opcRequestId = this.opcRequestId;
            request.opcRetryToken = this.opcRetryToken;
            return request;
        }
    }
}

